<?php

// Add Three Column section
$wp_customize->add_section( 'blogmax_three_column_posts_section',
    array(
        'title'             => esc_html__( 'Three Column','blogmax-news' ),
        'description'       => esc_html__( 'Three Column Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 31,
    )
);

// Three Column content enable control and setting
$wp_customize->add_setting( 'three_column_section_enable]',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'three_column_section_enable',
        array(
            'label'             => esc_html__( 'Three Column Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_three_column_posts_section',
            'on_off_label'      => blogmax_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'three_column_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'THREE COLUMN POSTS', 'blogmax-news' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'three_column_title',
    array(
        'label'             => esc_html__( 'Section Title', 'blogmax-news' ),
        'section'           => 'blogmax_three_column_posts_section',
        'active_callback'   => 'blogmax_news_is_three_column_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('three_column_title',
        array(
            'selector'            => '#blogmax_three_column_posts_section .section-header h2',
            'settings'            => 'three_column_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogmax_news_three_column_title_partial',
        )
    );
}


for ( $i = 1; $i <= 3; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'three_column_content_post_' . $i,
        array(
            'sanitize_callback' => 'blogmax_sanitize_page',
        )
    );

    $wp_customize->add_control( new Blogmax_News_Dropdown_Chooser( $wp_customize,
        'three_column_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'blogmax-news' ), $i ),
                'section'           => 'blogmax_three_column_posts_section',
                'choices'           => blogmax_post_choices(),
                'active_callback'   => 'blogmax_news_is_three_column_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('three_column_separator'. $i,
        array(
            'sanitize_callback'      => 'blogmax_sanitize_html',
        )
    );

    $wp_customize->add_control(new Blogmax_News_Customize_Horizontal_Line($wp_customize,
        'three_column_separator'. $i,
            array(
                'active_callback'       => 'blogmax_news_is_three_column_section_enable',
                'type'                  =>'hr',
                'section'               =>'blogmax_three_column_posts_section',
            )
        )
    );
    
endfor;