<?php

// Add Popular Post section
$wp_customize->add_section( 'blogmax_popular_posts_section',
    array(
        'title'             => esc_html__( 'Popular Post','blogmax-news' ),
        'description'       => esc_html__( 'Popular Post Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 36,
    )
);

// Popular Post content enable control and setting
$wp_customize->add_setting( 'popular_posts_section_enable]',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'popular_posts_section_enable',
        array(
            'label'             => esc_html__( 'Popular Post Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_popular_posts_section',
            'on_off_label'      => blogmax_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'popular_posts_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Popular Post', 'blogmax-news' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'popular_posts_title',
    array(
        'label'             => esc_html__( 'Section Title', 'blogmax-news' ),
        'section'           => 'blogmax_popular_posts_section',
        'active_callback'   => 'blogmax_news_is_popular_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('popular_posts_title',
        array(
            'selector'            => '#blogmax_popular_posts_section .section-header h2',
            'settings'            => 'popular_posts_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogmax_news_popular_posts_title_partial',
        )
    );
}


for ( $i = 1; $i <= 3; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'popular_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'blogmax_sanitize_page',
        )
    );

    $wp_customize->add_control( new Blogmax_News_Dropdown_Chooser( $wp_customize,
        'popular_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'blogmax-news' ), $i ),
                'section'           => 'blogmax_popular_posts_section',
                'choices'           => blogmax_post_choices(),
                'active_callback'   => 'blogmax_news_is_popular_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('popular_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'blogmax_sanitize_html',
        )
    );

    $wp_customize->add_control(new Blogmax_News_Customize_Horizontal_Line($wp_customize,
        'popular_posts_separator'. $i,
            array(
                'active_callback'       => 'blogmax_news_is_popular_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'blogmax_popular_posts_section',
            )
        )
    );
    
endfor;