<?php

// Add Most Viewed Posts section
$wp_customize->add_section( 'blogmax_most_viewed_posts_section',
    array(
        'title'             => esc_html__( 'Most Viewed Posts','blogmax-news' ),
        'description'       => esc_html__( 'Most Viewed Posts Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 35,
    )
);

// Most Viewed Posts content enable control and setting
$wp_customize->add_setting( 'most_viewed_posts_section_enable]',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'most_viewed_posts_section_enable',
        array(
            'label'             => esc_html__( 'Most Viewed Posts Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_most_viewed_posts_section',
            'on_off_label'      => blogmax_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'most_viewed_posts_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Most Viewed Posts', 'blogmax-news' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'most_viewed_posts_title',
    array(
        'label'             => esc_html__( 'Section Title', 'blogmax-news' ),
        'section'           => 'blogmax_most_viewed_posts_section',
        'active_callback'   => 'blogmax_news_is_most_viewed_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('most_viewed_posts_title',
        array(
            'selector'            => '#blogmax_most_viewed_posts_section .section-header h2',
            'settings'            => 'most_viewed_posts_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogmax_news_most_viewed_posts_title_partial',
        )
    );
}


for ( $i = 1; $i <= 2; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'most_viewed_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'blogmax_sanitize_page',
        )
    );

    $wp_customize->add_control( new Blogmax_News_Dropdown_Chooser( $wp_customize,
        'most_viewed_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'blogmax-news' ), $i ),
                'section'           => 'blogmax_most_viewed_posts_section',
                'choices'           => blogmax_post_choices(),
                'active_callback'   => 'blogmax_news_is_most_viewed_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('most_viewed_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'blogmax_sanitize_html',
        )
    );

    $wp_customize->add_control(new Blogmax_News_Customize_Horizontal_Line($wp_customize,
        'most_viewed_posts_separator'. $i,
            array(
                'active_callback'       => 'blogmax_news_is_most_viewed_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'blogmax_most_viewed_posts_section',
            )
        )
    );
    
endfor;