<?php

// Add Highlighted Posts section
$wp_customize->add_section( 'blogmax_highlighted_posts_section',
    array(
        'title'             => esc_html__( 'Highlighted Posts','blogmax-news' ),
        'description'       => esc_html__( 'Highlighted Posts Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 11,
    )
);

// Highlighted Posts content enable control and setting
$wp_customize->add_setting( 'highlighted_posts_section_enable',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'highlighted_posts_section_enable',
        array(
            'label'             => esc_html__( 'Highlighted Posts Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_highlighted_posts_section',
            'on_off_label'      => blogmax_switch_options(),
        ) 
    )
);

for ( $i = 1; $i <= 5; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'highlighted_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'blogmax_sanitize_page',
        )
    );

    $wp_customize->add_control( new Blogmax_News_Dropdown_Chooser( $wp_customize,
        'highlighted_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'blogmax-news' ), $i ),
                'section'           => 'blogmax_highlighted_posts_section',
                'choices'           => blogmax_post_choices(),
                'active_callback'   => 'blogmax_news_is_highlighted_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('highlighted_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'blogmax_sanitize_html',
        )
    );

    $wp_customize->add_control(new Blogmax_News_Customize_Horizontal_Line($wp_customize,
        'highlighted_posts_separator'. $i,
            array(
                'active_callback'       => 'blogmax_news_is_highlighted_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'blogmax_highlighted_posts_section',
            )
        )
    );
    
endfor;