<?php

// Add Advertisement section
$wp_customize->add_section( 'blogmax_advertisement_section',
    array(
        'title'             => esc_html__( 'Advertisement','blogmax-news' ),
        'description'       => esc_html__( 'Advertisement Section options.', 'blogmax-news' ),
        'panel'             => 'blogmax_front_page_panel',
        'priority'          => 34, 
    )
);

// Advertisement content enable control and setting
$wp_customize->add_setting( 'advertisement_section_enable',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'blogmax_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogmax_News_Switch_Control( $wp_customize,
    'advertisement_section_enable',
        array(
            'label'             => esc_html__( 'Advertisement Section Enable', 'blogmax-news' ),
            'section'           => 'blogmax_advertisement_section',
            'on_off_label'      => blogmax_switch_options(),
        )
    )
);

// ads image setting and control.
$wp_customize->add_setting( 'advertisement_ads_image',
	array(
		'sanitize_callback' => 'blogmax_sanitize_image'
	)
);

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
	'advertisement_ads_image',
		array(
			'label'       		=> esc_html__( 'Ads Image', 'blogmax-news' ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogmax-news' ), 900, 100 ),
			'section'     		=> 'blogmax_advertisement_section',
            'active_callback'   => 'blogmax_news_is_advertisement_section_enable',
		)
	)
);

// ads link setting and control
$wp_customize->add_setting( 'advertisement_ads_url',
    array(
        'sanitize_callback' => 'esc_url_raw',
    )
);
	
$wp_customize->add_control( 'advertisement_ads_url',
    array(
        'label'           	=> esc_html__( 'Ads Url', 'blogmax-news' ),
        'section'        	=> 'blogmax_advertisement_section',
        'type'				=> 'url',
        'active_callback'   => 'blogmax_news_is_advertisement_section_enable',
    )
);