<?php

function blogmax_news_customize_register( $wp_customize ) {

class Blogmax_News_Switch_Control extends WP_Customize_Control{

		public $type = 'switch';

		public $on_off_label = array();

		public function __construct( $manager, $id, $args = array() ){
	        $this->on_off_label = $args['on_off_label'];
	        parent::__construct( $manager, $id, $args );
	    }

		public function render_content(){
	    ?>
		    <span class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</span>

			<?php if( $this->description ){ ?>
				<span class="description customize-control-description">
				<?php echo wp_kses_post( $this->description ); ?>
				</span>
			<?php } ?>

			<?php
				$switch_class = ( $this->value() == 'true' ) ? 'switch-on' : '';
				$on_off_label = $this->on_off_label;
			?>
			<div class="onoffswitch <?php echo esc_attr( $switch_class ); ?>">
				<div class="onoffswitch-inner">
					<div class="onoffswitch-active">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['on'] ) ?></div>
					</div>

					<div class="onoffswitch-inactive">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['off'] ) ?></div>
					</div>
				</div>	
			</div>
			<input <?php $this->link(); ?> type="hidden" value="<?php echo esc_attr( $this->value() ); ?>"/>
			<?php
	    }
	}

	class Blogmax_News_Dropdown_Chooser extends WP_Customize_Control{

		public $type = 'dropdown_chooser';

		public function render_content(){
			if ( empty( $this->choices ) )
	                return;
			?>
	            <label>
	                <span class="customize-control-title">
	                	<?php echo esc_html( $this->label ); ?>
	                </span>

	                <?php if($this->description){ ?>
		            <span class="description customize-control-description">
		            	<?php echo wp_kses_post($this->description); ?>
		            </span>
		            <?php } ?>

	                <select class="blogmax-news-chosen-select" <?php $this->link(); ?>>
	                    <?php
	                    foreach ( $this->choices as $value => $label )
	                        echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . esc_html( $label ) . '</option>';
	                    ?>
	                </select>
	            </label>
			<?php
		}
	}

	//Custom control for horizontal line
Class  Blogmax_News_Customize_Horizontal_Line extends WP_Customize_Control {

	public $type = 'hr';

	public function render_content() {
		?>
		<div>
			<hr style="border: 1px dotted #72777c;" />
		</div>
		<?php
	}
}

	//customizer section
	require get_theme_file_path() . '/inc/customizer/highlighted-posts.php';
	require get_theme_file_path() . '/inc/customizer/three-column.php';
	require get_theme_file_path() . '/inc/customizer/trending-posts.php';
	require get_theme_file_path() . '/inc/customizer/recent-posts.php';
	require get_theme_file_path() . '/inc/customizer/advertisement.php';
	require get_theme_file_path() . '/inc/customizer/most-viewed-posts.php';
	require get_theme_file_path() . '/inc/customizer/popular-posts.php';
	require get_theme_file_path() . '/inc/customizer/sports.php';
	require get_theme_file_path() . '/inc/customizer/two-column-posts.php';
	require get_theme_file_path() . '/inc/customizer/theme-options/menu.php';
}
add_action( 'customize_register', 'blogmax_news_customize_register' );

/*=============Active Callback=====================*/

function blogmax_news_is_highlighted_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'highlighted_posts_section_enable' )->value() );
}

function blogmax_news_is_three_column_section_enable( $control ) {
	return ( $control->manager->get_setting( 'three_column_section_enable' )->value() );
}

function blogmax_news_is_trending_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'trending_posts_section_enable' )->value() );
}

function blogmax_news_is_recent_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'recent_posts_section_enable' )->value() );
}

function blogmax_news_is_advertisement_section_enable( $control ) {
	return ( $control->manager->get_setting( 'advertisement_section_enable' )->value() );
}

function blogmax_news_is_most_viewed_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'most_viewed_posts_section_enable' )->value() );
}

function blogmax_news_is_popular_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'popular_posts_section_enable' )->value() );
}

function blogmax_news_is_sports_section_enable( $control ) {
	return ( $control->manager->get_setting( 'sports_section_enable' )->value() );
}

function blogmax_news_is_two_column_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'two_column_posts_section_enable' )->value() );
}

function blogmax_news_is_latest_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'latest_posts_section_enable' )->value() );
}

/*=============Partial Refresh=====================*/

if ( ! function_exists( 'blogmax_news_three_column_title_partial' ) ) :
    // three_column_title
    function blogmax_news_three_column_title_partial() {
        return esc_html( get_theme_mod( 'three_column_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_trending_posts_title_partial' ) ) :
    // trending_posts_title
    function blogmax_news_trending_posts_title_partial() {
        return esc_html( get_theme_mod( 'trending_posts_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_recent_posts_title_partial' ) ) :
    // recent_posts_title
    function blogmax_news_recent_posts_title_partial() {
        return esc_html( get_theme_mod( 'recent_posts_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_most_viewed_posts_title_partial' ) ) :
    // most_viewed_posts_title
    function blogmax_news_most_viewed_posts_title_partial() {
        return esc_html( get_theme_mod( 'most_viewed_posts_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_popular_posts_title_partial' ) ) :
    // popular_posts_title
    function blogmax_news_popular_posts_title_partial() {
        return esc_html( get_theme_mod( 'popular_posts_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_sports_title_partial' ) ) :
    // sports_title
    function blogmax_news_sports_title_partial() {
        return esc_html( get_theme_mod( 'sports_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_two_column_posts_title_partial' ) ) :
    // two_column_posts_title
    function blogmax_news_two_column_posts_title_partial() {
        return esc_html( get_theme_mod( 'two_column_posts_title' ) );
    }
endif;

if ( ! function_exists( 'blogmax_news_latest_posts_title_partial' ) ) :
    // latest_posts_title
    function blogmax_news_latest_posts_title_partial() {
        return esc_html( get_theme_mod( 'latest_posts_title' ) );
    }
endif;
