<?php

if ( ! function_exists( 'blogmax_news_enqueue_styles' ) ) :

	function blogmax_news_enqueue_styles() {
		wp_enqueue_style( 'blogmax-news-style-parent', get_template_directory_uri() . '/style.css' );

		wp_enqueue_style( 'blogmax-news-style', get_stylesheet_directory_uri() . '/style.css', array( 'blogmax-news-style-parent' ), '1.0.0' );

	}

endif;

add_action( 'wp_enqueue_scripts', 'blogmax_news_enqueue_styles', 99 );

require get_theme_file_path() . '/inc/customizer.php';

function blogmax_news_customize_control_style() {


	wp_enqueue_style( 'blogmax-news-customize-controls', get_theme_file_uri() . '/customizer-control.css' );

}
add_action( 'customize_controls_enqueue_scripts', 'blogmax_news_customize_control_style' );

require get_theme_file_path() . '/inc/front-sections/highlighted-posts.php';
require get_theme_file_path() . '/inc/front-sections/three-column.php';
require get_theme_file_path() . '/inc/front-sections/trending-posts.php';
require get_theme_file_path() . '/inc/front-sections/recent-posts.php';
require get_theme_file_path() . '/inc/front-sections/advertisement.php';
require get_theme_file_path() . '/inc/front-sections/most-viewed-posts.php';
require get_theme_file_path() . '/inc/front-sections/popular-posts.php';
require get_theme_file_path() . '/inc/front-sections/sports.php';
require get_theme_file_path() . '/inc/front-sections/two-column-posts.php';


if ( ! function_exists( 'blogmax_news_footer_start' ) ) :

	function blogmax_news_footer_start() {
		?>
		<?php if(has_custom_logo( ) && has_nav_menu( 'social' )): ?>
		<div class="footer-logo-wrapper wrapper">
			<div class="logo-wrapper">
				<?php the_custom_logo(); ?>
			</div><!-- .logo-wrapper -->

			<?php 
			if(has_nav_menu( 'social' )){
				wp_nav_menu( 
					array(
						'theme_location' => 'social',
						'container' => 'ul',
						'menu_class' => 'social-icons',
						'echo' => true,
						'depth' => 1,
						'link_before' => '<span class="screen-reader-text">',
						'link_after' => '</span>',
						'fallback_cb' => false,
					)
				);
			}	?>
		</div>
	<?php endif; ?>
		<?php
	}
endif;
add_action( 'blogmax_footer', 'blogmax_news_footer_start', 11 );