<?php
/**
 * Template part for displaying posts with standard format
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogmatic
 */
use Blogmatic\CustomizerDefault as BMC;
$custom_class = 'has-featured-image';
if( array_key_exists( 'css_classes', $args ) ) $custom_class .= $args['css_classes'];
if( ! has_post_thumbnail() ) $custom_class = 'no-featured-image';
$archive_post_layout = BMC\blogmatic_get_customizer_option( 'archive_post_layout' );

$current_id = get_queried_object_id();
$archive_layout_meta = 'customizer-layout';
if( is_category() ) :
    $archive_meta_key = '_blogmatic_category_archive_custom_meta_field';
    $archive_layout_meta = metadata_exists( 'term', $current_id, $archive_meta_key ) ? get_term_meta( $current_id, $archive_meta_key, true ) : 'customizer-layout';
elseif ( is_tag() ) :
    $archive_meta_key = '_blogmatic_post_tag_archive_custom_meta_field';
    $archive_layout_meta = metadata_exists( 'term', $current_id, $archive_meta_key ) ? get_term_meta( $current_id, $archive_meta_key, true ) : 'customizer-layout';
endif;
$is_customizer_layout = ( $archive_layout_meta == 'customizer-layout' );
$is_list_three = ( ( $archive_post_layout === 'list-three' ) && $is_customizer_layout ) || ( ! $is_customizer_layout && ( $archive_layout_meta === 'list-three' ) );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $custom_class ); ?>>
    <div class="blogmatic-article-inner">
        <figure class="post-thumbnail-wrapper">
            <div class="post-thumnail-inner-wrapper">
                <?php
                    $archive_image_size = BMC\blogmatic_get_customizer_option( 'archive_image_size' );
                    blogmatic_post_thumbnail( $archive_image_size );
                ?>        
            </div>
                <?php
                    if( ! $is_list_three ) {
                        blogmatic_get_post_categories( get_the_ID(), 1 );
                    } else {
                        blogmatic_get_post_tags( get_the_ID(), 1 );
                    }
                    echo '<div class="post-format-ss-wrap">';
                        $control_id = is_string( blogmatic_get_post_format() ) ? blogmatic_get_post_format() . '_post_format_icon_picker' : 'standard_post_format_icon_picker';
                        $icon_picker = BMC\blogmatic_get_customizer_option( $control_id );
                        $post_format_icon = blogmatic_get_icon_control_html( $icon_picker );
                        $postFormatClass = 'post-format-icon';
                        if( ! empty( $icon_picker ) && is_array( $icon_picker ) && array_key_exists( 'type', $icon_picker ) && $icon_picker['type'] == 'svg' ) $postFormatClass .= ' type--svg';
                        if( $post_format_icon ) echo '<span class="'. esc_attr( $postFormatClass ) .'">'. $post_format_icon .'</span>';
                        echo '</div><!-- .post-format-ss-wrap -->';
                ?>
        </figure>
        <div class="inner-content">
            <div class="content-wrap">
                <?php
                    if( ! $is_list_three ) :
                        blogmatic_posted_on();
                        the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                    endif;
                    // post meta
                    ?>
                        <div class="post-meta">
                            <?php
                                /* Author */
                                blogmatic_posted_by(); 
                                /* Read Time */
                                $read_time_option = metadata_exists( 'post', get_the_ID(), 'read_time_option' ) ? get_post_meta( get_the_ID(), 'read_time_option', true ) : 'customizer';
                                $read_time_meta = metadata_exists( 'post', get_the_ID(), 'read_time' ) ? get_post_meta( get_the_ID(), 'read_time', true ) : '1 Mins';
                                $read_time = '<span class="time-context">' .( ( $read_time_option == 'customizer' ) ? blogmatic_post_read_time( get_the_content() ) : $read_time_meta ) . '</span>';
                                if( BMC\blogmatic_get_customizer_option( 'archive_read_time_icon' ) ) {
                                    $archive_read_time_icon = BMC\blogmatic_get_customizer_option( 'archive_read_time_icon' );
                                    $icon_html = blogmatic_get_icon_control_html($archive_read_time_icon);
                                    if( $icon_html ) $read_time = $read_time . $icon_html;
                                }
                                echo '<span class="post-read-time">' .$read_time. '</span>';
                                /* Comment */
                                $comments_num = '<span class="comments-context">' .get_comments_number(). '</span>';
                                if( BMC\blogmatic_get_customizer_option( 'archive_comments_icon' ) ) {
                                    $archive_comments_icon = BMC\blogmatic_get_customizer_option( 'archive_comments_icon' );
                                    $icon_html = blogmatic_get_icon_control_html($archive_comments_icon);
                                    if( $icon_html ) $comments_num = $comments_num . $icon_html;
                                }
                                echo '<a class="post-comments-num" href="'. esc_url(get_the_permalink()) .'#commentform">' .$comments_num. '</a>';
                            ?>
                        </div>
                    <?php
                    if( $is_list_three ) the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                    // post excerpt
                    echo '<div class="post-excerpt">';
                        echo wp_trim_words( get_the_excerpt(), 17 );
                    echo '</div>';

                    if( $is_list_three ) :
                        blogmatic_get_post_categories( get_the_ID(), 2 );
                    endif;
                    /**
                     * hook - blogmatic_section_block_view_all_hook
                     * archive post button
                     */
                    if( has_action( 'blogmatic_section_block_view_all_hook' ) ) do_action( 'blogmatic_section_block_view_all_hook' );
                ?>
            </div>
        </div>
        <?php
            /**
             * hook - blogmatic_archive_button_html_hook
             * 
             * @since 1.0.0
             */
            do_action( 'blogmatic_archive_post_append_hook' );
        ?>
    </div>
    <?php blogmatic_entry_footer(); ?>
</article>