<?php
/**
 * INcludes theme defaults and starter functions
 * 
 * @package Blogmatic
 * @since 1.0.0
 */
namespace Blogmatic\CustomizerDefault;

if( ! function_exists( 'blogmatic_get_customizer_option' ) ) :
    /**
     * Gets customizer "theme mod" value
     * 
     * @package Blogmatic
     * @since 1.0.0
     */
    function blogmatic_get_customizer_option( $control_id ) {
        return get_theme_mod( $control_id, blogmatic_get_customizer_default( $control_id ) );
    }
endif;

if( !function_exists( 'blogmatic_get_multiselect_tab_option' ) ) :
    /**
     * Gets customizer "multiselect combine tab" value
     * 
     * @package Blogmatic
     * @since 1.0.0
     */
    function blogmatic_get_multiselect_tab_option( $key ) {
        $value = blogmatic_get_customizer_option( $key );
        if( !$value["desktop"] && !$value["tablet"] && !$value["mobile"] ) return apply_filters( "blogmatic_get_multiselect_tab_option", false );
        return apply_filters( "blogmatic_get_multiselect_tab_option", true );
    }
endif;

if( ! function_exists( 'blogmatic_customizer_default_array' ) ) :
    /**
     * Returns controls default values
     * 
     * @since 1.0.0
     */
    function blogmatic_customizer_default_array() {

        $responsive = function( $desktop = 0, $tablet = 0, $smartphone = 0 ) {
            $default = [
                'desktop'   =>  $desktop,
                'tablet'    =>  $tablet,
                'smartphone'    =>  $smartphone
            ];
            return $default;
        };

        $typography = function( $append = [] ){
            $default = [
                'font_family'   => [ 'value' => 'Jost', 'label' => 'Jost' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size'   => [
                    'desktop'   =>  13,
                    'tablet'   =>  13,
                    'smartphone'   =>  13
                ],
                'line_height'   => [
                    'desktop'   =>  21,
                    'tablet'   =>  21,
                    'smartphone'   =>  21
                ],
                'letter_spacing'   => [
                    'desktop'   =>  0,
                    'tablet'   =>  0,
                    'smartphone'   =>  0
                ],
                'text_transform'    => 'unset',
                'text_decoration'    => 'none',
                'preset'    =>  '-1'
            ];
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
	        return $default;
        };

        $border = function( $append = [] ) {
            $default = [
                "type"  =>  "none", 
                "width"   =>    [ 'top' => 1, 'right' => 1, 'bottom' => 1, 'left' => 1, 'link' => true ],
                "color"   =>    "#000"
            ];
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
	        return $default;
        };

        $color = function( $append = [] ) {
            $default = [ 
                'type'  =>  'solid',
                'solid' =>  '#fff'
            ];
            if( ! empty( $append ) && is_array( $append ) ):
                $append_keys = array_keys( $append );
                $default['type'] = $append_keys[0];
                return $append += $default;
            endif;
	        return $default;
        };

        $icon_picker = function( $append = [] ){
            $default = [
                'type'  => 'icon',
                'value' => 'fa-solid fa-arrow-right'
            ];
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
	        return $default;
        };

        $array_defaults = apply_filters( 'blogmatic_get_customizer_defaults', [
            'theme_color'   => '#2f338d',
            'gradient_theme_color'   => 'linear-gradient(135deg,#942cddcc 0,#38a3e2cc 100%)',
            'header_textcolor'  =>  '2f338d',
            'site_background_color'  => $color([ 'solid'=> '#f8f8f8']),
            'site_background_animation' =>  'none',
            'show_scroll_to_top_on_mobile'    => true,
            'show_readmore_button_mobile_option'  =>  true,
            'show_breadcrumb_on_mobile'  =>  false,
            'show_background_animation_on_mobile'  =>  false,
            'website_layout'    => 'full-width--layout',
            'block_title_layout'    => 'three',
            'social_icons' => json_encode([
                [
                    'icon_class'    =>  'fab fa-facebook-f',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fab fa-instagram',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fa-brands fa-x-twitter',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fab fa-youtube',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
            ]),
            'footer_social_icons' => json_encode([
                [
                    'icon_class'    =>  'fab fa-facebook-f',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fab fa-instagram',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fa-brands fa-x-twitter',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
                [
                    'icon_class'    =>  'fab fa-youtube',
                    'icon_url'      => '',
                    'item_option'   => 'show'
                ],
            ]),
            'global_button_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-arrow-right' ]),
            'global_button_label'   =>  esc_html__( 'continue reading..', 'blogmatic' ),
            'global_button_typo'    => $typography([
                'font_family' =>  [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
            ]),
            'audio_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' =>  'fa-solid fa-music' ]),
            'gallery_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-layer-group' ]),
            'image_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-image' ]),
            'quote_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-quote-left' ]),
            'standard_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-regular fa-file-lines' ]),
            'video_post_format_icon_picker' => $icon_picker([ 'type' => 'none', 'value' => 'fa-solid fa-video' ]),
            'stt_text'  =>  esc_html__( '', 'blogmatic' ),
            'stt_icon' => $icon_picker([ 'value' => 'fas fa-angle-up' ]),
            'social_share_repeater'  =>  [
                [
                    'icon'  =>  'fa-brands fa-facebook',
                    'color'  =>  [
                        'initial'   =>  $color([ 'solid' => '#2f2e2e' ]),
                        'hover'   =>  $color([ 'solid' => '#2f2e2e' ]),
                    ],
                    'background'  =>  [
                        'initial'   =>  $color(),
                        'hover'   =>  $color(),
                    ]
                ],
                [
                    'icon'  =>  'fa-brands fa-square-x-twitter',
                    'color'  =>  [
                        'initial'   =>  $color([ 'solid' => '#2f2e2e' ]),
                        'hover'   =>  $color([ 'solid' => '#2f2e2e' ]),
                    ],
                    'background'  =>  [
                        'initial'   =>  $color(),
                        'hover'   =>  $color(),
                    ]
                ],
                [
                    'icon'  =>  'fa-solid fa-envelope',
                    'color'  =>  [
                        'initial'   =>  $color([ 'solid' => '#2f2e2e' ]),
                        'hover'   =>  $color([ 'solid' => '#2f2e2e' ]),
                    ],
                    'background'  =>  [
                        'initial'   =>  $color(),
                        'hover'   =>  $color(),
                    ]
                ],
                [
                    'icon'  =>  'fa-brands fa-linkedin',
                    'color'  =>  [
                        'initial'   =>  $color([ 'solid' => '#2f2e2e' ]),
                        'hover'   =>  $color([ 'solid' => '#2f2e2e' ]),
                    ],
                    'background'  =>  [
                        'initial'   =>  $color(),
                        'hover'   =>  $color(),
                    ]
                ]
            ],
            'preloader_option'  => false,
            'post_title_hover_effects'  => 'five',
            'site_image_hover_effects'  => 'five',
            'cursor_animation'  => 'none',
            'site_breadcrumb_option'    => false,
            'site_breadcrumb_type'  => 'default',
            'breadcrumb_typo'   =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 ),
            ]),
            'site_schema_ready' => true,
            'site_date_format'  => 'default',
            'site_date_to_show' => 'published',
            'disable_admin_notices'   => false,
            'site_title_hover_textcolor'=> '#2f338d',
            'site_description_color'    => '#131315',
            'site_title_tag_for_frontpage'  =>  'h1',
            'site_title_tag_for_innerpage'  =>  'h2',
            'main_banner_option'    => true,
            'main_banner_layouts'    => 'three',
            'main_banner_slider_categories' => [],
            'main_banner_slider_posts_to_include' => [],
            'main_banner_trailing_slider_categories' => [],
            'main_banner_trailing_slider_posts_to_include' => [],
            'default_typo_one'   =>  $typography(),
            'site_title_typo'   =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 40, 35, 35 ),
                'line_height' =>  $responsive( 45, 42, 40 )
            ]),
            'site_description_typo'   =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 22, 22, 22 )
            ]),
            'custom_button_label'  =>  'Subscribe',
            'custom_button_icon' => $icon_picker([ 'value' => 'fas fa-bell' ]),
            'custom_button_redirect_href_link' =>  home_url(),
            'custom_button_text_typography' =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'header_custom_button_background_color_group'   =>  [
                'initial'   => $color([ 'solid' => '#000' ]),
                'hover'   => $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'search_icon_size' =>  $responsive( 17, 16, 16 ),
            'theme_mode_dark_icon' => $icon_picker([ 'value' => 'fas fa-moon' ]),
            'theme_mode_light_icon' => $icon_picker([ 'value' => 'fas fa-sun' ]),
            'theme_mode_icon_size'    =>  $responsive( 18, 18, 18 ),
            'menu_cutoff_text'   =>  esc_html__( 'More', 'blogmatic' ),
            'header_buiilder_header_sticky'    =>  false,
            'header_first_row_header_sticky'    =>  false,
            'header_second_row_header_sticky'    =>  true,
            'header_third_row_header_sticky'    =>  false,
            'header_menu_hover_effect' =>  'four',
            'main_menu_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'Outfit', 'label' => 'Outfit' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 23, 23, 23 ),
                'letter_spacing' =>  $responsive( 0.8, 0.8, 0.8 ),
                'text_transform'    => 'uppercase'
            ]),
            'main_menu_sub_menu_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'Outfit', 'label' => 'Outfit' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            // MARK: TEST START
            'footer_menu_hover_effect' =>  'four',
            // MARK: TEST ENDS
            'archive_pagination_type'   => 'number',
            'archive_post_layout'   => 'list',
            'archive_sidebar_layout'    =>  'right-sidebar',
            'archive_post_elements_alignment'=> 'left',
            'archive_date_icon' => $icon_picker([ 'value' => 'far fa-calendar-days' ]),
            'archive_read_time_icon' => $icon_picker([ 'value' => 'fas fa-book-open-reader' ]),
            'archive_comments_icon' => $icon_picker([ 'value' => 'far fa-comments' ]),
            'archive_image_stretch'  =>  true,
            'archive_image_size'  =>  'large',
            'archive_section_border_radius'   =>  0,
            'archive_title_typo'  => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 20, 20, 20 ),
                'line_height' =>  $responsive( 28, 28, 35 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Unset',
            ]), 
            'archive_excerpt_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 25, 25, 25 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_category_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 24, 24, 22 ),
                'letter_spacing' =>  $responsive( 0.5, 0.5, 0.5 )
            ]),
            'archive_date_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_author_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 3,.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            'archive_read_time_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_comment_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_category_info_box_option'  => true,
            'archive_category_info_box_icon' => $icon_picker([ 'value' => 'fas fa-layer-group' ]),
            'archive_category_info_box_title_typo'    => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 25, 25, 25 ),
                'line_height' =>  $responsive( 32, 32, 32 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_category_info_box_description_typo'    => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 25, 25, 25 ),
                'letter_spacing' =>  $responsive( 0.4, 0.4, 0.4 )
            ]),
            'archive_tag_info_box_option'  => true,
            'archive_tag_info_box_icon' => $icon_picker([ 'value' => 'fas fa-tag' ]),
            'archive_tag_info_box_title_typo'    => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 25, 25, 25 ),
                'line_height' =>  $responsive( 32, 32, 32 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_tag_info_box_description_typo'    => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 25, 25, 25 ),
                'letter_spacing' =>  $responsive( 0.4, 0.4, 0.4 )
            ]),
            'archive_author_info_box_option'  => true,
            'archive_author_info_box_title_typo'    => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 25, 25, 25 ),
                'line_height' =>  $responsive( 32, 32, 32 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'archive_author_info_box_description_typo'    => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '300', 'label' => 'Light 300', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 25, 25, 25 ),
                'letter_spacing' =>  $responsive( 0.4, 0.4, 0.4 )
            ]),
            'single_post_layout'   => 'layout-six',
            'single_sidebar_layout'=> 'right-sidebar',
            'single_date_icon' => $icon_picker([ 'value' => 'far fa-calendar-days' ]),
            'single_read_time_icon' => $icon_picker([ 'value' => 'fas fa-book-open-reader' ]),
            'single_comments_icon' => $icon_picker([ 'value' => 'far fa-comments' ]),
            'single_author_option'  => true,
            'single_author_image_option'  => true,
            'single_post_content_alignment' =>  'left',
            'single_image_size'  =>  'large',
            'single_post_related_posts_option'  => true,
            'single_post_related_posts_title'   => esc_html__( 'Related Articles', 'blogmatic' ),
            'related_posts_filter_by'   => 'categories',
            'single_page_border_radius' =>  0,
            'single_title_typo'  => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 34, 27, 25 ),
                'line_height' =>  $responsive( 44, 38, 38 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'single_content_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 26, 26, 26 ),
                'letter_spacing' =>  $responsive( 0.4, 0.4, 0.4 )
            ]),
            'single_category_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 24, 24, 22 ),
                'letter_spacing' =>  $responsive( 0.5, 0.5, 0.5 )
            ]),
            'single_date_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'single_author_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 3,.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            'single_read_time_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'page_settings_sidebar_layout'  =>  'right-sidebar',
            'page_image_size'  =>  'large',
            'page_border_radius'  =>  0,
            'page_title_typo'  => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '800', 'label' => 'ExtraBold 800', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 32, 32, 32 ),
                'line_height' =>  $responsive( 31, 31, 31 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'page_content_typo'  => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 26, 26, 26 ),
                'letter_spacing' =>  $responsive( 0.4, 0.4, 0.4 )
            ]),
            'site_logo_width'  =>  $responsive( 160, 160, 160 ),
            'custom_button_animation_type'  =>  'none',
            'canvas_menu_position'  =>  'left',
            'main_banner_render_in' =>  'front_page',
            'main_banner_no_of_posts_to_show'   =>  5,
            'main_banner_trailing_no_of_posts_to_show'   =>  5,
            'main_banner_hide_post_with_no_featured_image'  =>  false,
            'main_banner_trailing_hide_post_with_no_featured_image'  =>  false,
            'main_banner_post_order'    =>  'date-desc',
            'main_banner_trailing_post_order'    =>  'date-desc',
            'main_banner_show_arrows'   =>  true,
            'main_banner_slider_prev_arrow' => $icon_picker([ 'value' => 'fa-solid fa-angle-left' ]),
            'main_banner_slider_next_arrow' => $icon_picker([ 'value' => 'fa-solid fa-angle-right' ]),
            'main_banner_show_fade'   =>  true,
            'main_banner_slider_infinite_loop'   =>  true,
            'main_banner_slider_autoplay'   =>  false,
            'main_banner_show_arrow_on_hover'   =>  false,
            'main_banner_slider_autoplay_speed'   =>  3000,
            'main_banner_slider_speed'   =>  500,
            'main_banner_date_icon' => $icon_picker([ 'value' => 'fas fa-calendar-days' ]),
            'main_banner_post_elements_alignment'  =>  'left',
            'main_banner_image_sizes'  =>  'large',
            'main_banner_design_post_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 22, 25, 19 ),
                'line_height' =>  $responsive( 30, 30, 30 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'main_banner_design_post_categories_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'main_banner_design_post_date_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'main_banner_design_post_author_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 3,.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            'main_banner_design_post_excerpt_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 25, 25, 25 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'main_banner_design_slider_icon_size' =>  $responsive( 14, 14, 14 ),
            'carousel_option'    => false,
            'carousel_layouts'  =>  'one',
            'carousel_render_in'    =>  'front_page',
            'carousel_no_of_columns'    =>  3,
            'carousel_slider_categories' => [],
            'carousel_slider_posts_to_include' => [],
            'carousel_no_of_posts_to_show'   =>  5,
            'carousel_hide_post_with_no_featured_image'  =>  false,
            'carousel_post_order'    =>  'date-desc',
            'carousel_show_arrows'   =>  true,
            'carousel_slider_prev_arrow' => $icon_picker([ 'value' => 'fa-solid fa-arrow-left-long' ]),
            'carousel_slider_next_arrow' => $icon_picker([ 'value' => 'fa-solid fa-arrow-right-long' ]),
            'carousel_slider_infinite_loop'   =>  true,
            'carousel_slider_autoplay'   =>  true,
            'carousel_show_arrow_on_hover'   =>  false,
            'carousel_slider_autoplay_speed'   =>  3000,
            'carousel_slider_speed'   =>  500,
            'carousel_slides_to_scroll'    =>  1,
            'carousel_date_icon' => $icon_picker([ 'value' => 'fas fa-calendar-days' ]),
            'carousel_post_elements_alignment'  =>  'center',
            'carousel_image_sizes'  =>  'large',
            'carousel_image_border_radius'  =>  [ 
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'carousel_design_post_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 20, 20, 20 ),
                'line_height' =>  $responsive( 28, 28, 28 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Capitalize',
            ]),
            'carousel_design_post_categories_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 23, 23, 23 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'carousel_design_post_date_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'carousel_design_post_author_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive()
            ]),
            'carousel_design_post_excerpt_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'carousel_design_slider_icon_size' =>  $responsive( 15, 15, 15 ),
            // category collection
            'category_collection_option'    =>  false,
            'category_collection_layout'    =>  'one',
            'category_collection_render_in'    =>  'front_page',
            'category_collection_number_of_columns'    =>  $responsive( 3, 2, 1 ),
            'category_to_include' => [],
            'category_to_exclude' => [],
            'category_collection_number' => 3,
            'category_collection_orderby' => 'asc-name',
            'category_collection_image_radius'  =>  $responsive( 0, 0, 0 ),
            'category_collection_image_size'  =>  'large',
            'category_collection_hover_effects'  =>  'none',
            'category_collection_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 19, 19, 19 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Uppercase',
            ]),
            // error page
            'error_page_button_icon' => $icon_picker([ 'value' => 'fa-solid fa-tent-arrow-turn-left' ]),
            // you may have missed
            'you_may_have_missed_section_option' => true,
            'you_may_have_missed_title_option' => true,
            'you_may_have_missed_no_of_columns'    =>  3,
            'you_may_have_missed_categories' => [],
            'you_may_have_missed_posts_to_include' => [],
            'you_may_have_missed_no_of_posts_to_show'   =>  3,
            'you_may_have_missed_hide_post_with_no_featured_image'  =>  false,
            'you_may_have_missed_post_order'    =>  'rand-desc',
            'you_may_have_missed_date_icon' => $icon_picker([ 'value' => 'fas fa-calendar' ]),
            'you_may_have_missed_post_elements_alignment'  =>  'left',
            'you_may_have_missed_image_sizes'  =>  'large',
            'you_may_have_missed_image_border_radius'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'you_may_have_missed_design_section_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 19, 19, 19 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Uppercase'
            ]),
            'you_may_have_missed_design_post_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 20, 19, 17 ),
                'line_height' =>  $responsive( 29, 29, 29 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'you_may_have_missed_design_post_categories_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 24, 24, 22 ),
                'letter_spacing' =>  $responsive( 0.5, 0.5, 0.5 )
            ]),
            'you_may_have_missed_design_post_date_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'you_may_have_missed_design_post_author_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 12, 12, 12 ),
                'line_height' =>  $responsive( 18, 18, 18 ),
                'letter_spacing' =>  $responsive( 0, 3,.3 ),
                'text_transform'    => 'Capitalize',
            ]),
            // theme footer
            'bottom_footer_site_info'   => esc_html__( 'Blogmatic - Blog WordPress Theme %year%.', 'blogmatic' ),
            'bottom_footer_header_or_custom'    =>  'header',
            'bottom_footer_logo_option'   =>  0,
            'bottom_footer_logo_width'  =>  $responsive( 200, 200, 200 ),
            'heading_one_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 34, 34, 34 ),
                'line_height' =>  $responsive( 44, 44, 44 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'heading_two_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 28, 28, 28 ),
                'line_height' =>  $responsive( 35, 35, 35 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'heading_three_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 24, 24, 24 ),
                'line_height' =>  $responsive( 31, 31, 31 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'heading_four_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 18, 18, 18 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'heading_five_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 22, 22, 22 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'heading_six_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'sidebar_border_radius'   =>  0,
            'sidebar_block_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 34, 34, 34 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Uppercase'
            ]),
            'sidebar_post_title_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 23, 23, 23 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'sidebar_category_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'sidebar_date_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 20, 20, 20 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'sidebar_heading_one_typography'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 28, 28, 28 ),
                'line_height' =>  $responsive( 34, 34, 34 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_two_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 24, 24, 24 ),
                'line_height' =>  $responsive( 34, 34, 34 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_three_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 22, 22, 22 ),
                'line_height' =>  $responsive( 28, 28, 28 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_four_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 20, 20, 20 ),
                'line_height' =>  $responsive( 28, 28, 28 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_heading_five_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 18, 18, 18 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0.3, 0.2, 0.3 )
            ]),
            'sidebar_heading_six_typo'  =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '600', 'label' => 'SemiBold 600', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 22, 22, 22 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'sidebar_pagination_button_typo'    => $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 13, 13, 13 ),
                'letter_spacing' =>  $responsive( 0.6, 0.6, 0.6 )
            ]),
            'advertisement_repeater'   =>  json_encode([
                [
                    'item_image'    => 0,
                    'item_url'      => home_url(),
                    'item_option'   => 'show',
                    'item_target'   =>  '_blank',
                    'item_rel_attribute'    =>  'nofollow',
                    'item_heading'  =>  esc_html__( 'Display Area', 'blogmatic' ),
                    'item_checkbox_before_post_content'  => false,
                    'item_checkbox_after_post_content'  =>  false,
                    'item_checkbox_random_post_archives'  =>    false,
                    'item_alignment'    =>  'center',
                    'item_image_option' =>  'original'
                ],
                [
                    'item_image'    => 0,
                    'item_url'      => home_url(),
                    'item_option'   => 'show',
                    'item_target'   =>  '_blank',
                    'item_rel_attribute'    =>  'nofollow',
                    'item_heading'  =>  esc_html__( 'Display Area', 'blogmatic' ),
                    'item_checkbox_before_post_content'  => false,
                    'item_checkbox_after_post_content'  =>  false,
                    'item_checkbox_random_post_archives'  =>    false,
                    'item_alignment'    =>  'center',
                    'item_image_option' =>  'original'
                ]
            ]),
            'blogdescription_option'    =>  false,
            'footer_title_typography'    => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '700', 'label' => 'Bold 700', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 34, 34, 34 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 ),
                'text_transform'    => 'Uppercase'
            ]),
            'footer_text_typography'    =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 14, 14, 14 ),
                'line_height' =>  $responsive( 23, 23, 23 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'bottom_footer_text_typography'    => $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'bottom_footer_link_typography'    =>  $typography([
                'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 15, 15, 15 ),
                'line_height' =>  $responsive( 24, 24, 24 ),
                'letter_spacing' =>  $responsive( 0.3, 0.3, 0.3 )
            ]),
            'solid_color_preset' =>  [
                'color_palettes' => [
                    [ '#40E0D0', '#F4C430', '#FF00FF', '#007BA7', '#DC143C', '#7FFF00' ],
                    [ '#007FFF', '#FFBF00', '#50C878', '#8A2BE2', '#FF7F50' ],
                    [ '#008080', '#FFD700', '#E6E6FA', '#800000', '#808000', '#CCCCFF' ]
                ],
                'active_palette'    =>  '0'
            ],
            'gradient_color_preset' =>  [
                'color_palettes' => [
                    [ 'linear-gradient(135deg, #000000, #FFFF00)', 'linear-gradient(135deg, #191970, #FFD700)', 'linear-gradient(135deg, #4B0082, #FFA500)', 'linear-gradient(135deg, #FF8C00, #483D8B)', 'linear-gradient(135deg, #006400, #8B4513)', 'linear-gradient(135deg, #DC143C, #FFD700)' ],
                    [ 'linear-gradient(135deg, #00FFFF, #FF6347)', 'linear-gradient(135deg, #228B22, #8B4513)', 'linear-gradient(135deg, #F4A460, #DAA520)', 'linear-gradient(135deg, #FFD700, #FF6347)', 'linear-gradient(135deg, #9400D3, #87CEEB)', 'linear-gradient(135deg, #00FF00, #00FFFF)' ],
                    [ 'linear-gradient(135deg, #FFD700, #FFA500)', 'linear-gradient(135deg, #FF7F50, #FFD700)', 'linear-gradient(135deg, #483D8B, #00FFFF)', 'linear-gradient(135deg, #DC143C, #8B008B)', 'linear-gradient(135deg, #228B22, #2E8B57)', 'linear-gradient(135deg, #FF6347, #FFA500)' ],
                ],
                'active_palette'    =>  '0'
            ],
            'social_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#000' ]),
                'hover' =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'footer_social_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#000' ]),
                'hover' =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'header_menu_color' => [ 
                'initial'   =>  $color([ 'solid' => '#fff' ]),
                'hover' =>  $color([ 'solid' => '#fff' ])
            ],
            'header_sub_menu_color' => [ 
                'initial'   =>  $color([ 'solid' => '#000' ]),
                'hover' =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'footer_menu_color' => [ 
                'initial'   =>  $color([ 'solid' => '#fff' ]),
                'hover' =>  $color([ 'solid' => '#fff' ])
            ],
            'search_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#171717' ]),
                'hover' =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'theme_mode_dark_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#fff' ]),
                'hover' =>  $color([ 'solid' => '#fff' ])
            ],
            'theme_mode_light_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#000' ]),
                'hover' =>  $color([ 'solid' => '#2f2e2e' ])
            ],
            'canvas_menu_icon_color' => [ 
                'initial'   =>  $color([ 'solid' => '#fff' ]),
                'hover' =>  $color([ 'solid' => '#fff' ])
            ],
            'typography_presets'    =>  [
                'typographies'    =>  [
                    $typography([
                        'font_family'   => [ 'value' => 'DM Sans', 'label' => 'DM Sans' ],
                        'font_size'   => [
                            'desktop' => 16,
                            'tablet' => 16,
                            'smartphone' => 16
                        ],
                        'line_height'   => array(
                            'desktop' => 20,
                            'tablet' => 20,
                            'smartphone' => 20
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0.3,
                            'tablet' => 0.3,
                            'smartphone' => 0.3
                        )
                    ]),
                    $typography([
                        'font_family'   => [ 'value' => 'Outfit', 'label' => 'Outfit' ],
                        'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                        'font_size'   => [
                            'desktop' => 13,
                            'tablet' => 13,
                            'smartphone' => 13
                        ],
                        'line_height'   => array(
                            'desktop' => 23,
                            'tablet' => 23,
                            'smartphone' => 23
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0.3,
                            'tablet' => 0.3,
                            'smartphone' => 0.3
                        ),
                        'text_transform'    => 'uppercase'
                    ]),
                    $typography([
                        'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                        'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                        'font_size'   => [
                            'desktop' => 14,
                            'tablet' => 14,
                            'smartphone' => 14
                        ],
                        'line_height'   => array(
                            'desktop' => 25,
                            'tablet' => 25,
                            'smartphone' => 25
                        ),
                        'letter_spacing'   => array(
                            'desktop' => 0,
                            'tablet' => 0,
                            'smartphone' => 0
                        )
                    ])
                ],
                'labels'    =>  [ esc_html__( 'Typography 1', 'blogmatic' ), esc_html__( 'Typography 2', 'blogmatic' ), esc_html__( 'Typography 3', 'blogmatic' ) ]
            ],
            'header_builder'    =>  [
                '00'    =>  [ 'search' ],
                '01'    =>  [ 'site-logo' ],
                '02'    =>  [ 'social-icons' ],
                '03'    =>  [],
                '10'    =>  [ 'menu' ],
                '11'    =>  [ 'off-canvas' ],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  []
            ],
            /* Date / Time */
            'date_time_typography'   =>  $typography([
                'font_family'   => [ 'value' => 'Poppins', 'label' => 'Poppins' ],
                'font_weight'   => [ 'value' => '400', 'label' => 'Regular 400', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 16, 16, 16 ),
                'line_height' =>  $responsive( 36, 36, 36 ),
                'letter_spacing' =>  $responsive( 0, 0, 0 )
            ]),
            'date_color'   =>  $color([ 'solid' => '#000' ]),
            'time_color'   =>  $color([ 'solid' => '#000' ]),
            /* Header builder */
            'header_builder_section_width'   =>  'full-width--layout',
            'header_builder_background'   =>  $color(),
            /* First row */
            'header_first_row_column'  =>  3,
            'header_first_row_column_layout'  =>  $responsive( 'one', 'two', 'two' ),
            'header_first_row_padding'   =>  [
                'desktop' => [ 'top' => 55, 'right' => 50, 'bottom' => 55, 'left' => 50, 'link' => true ],
                'tablet' => [ 'top' => 35, 'right' => 50, 'bottom' => 35, 'left' => 50, 'link' => true ],
                'smartphone' => [ 'top' => 35, 'right' => 50, 'bottom' => 35, 'left' => 50, 'link' => true ]
            ],
            'header_first_row_background'   =>  $color([ 'solid' => '#f8f8f8' ]),
            'header_first_row_column_one'   =>  $responsive( 'left', 'left', 'left' ),
            'header_first_row_column_two'   =>  $responsive( 'center', 'center', 'center' ),
            'header_first_row_column_three'   =>  $responsive( 'right', 'right', 'right' ),
            /* Second row */
            'header_second_row_column'  =>  2,
            'header_second_row_column_layout'  =>  $responsive( 'one', 'two', 'two' ),
            'header_second_row_padding'   =>  [
                'desktop' => [ 'top' => 15, 'right' => 50, 'bottom' => 15, 'left' => 50, 'link' => true ],
                'tablet' => [ 'top' => 15, 'right' => 50, 'bottom' => 15, 'left' => 50, 'link' => true ],
                'smartphone' => [ 'top' => 15, 'right' => 50, 'bottom' => 15, 'left' => 50, 'link' => true ]
            ],
            'header_second_row_background'  =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ]),
            'header_second_row_column_one'   =>  $responsive( 'left', 'left', 'left' ),
            'header_second_row_column_two'   =>  $responsive( 'right', 'right', 'right' ),
            'header_second_row_column_three'   =>  $responsive( 'center', 'center', 'center' ),
            /* Third row */
            'header_third_row_column'  =>  2,
            'header_third_row_column_layout'  =>  $responsive( 'one', 'two', 'two' ),
            'header_third_row_padding'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'header_third_row_background'   =>  $color([ 'solid' => '#f8f8f8' ]),
            'header_third_row_column_one'   =>  $responsive( 'left', 'left', 'left' ),
            'header_third_row_column_two'   =>  $responsive( 'center', 'center', 'center' ),
            'header_third_row_column_three'   =>  $responsive( 'center', 'center', 'center' ),
            /* Footer Builder */
            'footer_builder'    =>  [
                '00'    =>  [ 'logo' ],
                '01'    =>  [],
                '02'    =>  [],
                '03'    =>  [],
                '10'    =>  [ 'social-icons' ],
                '11'    =>  [],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [ 'copyright','scroll-to-top' ],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  [],
            ],
            /* Footer builder */
            'footer_builder_section_width'   =>  'boxed--layout',
            /* Footer First row */
            'footer_first_row_column'  =>  1,
            'footer_first_row_column_layout'  =>  $responsive( 'one', 'one', 'one' ),
            'footer_first_row_padding'   =>  [
                'desktop' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 60, 'right' => 0, 'bottom' => 0, 'left' => 0, 'link' => true ]
            ],
            'footer_first_row_column_one'   =>  $responsive( 'center', 'left', 'left' ),
            'footer_first_row_column_two'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_first_row_column_three'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_first_row_column_four'   =>  $responsive( 'right', 'right', 'right' ),
            /* Footer Second row */
            'footer_second_row_column'  =>  1,
            'footer_second_row_column_layout'  =>  $responsive( 'one', 'one', 'one' ),
            'footer_second_row_padding'   =>  [
                'desktop' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 20, 'right' => 0, 'bottom' => 20, 'left' => 0, 'link' => true ]
            ],
            'footer_second_row_column_one'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_two'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_three'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_second_row_column_four'   =>  $responsive( 'right', 'right', 'right' ),
            /* Footer Third row */
            'footer_third_row_column'  =>  1,
            'footer_third_row_column_layout'  =>  $responsive( 'one', 'one', 'one' ),
            'footer_third_row_padding'   =>  [
                'desktop' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ],
                'tablet' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ],
                'smartphone' => [ 'top' => 0, 'right' => 0, 'bottom' => 60, 'left' => 0, 'link' => true ]
            ],
            'footer_third_row_column_one'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_two'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_three'   =>  $responsive( 'center', 'center', 'center' ),
            'footer_third_row_column_four'   =>  $responsive( 'right', 'right', 'right' ),
            /* Responsive header builder */
            'responsive_header_builder' =>  [
                '00'    =>  [ 'site-logo' ],
                '01'    =>  [],
                '02'    =>  [ 'toggle-button' ],
                '03'    =>  [],
                '10'    =>  [],
                '11'    =>  [],
                '12'    =>  [],
                '13'    =>  [],
                '20'    =>  [],
                '21'    =>  [],
                '22'    =>  [],
                '23'    =>  [],
                'responsive-canvas' =>  [ 'menu' ]
            ],
            'mobile_canvas_alignment'   =>  'left',
            'mobile_canvas_icon_color'  =>  [
                'initial'   =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ]),
                'hover'   =>  $color([ 'solid' => '--blogmatic-global-preset-theme-color' ])
            ],
            'footer_menu_typography'    =>  $typography([
                'font_family'   => [ 'value' => 'Outfit', 'label' => 'Outfit' ],
                'font_weight'   => [ 'value' => '500', 'label' => 'Medium 500', 'variant' => 'normal' ],
                'font_size' =>  $responsive( 13, 13, 13 ),
                'line_height' =>  $responsive( 23, 23, 23 ),
                'letter_spacing' =>  $responsive( 0.8, 0.8, 0.8 ),
                'text_transform'    => 'uppercase'
            ]),
        ]);
        return $array_defaults;
    }
endif;

if( !function_exists( 'blogmatic_get_customizer_default' ) ) :
    /**
     * Gets customizer "theme_mods" value
     * 
     * @package Blogmatic
     * @since 1.0.0
     */
    function blogmatic_get_customizer_default( $key ) { 
        $array_defaults = blogmatic_customizer_default_array();
        $totalCats = get_categories();
        if( $totalCats ) :
            foreach( $totalCats as $singleCat ) :
                $array_defaults['category_' .absint($singleCat->term_id). '_color'] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                    'hover'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                ];
                $array_defaults['category_background_' .absint($singleCat->term_id). '_color'] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' => '--blogmatic-global-preset-theme-color'
                    ],
                    'hover' =>  [
                        'type'  =>  'solid',
                        'solid' => '--blogmatic-global-preset-theme-color'
                    ]
                ];
            endforeach;
        endif;
        $totalTags = get_tags();
        if( $totalTags ) :
            foreach( $totalTags as $singleTag ) :
                $array_defaults['tag_' .absint($singleTag->term_id). '_color'] = [
                    'initial'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ],
                    'hover'   =>  [
                        'type'  =>  'solid',
                        'solid' =>  '#fff'
                    ]
                ];
                $array_defaults['tag_background_' .absint($singleTag->term_id). '_color'] = [
                    'initial'    => [
                        'type'  =>  'solid',
                        'solid' => '--blogmatic-global-preset-theme-color' 
                    ],
                    'hover'    => [
                        'type'  =>  'solid',
                        'solid' => '--blogmatic-global-preset-theme-color'
                    ]
                ];
            endforeach;
        endif;
        return $array_defaults[$key];
    }
endif;