<?php
/**
 * Theme hooks and functions
 * 
 * @package Blogmatic
 * @since 1.0.0
 */
use Blogmatic\CustomizerDefault as BMC;
if( ! function_exists( 'blogmatic_single_related_posts' ) ) :
    /**
     * Single related posts
     * 
     * @package Blogmatic
     */
    function blogmatic_single_related_posts() {
        if( get_post_type() != 'post' ) return;
        $single_post_related_posts_option = BMC\blogmatic_get_customizer_option( 'single_post_related_posts_option' );
        if( ! $single_post_related_posts_option ) return;
        $related_posts_title = BMC\blogmatic_get_customizer_option( 'single_post_related_posts_title' );
        $related_posts_filter_by = BMC\blogmatic_get_customizer_option( 'related_posts_filter_by' );
        $related_posts_args = array(
            'posts_per_page'   => 4,
            'post__not_in'  => array( get_the_ID() ),
            'ignore_sticky_posts'    => true
        );
        $post_categories = wp_get_post_categories( get_the_ID() );
        $related_posts_args['category__in'] = $post_categories;
        $related_posts = new WP_Query( apply_filters( 'blogmatic_query_args_filter', $related_posts_args ) );
        if( ! $related_posts->have_posts() ) return;
        $elementClass = 'single-related-posts-section-wrap layout--list';
        $elementClass .= ' layout--two';
        $elementClass .= ' column--' . blogmatic_convert_number_to_numeric_string( 2 );
  ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <div class="single-related-posts-section">
                    <?php
                        if( $related_posts_title ) echo '<h2 class="blogmatic-block-title"><span>' .esc_html( $related_posts_title ). '</span></h2>';
                            echo '<div class="single-related-posts-wrap">';
                                while( $related_posts->have_posts() ) : $related_posts->the_post();
                            ?>
                                <article post-id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                    <figure class="post-thumb-wrap <?php if(!has_post_thumbnail()){ echo esc_attr('no-feat-img');} ?>">
                                        <?php blogmatic_post_thumbnail( 'medium' ); ?>
                                    </figure>
                                    <div class="post-element">
                                        <h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                        <div class="post-meta">
                                            <?php
                                                blogmatic_posted_by();
                                                $comments_num = '<span class="comments-context">' .get_comments_number(). '</span>';
                                                $single_comments_icon = BMC\blogmatic_get_customizer_option( 'single_comments_icon' );
                                                if( $single_comments_icon ) {
                                                    $icon_html = blogmatic_get_icon_control_html($single_comments_icon);
                                                    if( $icon_html ) $comments_num = $icon_html . $comments_num ;
                                                }
                                                echo '<a class="post-comments-num" href="'. esc_url(get_the_permalink()) .'#commentform">' .$comments_num. '</a>';
                                            ?>
                                        </div>
                                    </div>
                                </article>
                            <?php
                                endwhile;
                                wp_reset_postdata();
                            echo '</div>';
                    ?>
                </div>
            </div>
    <?php
    }
endif;
add_action( 'blogmatic_single_post_append_hook', 'blogmatic_single_related_posts' );

if( ! function_exists( 'blogmatic_archive_header_html' ) ) :
    /**
     * Archive info box hook
     * 
     * @since 1.0.0
     */
    function blogmatic_archive_header_html() {
        if( ! is_archive() ) return;
        if( is_category() && ! BMC\blogmatic_get_customizer_option( 'archive_category_info_box_option' ) ) return;
        if( is_tag() && ! BMC\blogmatic_get_customizer_option( 'archive_tag_info_box_option' ) ) return;
        if( is_author() && ! BMC\blogmatic_get_customizer_option( 'archive_author_info_box_option' ) ) return;
        echo '<header class="page-header">';
            if( is_category() ) {
                $archive_category_info_box_icon = BMC\blogmatic_get_customizer_option( 'archive_category_info_box_icon' );
                $icon_html = blogmatic_get_icon_control_html( $archive_category_info_box_icon );
                echo '<div class="archive-title">';
                    if( $icon_html ) echo $icon_html;
                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                echo '</div>';
                the_archive_description( '<div class="archive-description">', '</div>' );
            } else if( is_tag() ) {
                $archive_tag_info_box_icon = BMC\blogmatic_get_customizer_option( 'archive_tag_info_box_icon' );
                $icon_html = blogmatic_get_icon_control_html( $archive_tag_info_box_icon );
                echo '<div class="archive-title">';
                    if( $icon_html ) echo $icon_html;
                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                echo '</div>';
                the_archive_description( '<div class="archive-description">', '</div>' );
            } else if( is_author() ) {
                echo '<div class="archive-title">';
                    $author_image = get_avatar( get_queried_object_id(), 90 );
                    if( $author_image ) echo $author_image;
                    the_archive_title( '<H2 class="page-title">', '</H2>' );
                echo '</div>';
                the_archive_description( '<div class="archive-description">', '</div>' );
            } else {
                the_archive_title( '<h1 class="page-title">', '</h1>' );
            }
        echo '</header><!-- .page-header -->';
    }
    add_action( 'blogmatic_page_header_hook', 'blogmatic_archive_header_html' );
endif;

if( ! function_exists( 'blogmatic_shooting_star_animation_html' ) ) :
    /**
     * Background animation one
     * 
     * @package Blogmatic
     * @since 1.0.0
     */
    function blogmatic_shooting_star_animation_html() {
        $show_background_animation_on_mobile = BMC\blogmatic_get_customizer_option( 'show_background_animation_on_mobile' ); 
        $elementClass = 'blogmatic-background-animation';
        if( ! $show_background_animation_on_mobile ) $elementClass .= ' hide-on-mobile';
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <?php
                    for( $i = 0; $i < 13; $i++ ) :
                        echo '<span class="item"></span>';
                    endfor;
                ?>
            </div>
        <?php
    }
endif;

if( ! function_exists( 'blogmatic_get_opening_div_main_wrap' ) ) :
    /**
     * Renders the opening div to wrap main content
     */
    function blogmatic_get_opening_div_main_wrap() {
        echo '<div id="blogmatic-main-wrap" class="blogmatic-main-wrap">';
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_opening_div_main_wrap', 10 );
endif;

if( ! function_exists( 'blogmatic_get_page_header_hook' ) ) :
    function blogmatic_get_page_header_hook() {
        /**
         * Hook - blogmatic_page_header_hook
         * 
         * Hooked - blogmatic_archive_header_html - 10
         */
        if( ! is_archive() ) do_action( 'blogmatic_page_header_hook' );
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_page_header_hook', 20 );
endif;

if( ! function_exists( 'blogmatic_get_layout_six_part' ) ) :
    /**
     * Renders contents of single post only for layout three 
     * 
     * @since 1.0.0
     */
    function blogmatic_get_layout_six_part() {
        if( ! is_single() ) return;
        $single_post_layout = BMC\blogmatic_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        if( ( in_array( $single_post_layout, [ 'layout-six' ] ) && $single_layout_post_meta == 'customizer-layout' ) || in_array( $single_layout_post_meta, [ 'layout-six' ] ) ) :
            $single_custom_class = 'entry-header';
            ?>
                <div class="blogmatic-container">
                    <div class="row">
                        <?php blogmatic_breadcrumb_html(); ?>
                        <header class="<?php echo esc_attr( $single_custom_class ); ?>" >
                            <div class="single-header-content-wrap">
                                <?php
                                    get_template_part( 'template-parts/single/partial', 'meta' );
                                ?>
                            </div>
                        </header><!-- .entry-header -->
                    </div>
                </div>
            <?php
        endif;
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_layout_six_part', 30 );
endif;

if( ! function_exists( 'blogmatic_get_opening_div_container' ) ) :
    /**
     * Renders the opening div for .blogmatic-container class
     * 
     * @since 1.0.0
     */
    function blogmatic_get_opening_div_container() {
        echo '<div class="blogmatic-container">';
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_opening_div_container', 40 );
endif;

if( ! function_exists( 'blogmatic_get_single_content_exclude_layout_three' ) ) :
    /**
     * Renders contents of single post excluding layout three
     * 
     * @since 1.0.0
     */
    function blogmatic_get_single_content_exclude_layout_three() {
        /**
         * hook - blogmatic_before_main_content
         * 
         * hooked - blogmatic_breadcrumb_html - 10
         * hooked - blogmatic_single_header_html - 20
         */
        $single_post_layout = BMC\blogmatic_get_customizer_option( 'single_post_layout' );
        $single_layout_post_meta = metadata_exists( 'post', get_the_ID(), 'single_layout' ) ? get_post_meta( get_the_ID(), 'single_layout', true ) : 'customizer-layout';
        if( $single_layout_post_meta !== 'customizer-layout' && is_single() ) {
            if( ! in_array( $single_layout_post_meta, [ 'layout-three', 'layout-six' ] ) ) do_action( 'blogmatic_before_main_content' );
        } else {
            if( ! in_array( $single_post_layout, [ 'layout-three', 'layout-six' ] ) && is_single() ) do_action( 'blogmatic_before_main_content' );
        }
        if( ! is_single() ) do_action( 'blogmatic_before_main_content' );
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_single_content_exclude_layout_three', 50 );
endif;

if( ! function_exists( 'blogmatic_get_opening_div_row' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blogmatic_get_opening_div_row() {
        echo '<div class="row">';
    }
    add_action( 'blogmatic_main_content_opening', 'blogmatic_get_opening_div_row', 60 );
endif;

if( ! function_exists( 'blogmatic_get_closing_div_row' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blogmatic_get_closing_div_row() {
        echo '</div><!-- .row -->';
    }
    add_action( 'blogmatic_main_content_closing', 'blogmatic_get_closing_div_row', 10 );
endif;

if( ! function_exists( 'blogmatic_get_closing_div_container' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blogmatic_get_closing_div_container() {
        echo '</div><!-- .row -->';
    }
    add_action( 'blogmatic_main_content_closing', 'blogmatic_get_closing_div_container', 20 );
endif;

if( ! function_exists( 'blogmatic_get_closing_div_main_wrap' ) ) :
    /**
     * Renders the opening div for .row class
     * 
     * @since 1.0.0
     */
    function blogmatic_get_closing_div_main_wrap() {
        echo '</div><!-- .blogmatic-main-wrap -->';
    }
    add_action( 'blogmatic_main_content_closing', 'blogmatic_get_closing_div_main_wrap', 30);
endif;

