<?php
/**
 * Footer hooks and functions
 * 
 * @package Blogmatic
 * @since 1.0.0
 */
use Blogmatic\CustomizerDefault as BMC;

if( ! function_exists( 'blogmatic_footer_logo_part' ) ) :
    /**
     * Bottom Footer logo element
     * 
     * @since 1.0.0
     */
    function blogmatic_footer_logo_part() {
        $logo_from = BMC\blogmatic_get_customizer_option( 'bottom_footer_header_or_custom' );
        $show_site_title = false;
        if( $logo_from == 'header' ) {
            $footer_logo = get_theme_mod( 'custom_logo' );
            if( ! $footer_logo ) $show_site_title = true;
        } else {
            $footer_logo = BMC\blogmatic_get_customizer_option( 'bottom_footer_logo_option' );
        };
        ?>
            <div class="footer-logo">
                <?php
                    if( $logo_from !== 'header' ) {
                        if( wp_get_attachment_image( $footer_logo, 'full' ) ) echo '<a href="'. home_url() .'" class="footer-site-logo">'. wp_get_attachment_image( $footer_logo, 'full' ) .'</a>';
                    } else {
                        $site_title_tag_for_frontpage = BMC\blogmatic_get_customizer_option( 'site_title_tag_for_frontpage' );
                        $site_title_tag_for_innerpage = BMC\blogmatic_get_customizer_option( 'site_title_tag_for_innerpage' );

                        the_custom_logo();

                        if ( is_front_page() && ! get_custom_logo() ) :
                            echo '<'. esc_html( $site_title_tag_for_frontpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_frontpage ) .'>';
                        else :
                            echo '<'. esc_html( $site_title_tag_for_innerpage ) .' class="site-title"><a href="'. esc_url( home_url( '/' ) ) .'" rel="home">'. get_bloginfo( 'name' ) .'</a></'. esc_html( $site_title_tag_for_innerpage ) .'>';
                        endif;
                    }
                ?>
            </div>
        <?php
    }
    add_action( 'blogmatic_footer_logo_hook', 'blogmatic_footer_logo_part', 10 );
endif;

if( ! function_exists( 'blogmatic_footer_social_icons' ) ) :
   /**
    * Bottom Footer copyright element
    * 
    * @since 1.0.0
    */
    function blogmatic_footer_social_icons() {
        require get_template_directory() . '/inc/hooks/top-header-hooks.php'; // footer hooks.

        $elementClass = 'social-icons-wrap';
        $elementClass .= ' footer'; 
        ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <?php blogmatic_customizer_social_icons( 'footer' ); ?>
            </div>
        <?php
    }
    add_action( 'blogmatic_footer_social_hook', 'blogmatic_footer_social_icons', 10 );
endif;

if( ! function_exists( 'blogmatic_footer_copyright_part' ) ) :
   /**
    * Bottom Footer copyright element
    * 
    * @since 1.0.0
    */
    function blogmatic_footer_copyright_part() {
      $bottom_footer_site_info = BMC\blogmatic_get_customizer_option( 'bottom_footer_site_info' );
      if( ! $bottom_footer_site_info ) return;
     ?>
        <div class="site-info">
            <?php echo wp_kses_post( str_replace( '%year%', date('Y'), $bottom_footer_site_info ) ); ?>
        </div>
     <?php
    }
    add_action( 'blogmatic_footer_copyright_hook', 'blogmatic_footer_copyright_part', 10 );
endif;

if( ! function_exists( 'blogmatic_you_may_have_missed_html' ) ) :
    /**
     * You May Have Missed Section html
     * 
     * @since 1.0.0
     */
    function blogmatic_you_may_have_missed_html() {
        if( ! BMC\blogmatic_get_customizer_option( 'you_may_have_missed_section_option' ) || is_paged() ) return;
        // post query
        $you_may_have_missed_post_categories = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_categories' );
        $you_may_have_missed_posts_to_include = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_posts_to_include' );
        $you_may_have_missed_post_order = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_post_order' );
        $you_may_have_missed_no_of_posts_to_show = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_no_of_posts_to_show' );
        $hide_posts_with_no_featured_image = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_hide_post_with_no_featured_image' );
        $post_categories_id_args = ( ! empty( $you_may_have_missed_post_categories ) ) ? implode( ",", array_column( $you_may_have_missed_post_categories, 'value' ) ) : '';
        $post_to_include_id_args = ( ! empty( $you_may_have_missed_posts_to_include ) ) ? array_column( $you_may_have_missed_posts_to_include, 'value' ) : '';

        // image settings and slider settings
        $you_may_have_missed_image_sizes = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_image_sizes' );
        $you_may_have_missed_no_of_columns = absint( BMC\blogmatic_get_customizer_option( 'you_may_have_missed_no_of_columns' ) );

        // element class
        $elementClass = 'blogmatic-you-may-have-missed-section';
        $elementClass .= ( $you_may_have_missed_no_of_columns ) ? ' no-of-columns--'. blogmatic_convert_number_to_numeric_string( $you_may_have_missed_no_of_columns ) : '';

        $you_may_have_missed_aligment = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_post_elements_alignment' );
        $elementClass .= ' you-may-have-missed-align--'. $you_may_have_missed_aligment;
        $elementClass .= ' section--grid';
        ?>
            <section class="<?php echo esc_attr( $elementClass ); ?>" id="blogmatic-you-may-have-missed-section">
                <div class="blogmatic-you-may-missed-inner-wrap">
                    <?php
                        $you_may_have_missed_title_option = BMC\blogmatic_get_customizer_option( 'you_may_have_missed_title_option' );
                        if( $you_may_have_missed_title_option ) :
                            ?>
                                <div class="section-title"><?php echo esc_html__( 'You May Have Missed', 'blogmatic' ); ?></div>
                            <?php
                        endif;
                    ?>
                    <div class="you-may-have-missed-wrap">
                        <?php
                            $post_order = explode( '-', $you_may_have_missed_post_order );
                            $post_query_args = [
                                'post_type' =>  'post',
                                'post_status'  =>  'publish',
                                'posts_per_page'    =>  absint( $you_may_have_missed_no_of_posts_to_show ),
                                'order' =>  $post_order[1],
                                'order_by'  =>  $post_order[0],
                                'ignore_sticky_posts'   =>  true
                            ];
                            if( isset( $you_may_have_missed_post_categories ) ) $post_query_args['cat'] = $post_categories_id_args;
                            if( isset( $you_may_have_missed_posts_to_include ) ) $post_query_args['post__in'] = $post_to_include_id_args;
                            if( $hide_posts_with_no_featured_image ) :
                                $post_query_args['meta_query'] = [
                                    [
                                        'key'   =>  '_thumbnail_id',
                                        'compare'   =>  'EXISTS'
                                    ]
                                ];
                            endif;
                            $post_query = new \WP_Query( $post_query_args );
                            if( $post_query->have_posts() ) :
                                while( $post_query->have_posts() ) :
                                    $post_query->the_post();
                                    ?>
                                        <article class="post-item">
                                            <figure class="post-thumbnail-wrapper">
                                                <div class="post-thumnail-inner-wrapper">
                                                    <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                                                        <?php if( has_post_thumbnail() ) the_post_thumbnail( $you_may_have_missed_image_sizes ); ?>
                                                    </a>
                                                </div>
                                                <div class="inner-content">
                                                    <div class="content-wrap">
                                                        <div class="blogmatic-inner-content-wrap-fi">
                                                            <?php 
                                                                blogmatic_get_post_categories( get_the_ID(), 2 );
                                                                the_title( '<h2 class="entry-title"><a href="'. esc_url( get_the_permalink() ) .'">', '</a></h2>' );
                                                                echo '<div class="post-meta">';
                                                                    blogmatic_posted_by( 'you-may-have-missed' );
                                                                    blogmatic_posted_on( get_the_ID(), 'you-may-have-missed' );
                                                                echo '</div>';
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </figure>
                                        </article>
                                    <?php
                                endwhile;
                            endif;
                            wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </section>
        <?php
    }
    add_action( 'blogmatic_you_may_have_missed_hook', 'blogmatic_you_may_have_missed_html', 10 );
endif;

if( ! function_exists( 'blogmatic_footer_menu' ) ) :
    /**
     * Footer menu
     * 
     * @since 1.0.0
     */
    function blogmatic_footer_menu() {
        wp_nav_menu(
            array(
                'theme_location' => 'menu-2',
                'container_class' =>    'blogmatic-secondary-menu-container' 
            )
        );
    }
    add_action( 'blogmatic_footer__menu_section_hook', 'blogmatic_footer_menu' );
endif;