<?php
/**
 * Includes functions for selective refresh
 * 
 * @package Blogmatic
 * @since 1.0.0
 */
use Blogmatic\CustomizerDefault as BMC;
if( ! function_exists( 'blogmatic_customize_selective_refresh' ) ) :
    /**
     * Adds partial refresh for the customizer preview
     */
    function blogmatic_customize_selective_refresh( $wp_customize ) {
        if ( ! isset( $wp_customize->selective_refresh ) ) return;

        // theme mode light icon
        $wp_customize->selective_refresh->add_partial( 'theme_mode_dark_icon', [
            'selector'        => 'body .mode-toggle-wrap .mode-toggle',
            'render_callback' => 'blogmatic_theme_mode_callback'
        ]);

        // theme mode light icon
        $wp_customize->selective_refresh->add_partial( 'theme_mode_light_icon', [
            'selector'        => 'body .mode-toggle-wrap .mode-toggle',
            'render_callback' => 'blogmatic_theme_mode_callback'
        ]);

        // Header Builder Edit button
        $wp_customize->selective_refresh->add_partial( 'header_builder_section_tab', [
            'selector'        => 'header.site-header'
        ]);

        // Footer Builder Edit button
        $wp_customize->selective_refresh->add_partial( 'footer_section_tab', [
            'selector'        => 'footer.site-footer'
        ]);

        $post_format_partial_args = [ 'audio', 'gallery', 'image', 'standard', 'video', 'quote' ];
        if( ! empty( $post_format_partial_args ) && is_array( $post_format_partial_args ) ) :
            foreach( $post_format_partial_args as $format ):
                $wp_customize->selective_refresh->add_partial( $format . '_post_format_icon_picker', [
                    'selector'        => 'article.format-'. $format .' .post-format-ss-wrap .post-format-icon',
                    'render_callback' => 'blogmatic_'. $format .'_post_format_icon',
                ]);
            endforeach;
        endif;
    }
    add_action( 'customize_register', 'blogmatic_customize_selective_refresh' );
endif;

// theme mode callback
function blogmatic_theme_mode_callback() {
    $theme_mode_light_icon = BMC\blogmatic_get_customizer_option( 'theme_mode_light_icon' );
    $theme_mode_dark_icon = BMC\blogmatic_get_customizer_option( 'theme_mode_dark_icon' );
    blogmatic_theme_mode_switch( $theme_mode_light_icon, 'light' );
    blogmatic_theme_mode_switch( $theme_mode_dark_icon, 'dark' );
}

// audio post format icon
function blogmatic_audio_post_format_icon() {
    $audio_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'audio_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $audio_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// gallery post format icon
function blogmatic_gallery_post_format_icon() {
    $gallery_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'gallery_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $gallery_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// image post format icon
function blogmatic_image_post_format_icon() {
    $image_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'image_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $image_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// standard post format icon
function blogmatic_standard_post_format_icon() {
    $standard_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'standard_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $standard_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// video post format icon
function blogmatic_video_post_format_icon() {
    $video_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'video_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $video_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}

// quote post format icon
function blogmatic_quote_post_format_icon() {
    $quote_post_format_icon_picker = BMC\blogmatic_get_customizer_option( 'quote_post_format_icon_picker' );
	$icon_html = blogmatic_get_icon_control_html( $quote_post_format_icon_picker );
	if( $icon_html ) return $icon_html;
	return;
}