<?php
use Blogmatic\CustomizerDefault as BMC;
/**
 * Includes panel, section and controls ids and parameters
 * 
 * @since 1.0.0
 * @package Blogmatic
 */

 if( ! class_exists( 'Blogmatic_Customizer_List' ) ) :
    class Blogmatic_Customizer_List {
        /**
         * Returns panels array
         * 
         * @since 1.0.0
         */
        public function get_panels( $id = '' ) {
            $panels_array = [
                'global_panel'    =>  [
                    'title' =>  __( 'Global', 'blogmatic' ),
                    'priority'  => 6
                ],
                'colors_panel'    =>  [
                    'title' =>  __( 'Colors', 'blogmatic' ),
                    'priority'  => 20
                ],
                'archive_panel'    =>  [
                    'title' =>  __( 'Blog / Archives', 'blogmatic' ),
                    'priority'  =>  80
                ],
                'single_section_panel'    =>  [
                    'title' =>  __( 'Single Post', 'blogmatic' ),
                    'priority'  =>  80
                ]
            ];
            return ( $id ? $panels_array[ $id ] : $panels_array );
        }

        /**
         * Returns sections array
         * 
         * @since 1.0.0
         */
        public function get_sections( $id = '' ) {
            $sections_array =  [
                'about_section' => [
                    'title' => esc_html__( 'About Theme', 'blogmatic' ),
                    'priority'  => 1
                ],
                'header_builder_section' => [
                    'title' => esc_html__( 'Header Builder', 'blogmatic' ),
                    'active_callback'   =>  function(){ return false; }
                ],
                'footer_builder_section' => [
                    'title' => esc_html__( 'Footer Builder', 'blogmatic' ),
                    'active_callback'   =>  function(){ return false; }
                ],
                'header_builder_section_settings' => [
                    'title' => esc_html__( 'Header Builder', 'blogmatic' ),
                    'priority'  => 70
                ],
                'footer_builder_section_settings' => [
                    'title' => esc_html__( 'Footer Builder', 'blogmatic' ),
                    'priority'  => 80
                ],
                'seo_misc_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'SEO / Misc', 'blogmatic' ),
                ],
                'preloader_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Preloader', 'blogmatic' ),
                ],
                'website_layout_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Website Layout', 'blogmatic' ),
                ],
                'animation_section' => [
                    'title' => esc_html__( 'Animation / Hover Effects', 'blogmatic' ),
                    'panel' => 'global_panel'
                ],
                'social_icons_section' => [
                    'title' => esc_html__( 'Social Icons', 'blogmatic' ),
                ],
                'footer_social_icons_section' => [
                    'title' => esc_html__( 'Social Icons', 'blogmatic' ),
                ],
                'buttons_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Buttons', 'blogmatic' ),
                ],
                'post_format_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Post Format', 'blogmatic' ),
                ],
                'breadcrumb_options_section' => [
                    'panel' => 'global_panel',
                    'title' => esc_html__( 'Breadcrumb Options', 'blogmatic' ),
                ],
                'stt_options_section' => [
                    'title' => esc_html__( 'Scroll To Top', 'blogmatic' ),
                ],
                'advertisement_section' => [
                    'title' =>  esc_html__( 'Advertisement', 'blogmatic' ),
                    'priority'  =>  29
                ],
                'typography_section' => [
                    'title' => esc_html__( 'Typography', 'blogmatic' ),
                    'priority'  => 30
                ],
                'widget_styles_section' => [
                    'title' => esc_html__( 'Sidebar / Widget Styles', 'blogmatic' ),
                    'priority'  => 30
                ],
                'mobile_options_section' => [
                    'title' => esc_html__( 'Mobile Options', 'blogmatic' ),
                    'priority'  => 30
                ],
                'theme_presets_section' => [
                    'panel' =>  'colors_panel',
                    'title' =>  esc_html__( 'Theme Colors / Presets', 'blogmatic' ),
                ],
                'category_colors_section' => [
                    'panel' => 'colors_panel',
                    'title' => esc_html__( 'Category Colors', 'blogmatic' ),
                ],
                'tag_colors_section' => [
                    'title' => esc_html__( 'Tag Colors', 'blogmatic' ),
                    'panel' => 'colors_panel',
                ],
                'date_time_section' => [
                    'title' =>  esc_html__( 'Date / Time', 'blogmatic' )
                ],
                'header_menu_options_section' => [
                    'title' =>  esc_html__( 'Menu Options', 'blogmatic' )
                ],
                'footer_menu_options_section' => [
                    'title' =>  esc_html__( 'Menu Options', 'blogmatic' )
                ],
                'header_live_search_section' => [
                    'title' =>  esc_html__( 'Search', 'blogmatic' )
                ],
                'custom_button_section' => [
                    'title' =>  esc_html__( 'Custom Button', 'blogmatic' )
                ],
                'theme_mode_section' => [
                    'title' =>  esc_html__( 'Theme Mode', 'blogmatic' )
                ],
                'canvas_menu_section' => [
                    'title' =>  esc_html__( 'Off canvas', 'blogmatic' )
                ],
                'main_banner_section' => [
                    'title' =>  esc_html__( 'Main Banner', 'blogmatic' ),
                    'priority'  =>  70
                ],
                'carousel_section' => [
                    'title' =>  esc_html__( 'Carousel', 'blogmatic' ),
                    'priority'  =>  70
                ],
                'category_collection_section' => [
                    'title' =>  esc_html__( 'Category collection', 'blogmatic' ),
                    'priority'  =>  70
                ],
                'archive_general_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'General Settings', 'blogmatic' ),
                ],
                'category_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Category Page', 'blogmatic' ),
                ],
                'tag_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Tag Page', 'blogmatic' ),
                ],
                'author_archive_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Author Page', 'blogmatic' ),
                ],
                'pagination_settings_section' => [
                    'panel'  =>  'archive_panel',
                    'title' =>  esc_html__( 'Pagination Settings', 'blogmatic' ),
                ],
                'blog_single_general_settings' => [
                    'panel' =>  'single_section_panel',
                    'title' =>  esc_html__( 'General Settings', 'blogmatic' ),
                ],
                'blog_single_elements_settings_section' => [
                    'title' =>  esc_html__( 'Elements Settings', 'blogmatic' ),
                    'panel' =>  'single_section_panel'
                ],
                'blog_single_related_posts_section' => [
                    'panel' =>  'single_section_panel',
                    'title' =>  esc_html__( 'Related Posts', 'blogmatic' )
                ],
                'page_settings_section' => [
                    'title' =>  esc_html__( 'Page Settings', 'blogmatic' ),
                    'priority'  =>  80
                ],
                'you_may_have_missed_section' => [
                    'title' => esc_html__( 'You May Have Missed', 'blogmatic' )
                ],
                'testing_inner_section' => [
                    'title' => esc_html__( 'Inner Section', 'blogmatic' ),
                    'priority'  =>  29
                ],
                /* Header builder row settings section */
                'header_first_row' => [
                    'title' => esc_html__( 'Header First Row', 'blogmatic' )
                ],
                'header_second_row' => [
                    'title' => esc_html__( 'Header Second Row', 'blogmatic' )
                ],
                'header_third_row' => [
                    'title' => esc_html__( 'Header Third Row', 'blogmatic' )
                ],
                /* Footer builder row settings section */
                'footer_first_row' => [
                    'title' => esc_html__( 'Footer First Row', 'blogmatic' )
                ],
                'footer_second_row' => [
                    'title' => esc_html__( 'Footer Second Row', 'blogmatic' )
                ],
                'footer_third_row' => [
                    'title' => esc_html__( 'Footer Third Row', 'blogmatic' )
                ],
                'footer_logo' => [
                    'title' => esc_html__( 'Footer Logo Settings', 'blogmatic' )
                ],
                'footer_copyright' => [
                    'title' => esc_html__( 'Footer Copyright', 'blogmatic' )
                ],
                'mobile_canvas_section' => [
                    'title' => esc_html__( 'Mobile Canvas', 'blogmatic' )
                ]
            ];
            return ( $id ? $sections_array[ $id ] : $sections_array );
        }

        /**
         * Returns typography array
         * 
         * @since 1.0.0
         */
        public function get_typography( $id = '' ) {
            $default = [
                'tab'   =>  'design',
                'fields'    =>  [ 'font_family', 'font_weight', 'font_size', 'line_height', 'letter_spacing', 'text_transform', 'text_decoration' ]
            ];
            $control_array = [
                'site_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Title Typography', 'blogmatic' ),
                ]),
                'site_description_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Description Typography', 'blogmatic' ),
                ]),
                'date_time_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blogmatic' ),
                ]),
                'main_menu_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Main Menu Typography', 'blogmatic' ),
                ]),
                'main_menu_sub_menu_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Sub Menu Typography', 'blogmatic' ),
                ]),
                'custom_button_text_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typography', 'blogmatic' ),
                ]),
                'main_banner_design_post_title_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blogmatic' ),
                ]),
                'main_banner_design_post_excerpt_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Excerpt Typo', 'blogmatic' ),
                ]),
                'main_banner_design_post_categories_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blogmatic' ),
                ]),
                'main_banner_design_post_date_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blogmatic' ),
                ]),
                'main_banner_design_post_author_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blogmatic' ),
                ]),
                'carousel_design_post_title_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blogmatic' ),
                ]),
                'carousel_design_post_excerpt_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Excerpt Typo', 'blogmatic' ),
                ]),
                'carousel_design_post_categories_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blogmatic' ),
                ]),
                'carousel_design_post_date_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blogmatic' ),
                ]),
                'carousel_design_post_author_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blogmatic' ),
                ]),
                'category_collection_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blogmatic' ),
                ]),
                'global_button_typo'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                ]),
                'breadcrumb_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blogmatic' ),
                ]),
                'archive_title_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title', 'blogmatic' ),
                ]),
                'archive_excerpt_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Excerpt Typo', 'blogmatic' ),
                ]),
                'archive_category_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blogmatic' ),
                ]),
                'archive_date_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blogmatic' ),
                ]),
                'archive_author_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blogmatic' ),
                ]),
                'archive_read_time_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Read Time Typo', 'blogmatic' ),
                ]),
                'archive_comment_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Comment Typo', 'blogmatic' ),
                ]),
                'archive_category_info_box_title_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Title', 'blogmatic' ),
                ]),
                'archive_category_info_box_description_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Description Typo', 'blogmatic' ),
                ]),
                'archive_tag_info_box_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Tag Title', 'blogmatic' ),
                ]),
                'archive_tag_info_box_description_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Tag Description Typo', 'blogmatic' ),
                ]),
                'archive_author_info_box_title_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Name', 'blogmatic' ),
                ]),
                'archive_author_info_box_description_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Description Typo', 'blogmatic' ),
                ]),
                'single_title_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blogmatic' ),
                ]),
                'single_content_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Content Typo', 'blogmatic' ),
                ]),
                'single_category_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blogmatic' ),
                ]),
                'single_date_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blogmatic' ),
                ]),
                'single_author_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blogmatic' ),
                ]),
                'single_read_time_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Read Time Typo', 'blogmatic' ),
                ]),
                'page_title_typo'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Page Title Typo', 'blogmatic' ),
                ]),
                'page_content_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Page Content Typo', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_section_title_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Section Title Typo', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_post_title_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Title Typo', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_post_categories_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category Typo', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_post_date_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date Typo', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_post_author_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Author Typo', 'blogmatic' ),
                ]),
                'footer_title_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Block Title Typo', 'blogmatic' ),
                ]),
                'footer_text_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typo', 'blogmatic' ),
                ]),
                'bottom_footer_text_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Text Typo', 'blogmatic' ),
                ]),
                'bottom_footer_link_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Link Typo', 'blogmatic' ),
                ]),
                'heading_one_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 1', 'blogmatic' ),
                ]),
                'heading_two_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 2', 'blogmatic' ),
                ]),
                'heading_three_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 3', 'blogmatic' ),
                ]),
                'heading_four_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 4', 'blogmatic' ),
                ]),
                'heading_five_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 5', 'blogmatic' ),
                ]),
                'heading_six_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 6', 'blogmatic' ),
                ]),
                'sidebar_block_title_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Block Title', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_post_title_typography' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Post Title', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_category_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Category', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_date_typography'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Date', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_pagination_button_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Pagination typo', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_one_typography'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 1', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_two_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 2', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_three_typo'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 3', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_four_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 4', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_five_typo' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 5', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'sidebar_heading_six_typo'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Heading 6', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                'footer_menu_typography'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Typography', 'blogmatic' ),
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns Box shadow array
         * 
         * @since 1.0.0
         */
        public function get_box_shadow( $id = '' ) {
            $default = [
                'label' => esc_html__( 'Box Shadow', 'blogmatic' ),
                'tab'   =>  'design'
            ];
            $control_array = [];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns checkbox array
         * 
         * @since 1.0.0
         */
        public function get_checkbox( $id = '' ) {
            $default = [
                'type'  =>  'checkbox'
            ];
            $control_array = [
                'blogdescription_option'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Display site description', 'blogmatic' ),
                    'priority'  =>  40
                ]),
                'show_readmore_button_mobile_option'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show readmore button on mobile', 'blogmatic' ) 
                ]),
                'show_breadcrumb_on_mobile'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show breadcrumb on mobile', 'blogmatic' ) 
                ]),
                'show_background_animation_on_mobile'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show background animation on mobile', 'blogmatic' ) 
                ]),
                'show_scroll_to_top_on_mobile'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show scroll to top on mobile', 'blogmatic' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns toggle array
         * 
         * @since 1.0.0
         */
        public function get_toggle( $id = '' ) {
            $default = [
                'transport' =>  'refresh'
            ];
            $control_array = [
                'main_banner_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show main banner', 'blogmatic' ),
                ]),
                'carousel_option'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show carousel', 'blogmatic' ),
                    'transport' =>  'refresh'
                ]),
                'category_collection_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable category collection', 'blogmatic' ),
                ]),
                'site_schema_ready' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Make website schema ready', 'blogmatic' ),
                    'transport' =>  'postMessage'
                ]),
                'disable_admin_notices'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Disabled the theme admin notices', 'blogmatic' ),
                    'description'	      => esc_html__( 'This will hide all the notices or any message shown by the theme like review notices, change log notices', 'blogmatic' ),
                    'transport' =>  'postMessage'
                ]),
                'preloader_option'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable site preloader', 'blogmatic' )
                ]),
                'archive_category_info_box_option'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show category info box', 'blogmatic' ),
                ]),
                'archive_tag_info_box_option'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show tag info box', 'blogmatic' ),
                ]),
                'archive_author_info_box_option'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show author info box', 'blogmatic' ),
                ]),         
                'single_post_related_posts_option'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Show related articles', 'blogmatic' ),
                ]),       
                'you_may_have_missed_section_option'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Enable you may have missed section', 'blogmatic' ),
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns simple toggle array
         * 
         * @since 1.0.0
         */
        public function get_simple_toggle( $id = '' ) {
            $default = [
                'transport' =>  'refresh'
            ];
            $control_array = [
                'header_buiilder_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Section Sticky', 'blogmatic' )
                ]),
                'header_first_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 1st row', 'blogmatic' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage'
                ]),
                'header_second_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 2nd row', 'blogmatic' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage'
                ]),
                'header_third_row_header_sticky' => $this->get_params( $default, [
                    'label' => esc_html__( 'Enable Header Sticky in 3rd row', 'blogmatic' ),
                    'active_callback'   =>  function( $control ){
                        return $control->manager->get_control( 'header_buiilder_header_sticky' )->value();
                    },
                    'transport' =>  'postMessage'
                ]),
                'main_banner_hide_post_with_no_featured_image' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blogmatic' ),
                ]),
                'main_banner_trailing_hide_post_with_no_featured_image' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blogmatic' ),
                ]),
                'carousel_hide_post_with_no_featured_image' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blogmatic' ),
                ]),
                'site_breadcrumb_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show breadcrumb trails', 'blogmatic' ),
                ]),
                'single_author_option' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show author', 'blogmatic' ),
                ]),
                'single_author_image_option' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Show author image', 'blogmatic' ),
                ]),
                'you_may_have_missed_title_option' => $this->get_params( $default, [
                    'label' => esc_html__( 'Show section title', 'blogmatic' ),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_hide_post_with_no_featured_image' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hide posts with no featured image', 'blogmatic' ),
                ]),
                'archive_image_stretch' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Stretch', 'blogmatic' ),
                    'active_callback'   =>  function( $control ){
                        return in_array( $control->manager->get_setting( 'archive_post_layout' )->value(), [ 'list', 'list-two', 'list-alter' ] );
                    }
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_simple_toggle() Method

        /**
         * Get all section tab control
         * 
         * @since 1.0.0
         */
        public function get_section_tab( $id = '' ) {
            $default = [
                'choices'   =>  [
                    [
                        'name'  =>  'general',
                        'title' =>  esc_html__( 'General', 'blogmatic' )
                    ],
                    [
                        'name'  =>  'design',
                        'title' =>  esc_html__( 'Design', 'blogmatic' )
                    ]
                ],
                'priority'  =>  1
            ];
            $control_array = [
                'header_builder_section_tab'    =>  $this->get_params( $default, []),
                'site_title_section_tab'    =>  $this->get_params( $default, []),
                'menu_options_section_tab' =>  $this->get_params( $default, []),
                'footer_menu_options_section_tab' =>  $this->get_params( $default, []),
                'search_section_tab'    =>  $this->get_params( $default, []),
                'custom_button_section_tab'  =>  $this->get_params( $default, []),
                'theme_mode_section_tab' =>  $this->get_params( $default, []),
                'canvas_menu_setting'   =>  $this->get_params( $default, []),
                'category_collection_section_heading'   =>  $this->get_params( $default, []),
                'breadcrumb_section_tab'    =>  $this->get_params( $default, []),
                'archive_section_heading'   =>  $this->get_params( $default, []),
                'category_archive_section_heading'  =>  $this->get_params( $default, []),
                'tag_archive_section_heading'   =>  $this->get_params( $default, []),
                'author_archive_section_heading'    =>  $this->get_params( $default, []),
                'single_section_heading'    => $this->get_params( $default, []),
                'page_settings_section_tab' =>  $this->get_params( $default, []),
                'you_may_have_missed_section_tab'   =>  $this->get_params( $default, []),
                'footer_section_tab'    =>  $this->get_params( $default, []),
                'bottom_footer_section_tab' =>  $this->get_params( $default, []),
                'social_icons_section_heading' => $this->get_params( $default, []),
                'footer_social_icons_section_heading' => $this->get_params( $default, []),
                'main_banner_section_heading'  =>  $this->get_params( $default, []),
                'carousel_section_heading' =>  $this->get_params( $default, []),
                /* Header builder row controls */
                'header_first_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                'header_second_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                'header_third_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                /* Footer builder row controls */
                'footer_first_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                'footer_second_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                'footer_third_row_section_tab'   =>  $this->get_params( $default, [
                    'choices'   =>  [
                        [
                            'name'  =>  'general',
                            'title' =>  esc_html__( 'General', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'design',
                            'title' =>  esc_html__( 'Design', 'blogmatic' )
                        ],
                        [
                            'name'  =>  'column',
                            'title' =>  esc_html__( 'Column', 'blogmatic' )
                        ]
                    ],
                ]),
                'mobile_canvas_section_tab'   =>  $this->get_params( $default, [] ),
                'footer_menu_section_tab'   =>  $this->get_params( $default, [] )
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_tab() Method

        /**
         * Get all spacing controls
         * 
         * @since 1.0.0
         */
        public function get_spacing( $id = '' ) {
            $default = [
                'label' =>  esc_html__( 'Padding ( px )', 'blogmatic' ),
                'tab'   =>  'design',
                'input_attrs' => $this->get_input_attrs([
                    'max'   => 50
                ])
            ];

            $control_array = [
                'carousel_image_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius ( Px )', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'tab'   =>  'general'
                ]),
                'you_may_have_missed_image_border_radius'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blogmatic' ),
                    'tab'   =>  'general'
                ]),
                /* Header row paddings */
                'header_first_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'header_second_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'header_third_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                /* Footer row paddings */
                'footer_first_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'footer_second_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
                'footer_third_row_padding'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Padding', 'blogmatic' ),
                    'tab'   =>  'design',
                    'input_attrs' => $this->get_input_attrs([
                        'max'   => 200
                    ])
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_spacing() Method

        /**
         * Get all radio tab controls
         * 
         * @since 1.0.0
         */
        public function get_radio_tab( $id = '' ) {
            $default = [
                'label' => esc_html__( 'Elements Alignment', 'blogmatic' ),
                'choices' => [
                    [
                        'value' => 'left',
                        'icon'  =>  'editor-alignleft',
                        'label' =>  esc_html__( 'Left', 'blogmatic' )
                    ],
                    [
                        'value' => 'center',
                        'icon'  =>  'editor-aligncenter',
                        'label' =>  esc_html__( 'Center', 'blogmatic' )
                    ],
                    [
                        'value' => 'right',
                        'icon'  =>  'editor-alignright',
                        'label' =>  esc_html__( 'Right', 'blogmatic' )
                    ]
                ]
            ];
            $control_array = [
                'main_banner_post_elements_alignment'  =>  $this->get_params( $default, []),
                'carousel_post_elements_alignment' =>  $this->get_params( $default, []),
                'site_date_to_show'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Date to display', 'blogmatic' ),
                    'description' => esc_html__( 'Whether to show date published or modified date.', 'blogmatic' ),
                    'choices' => [
                        [
                            'value' => 'published',
                            'label' => esc_html__('Published date', 'blogmatic' )
                        ],
                        [
                            'value' => 'modified',
                            'label' => esc_html__('Modified date', 'blogmatic' )
                        ]
                    ],
                    'double_line'   =>  true,
                    'transport' =>  'refresh'
                ]),
                'archive_post_elements_alignment'  =>  $this->get_params( $default, []),
                'single_post_content_alignment'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post content alignment', 'blogmatic' ),
                ]),
                'you_may_have_missed_post_elements_alignment'  =>  $this->get_params( $default, []),
                'canvas_menu_position'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Canvas Position', 'blogmatic' ),
                    'choices'   =>  [
                        [
                            'value' => 'left',
                            'icon'  =>  'editor-alignleft'
                        ],
                        [
                            'value' => 'right',
                            'icon'  =>  'editor-alignright'
                        ]
                    ],
                    'transport' =>  'postMessage'
                ]),
                'mobile_canvas_alignment'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Alignment', 'blogmatic' ),
                    'transport' =>  'postMessage'
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_radio_tab() Method

        /**
         * Get all info box control
         * 
         * @since 1.0.0
         */
        public function get_info_box( $id = '' ) {
            $control_array = [
                'site_documentation_info' =>  [
                    'label' => esc_html__( 'Theme Documentation', 'blogmatic' ),
                    'description' => esc_html__( 'We have well prepared documentation which includes overall instructions and recommendations that are required in this theme.', 'blogmatic' ),
                    'choices' => [
                        [
                            'label' => esc_html__( 'View Documentation', 'blogmatic' ),
                            'url'   => esc_url( '//doc.blazethemes.com/blogmatic' )
                        ]
                    ]
                ],
                'site_support_info'   =>  [
                    'label' => esc_html__( 'Theme Support', 'blogmatic' ),
                    'description' => esc_html__( 'We provide 24/7 support regarding any theme issue. Our support team will help you to solve any kind of issue. Feel free to contact us.', 'blogmatic' ),
                    'choices' => [
                        [
                            'label' => esc_html__( 'Support Form', 'blogmatic' ),
                            'url'   => esc_url( '//blazethemes.com/support' )
                        ]
                    ]
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_info_box() Method

        /**
         * Get all upsell controls
         * 
         * @since 1.0.3
         */
        public function get_upsell_controls( $id = '' ){
            $default = [
                'label' =>  esc_html__( 'More Features', 'blogmatic' ),
            ];
            $control_array = [
                'preloader_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features in preloader ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '5 preloaders', 'blogmatic' ),
                        esc_html__( 'Display Preloader Animation', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' )
                    ]
                ]),
                'website_layout_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features in website layout ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Container Background Color', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' ),
                        esc_html__( 'Horizontal & Vertical Gap', 'blogmatic' ),
                        esc_html__( '4 Block Title Styles', 'blogmatic' )
                    ]
                ]),
                'global_animation_effects_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features in global animation ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'AOS Animation', 'blogmatic' ),
                        esc_html__( '20 AOS animation effects', 'blogmatic' ),
                        esc_html__( 'Always / Once display AOS animation', 'blogmatic' ),
                        esc_html__( '7 post title hover effects', 'blogmatic' ),
                        esc_html__( '5 image hover effects', 'blogmatic' ),
                        esc_html__( '2 cursor animation', 'blogmatic' )
                    ]
                ]),
                'global_button_effects_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features for global button ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Button Label & Icon', 'blogmatic' ),
                        esc_html__( 'Icon Size', 'blogmatic' ),
                        esc_html__( 'Color & Background', 'blogmatic' ),
                        esc_html__( 'Border & Border radius', 'blogmatic' ),
                        esc_html__( 'Initial & hover box shadow', 'blogmatic' ),
                        esc_html__( 'Padding', 'blogmatic' )
                    ]
                ]),
                'breadcrumb_options_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features for breadcrumb ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Separator Icon', 'blogmatic' ),
                        esc_html__( 'Text & LInk Color', 'blogmatic' ),
                        esc_html__( 'Background, Box Shadow & Padding', 'blogmatic' )
                    ]
                ]),
                'advertisement_pre_sales'  =>  $this->get_params( $default, [
                    'features'  =>  [
                        esc_html__( 'Add as many advertisements as you want.', 'blogmatic' )
                    ]
                ]),
                'sidebar_widget_styles_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more features for sidebar and widgets ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Enable / Disable Sidebar Sticky', 'blogmatic' ),
                        esc_html__( 'Image Border Radius', 'blogmatic' ),
                        esc_html__( 'Padding', 'blogmatic' ),
                        esc_html__( 'Background Color & Box Shadow', 'blogmatic' ),
                        esc_html__( 'Border Bottom', 'blogmatic' ),
                        esc_html__( 'Pagination color', 'blogmatic' ),
                        esc_html__( 'And other pagination styles', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'mobile_options_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more mobile options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show main banner', 'blogmatic' ),
                        esc_html__( 'Show carousel', 'blogmatic' ),
                        esc_html__( 'Show archive meta', 'blogmatic' ),
                        esc_html__( 'Show left & right sidebar', 'blogmatic' ),
                        esc_html__( 'Show breadcrumb', 'blogmatic' ),
                        esc_html__( 'Show scroll to top', 'blogmatic' ),
                        esc_html__( 'And many more', 'blogmatic' ),
                    ]
                ]),
                'header_builder_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more header builder options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Header Sticky on Scroll Up', 'blogmatic' ),
                        esc_html__( 'Header Sticky on Scroll down', 'blogmatic' ),
                        esc_html__( 'Border, Box Shadow & Margin', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'header_builder_first_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more header 1st row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Border Option', 'blogmatic' ),
                    ]
                ]),
                'header_builder_second_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more header 2nd row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Border Option', 'blogmatic' ),
                    ]
                ]),
                'header_builder_third_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more header 3rd row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Border Option', 'blogmatic' ),
                    ]
                ]),
                'date_time_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more date / time options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Background Color', 'blogmatic' ),
                        esc_html__( 'Border', 'blogmatic' ),
                        esc_html__( 'Padding', 'blogmatic' )
                    ]
                ]),
                'social_icons_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more social icons options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Add as many social icons as you want', 'blogmatic' ),
                        esc_html__( 'Open in New / Same Tab', 'blogmatic' ),
                        esc_html__( 'Inherit official color', 'blogmatic' ),
                        esc_html__( 'Hover animation', 'blogmatic' ),
                        esc_html__( 'Font size', 'blogmatic' )
                    ]
                ]),
                'off_canvas_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more off canvas options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Canvas width', 'blogmatic' ),
                        esc_html__( 'Background', 'blogmatic' ),
                        esc_html__( 'Canvas Border', 'blogmatic' )
                    ]
                ]),
                'primary_menu_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more menu options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 hover effects', 'blogmatic' ),
                        esc_html__( 'Enable menu cutoff', 'blogmatic' ),
                        esc_html__( 'Menu cutoff up to', 'blogmatic' ),
                        esc_html__( 'Menu cutoff more text', 'blogmatic' ),
                        esc_html__( 'Main menu active color', 'blogmatic' ),
                        esc_html__( 'Sub menu background color', 'blogmatic' ),
                        esc_html__( 'Sub menu box shadow', 'blogmatic' )
                    ]
                ]),
                'search_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more search options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Live Search', 'blogmatic' ),
                        esc_html__( 'Number of posts to show', 'blogmatic' ),
                        esc_html__( 'View all button text', 'blogmatic' ),
                        esc_html__( 'No result found text', 'blogmatic' ),
                        esc_html__( 'Show post image', 'blogmatic' ),
                        esc_html__( 'Show post date', 'blogmatic' ),
                        esc_html__( 'Modal background color', 'blogmatic' ),
                        esc_html__( 'View all button text color', 'blogmatic' ),
                        esc_html__( 'View all button background color', 'blogmatic' )
                    ]
                ]),
                'custom_button_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more custom button options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Button icon picker', 'blogmatic' ),
                        esc_html__( 'Open in New / Same Tab', 'blogmatic' ),
                        esc_html__( 'Icon Size', 'blogmatic' ),
                        esc_html__( 'Icon Distance', 'blogmatic' ),
                        esc_html__( 'Icon Context', 'blogmatic' ),
                        esc_html__( '5 Animation type', 'blogmatic' ),
                        esc_html__( 'Text & Icon Color', 'blogmatic' ),
                        esc_html__( 'Border & Border radius', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' ),
                        esc_html__( 'Padding', 'blogmatic' )
                    ]
                ]),
                'main_banner_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more main banner options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '3 banner layouts', 'blogmatic' ),
                        esc_html__( 'Display in', 'blogmatic' ),
                        esc_html__( 'Show social share', 'blogmatic' ),
                        esc_html__( 'Post to exclude', 'blogmatic' ),
                        esc_html__( 'Posts tags & authors', 'blogmatic' ),
                        esc_html__( '9 post order options', 'blogmatic' ),
                        esc_html__( 'Offset', 'blogmatic' ),
                        esc_html__( 'Meta Show / hide', 'blogmatic' ),
                        esc_html__( 'Slider Settings', 'blogmatic' ),
                        esc_html__( 'Image Ratio & border & radius', 'blogmatic' ),
                        esc_html__( 'Content Background', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'carousel_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more carousel options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '2 layouts', 'blogmatic' ),
                        esc_html__( 'Display in', 'blogmatic' ),
                        esc_html__( 'Post to exclude', 'blogmatic' ),
                        esc_html__( 'Posts tags & authors', 'blogmatic' ),
                        esc_html__( '9 post order options', 'blogmatic' ),
                        esc_html__( 'Offset', 'blogmatic' ),
                        esc_html__( 'Meta Show / hide', 'blogmatic' ),
                        esc_html__( 'Slider Settings', 'blogmatic' ),
                        esc_html__( 'Image Ratio & border', 'blogmatic' ),
                        esc_html__( 'Content Background', 'blogmatic' )
                    ]
                ]),
                'category_collection_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more category collection options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '2 layouts', 'blogmatic' ),
                        esc_html__( 'Display in', 'blogmatic' ),
                        esc_html__( 'Show category count', 'blogmatic' ),
                        esc_html__( 'Offset', 'blogmatic' ),
                        esc_html__( 'Hide empty category', 'blogmatic' ),
                        esc_html__( 'Slider settings', 'blogmatic' ),
                        esc_html__( 'Image ratio', 'blogmatic' ),
                        esc_html__( '3 image hover effects', 'blogmatic' ),
                        esc_html__( 'Text color', 'blogmatic' ),
                        esc_html__( 'Content background', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' )
                    ]
                ]),                
                'archive_general_settings_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more archive options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '8 archive layouts', 'blogmatic' ),
                        esc_html__( 'Number of columns', 'blogmatic' ),
                        esc_html__( 'Show social share', 'blogmatic' ),
                        esc_html__( 'Meta Show / Hide', 'blogmatic' ),
                        esc_html__( 'Meta icon picker', 'blogmatic' ),
                        esc_html__( 'Image Ratio', 'blogmatic' ),
                        esc_html__( 'Image Border & Border Radius', 'blogmatic' ),
                        esc_html__( 'Image Box Shadow', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' ),
                        esc_html__( 'Box Shadow & Border', 'blogmatic' ),
                        esc_html__( 'Text color', 'blogmatic' ),
                        esc_html__( 'Content background', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'category_page_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more category page options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show category icon', 'blogmatic' ),
                        esc_html__( 'Category icon', 'blogmatic' ),
                        esc_html__( 'Show category title', 'blogmatic' ),
                        esc_html__( 'Category title html tag', 'blogmatic' ),
                        esc_html__( 'Show category description', 'blogmatic' ),
                        esc_html__( 'Background', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' )
                    ]
                ]),
                'tags_page_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more tag page options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show tag icon', 'blogmatic' ),
                        esc_html__( 'Tag icon', 'blogmatic' ),
                        esc_html__( 'Show tag title', 'blogmatic' ),
                        esc_html__( 'Tag title html tag', 'blogmatic' ),
                        esc_html__( 'Show tag description', 'blogmatic' ),
                        esc_html__( 'Background', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' )
                    ]
                ]),
                'author_page_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more author page options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show author image', 'blogmatic' ),
                        esc_html__( 'Show author title', 'blogmatic' ),
                        esc_html__( 'Show author description', 'blogmatic' ),
                        esc_html__( 'Author title html tag', 'blogmatic' ),
                        esc_html__( 'Background', 'blogmatic' ),
                        esc_html__( 'Box Shadow', 'blogmatic' )
                    ]
                ]),
                'archive_pagination_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more archive options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Ajax Load More', 'blogmatic' ),
                        esc_html__( 'Button Label', 'blogmatic' ),
                        esc_html__( 'Button icon', 'blogmatic' ),
                        esc_html__( 'Icon Context', 'blogmatic' ),
                        esc_html__( 'No more results text', 'blogmatic' ),
                        esc_html__( 'Button text color', 'blogmatic' ),
                        esc_html__( 'Button background color', 'blogmatic' )
                    ]
                ]),
                'single_general_settings_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more single post options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '6 single layout', 'blogmatic' ),
                        esc_html__( 'Content Width', 'blogmatic' ),
                        esc_html__( 'Show author box', 'blogmatic' ),
                        esc_html__( 'Show author image, title & description', 'blogmatic' ),
                        esc_html__( 'Show post navigation', 'blogmatic' ),
                        esc_html__( 'Show post thumbnail & date', 'blogmatic' ),
                        esc_html__( 'Image Ratio', 'blogmatic' ),
                        esc_html__( 'Image Botder & Border Radius', 'blogmatic' ),
                        esc_html__( 'Image Box Shadow', 'blogmatic' ),
                        esc_html__( 'Background & Box Shadow', 'blogmatic' ),
                        esc_html__( 'Table of content', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'single_elements_settings_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more single element settings options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show post title', 'blogmatic' ),
                        esc_html__( 'Title Tag', 'blogmatic' ),
                        esc_html__( 'Show post thumbnail', 'blogmatic' ),
                        esc_html__( 'other meta show / hide', 'blogmatic' ),
                        esc_html__( 'Meta icon pickers', 'blogmatic' ),
                        esc_html__( 'Show lightbox', 'blogmatic' )
                    ]
                ]),
                'single_related_posts_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more single related posts options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '2 layouts', 'blogmatic' ),
                        esc_html__( 'Number of columns', 'blogmatic' ),
                        esc_html__( 'Filter By', 'blogmatic' ),
                        esc_html__( 'Show author, date & comments', 'blogmatic' )
                    ]
                ]),
                'page_settings_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more page settings options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Show page title', 'blogmatic' ),
                        esc_html__( 'Title tag', 'blogmatic' ),
                        esc_html__( 'show page thumbnail & content', 'blogmatic' ),
                        esc_html__( 'Image Ratio', 'blogmatic' ),
                        esc_html__( 'Image Border & Border Radius', 'blogmatic' ),
                        esc_html__( 'Image Box Shadow', 'blogmatic' ),
                        esc_html__( 'Background & box shadow', 'blogmatic' ),
                        esc_html__( '404 page settings', 'blogmatic' ),
                        esc_html__( 'Search page settings', 'blogmatic' ),
                        esc_html__( 'Table of content', 'blogmatic' )
                    ]
                ]),
                'scroll_to_top_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more scroll to top options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Button icon picker', 'blogmatic' ),
                        esc_html__( 'Button Align', 'blogmatic' ),
                        esc_html__( 'Display type', 'blogmatic' ),
                        esc_html__( 'Icon Text Color', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' )
                    ]
                ]),
                'you_may_have_missed_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more you may have missed options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '2 Layouts', 'blogmatic' ),
                        esc_html__( 'Section Title', 'blogmatic' ),
                        esc_html__( 'Posts to Exclude', 'blogmatic' ),
                        esc_html__( 'Posts Tag & Author', 'blogmatic' ),
                        esc_html__( '9 post order options', 'blogmatic' ),
                        esc_html__( 'Offset', 'blogmatic' ),
                        esc_html__( 'Meta show / hide', 'blogmatic' ),
                        esc_html__( 'Image Ratio', 'blogmatic' ),
                        esc_html__( 'Image Border & Box Shadow', 'blogmatic' ),
                        esc_html__( 'Block and Post title colors', 'blogmatic' )
                    ]
                ]),
                'footer_builder_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more footer builder options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Background, Border & Margin', 'blogmatic' ),
                        esc_html__( 'Block title & text color', 'blogmatic' ),
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'footer_builder_first_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more footer 1st row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Row Diraction', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' ),
                        esc_html__( 'Border', 'blogmatic' )
                    ]
                ]),
                'footer_builder_second_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more footer 2nd row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Row Diraction', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' ),
                        esc_html__( 'Border', 'blogmatic' )
                    ]
                ]),
                'footer_builder_third_row_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more footer 3rd row options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( '4 column', 'blogmatic' ),
                        esc_html__( '18 column layouts', 'blogmatic' ),
                        esc_html__( 'Row Diraction', 'blogmatic' ),
                        esc_html__( 'Background Color', 'blogmatic' ),
                        esc_html__( 'Border', 'blogmatic' )
                    ]
                ]),
                'typography_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more typography font family ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'More than 1500+ google fonts', 'blogmatic' )
                    ]
                ]),
                'footer_social_icons_section_pre_sales'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Need more social icon options ?', 'blogmatic' ),
                    'features'  =>  [
                        esc_html__( 'Add as many social icons as you want', 'blogmatic' ),
                        esc_html__( 'Open in New / Same Tab', 'blogmatic' ),
                        esc_html__( 'Inherit official color', 'blogmatic' ),
                        esc_html__( 'Hover animation', 'blogmatic' ),
                        esc_html__( 'Font size', 'blogmatic' )
                    ]
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Get all section heading toggle controls
         * 
         * @since 1.0.0
         */
        public function get_section_heading_toggle( $id = '' ) {
            $default = [];
            $control_array = [
                'main_banner_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blogmatic' ),
                ]),
                'main_banner_trailing_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Trailing Post Query', 'blogmatic' ),
                ]),
                'main_banner_post_elements_settings_heading'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blogmatic' ),
                ]),
                'main_banner_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blogmatic' ),
                    'initial'   =>  false,
                ]),
                'main_banner_design_typography'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ]),
                'carousel_post_query_settings_heading'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blogmatic' ),
                ]),
                'carousel_post_elements_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blogmatic' ),
                ]),
                'carousel_image_setting_heading'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blogmatic' ),
                ]),
                'carousel_design_typography'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ]),
                'category_collection_query_section_heading_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Query Settings', 'blogmatic' ),
                ]),
                'category_collection_image_heading_section_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Settings', 'blogmatic' ),
                ]),
                'archive_layouts_settings_header' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Layouts Settings', 'blogmatic' ),
                ]),
                'archive_elements_settings_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Elements Settings', 'blogmatic' ),
                ]),
                'archive_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blogmatic' ),
                ]),
                'archive_typography_header'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   => 'design'
                ]),
                'single_image_settings_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Image Settings', 'blogmatic' ),
                ]),
                'single_typography_header'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   => 'design',
                ]),
                'page_image_setting_heading'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blogmatic' ),
                    'initial'   =>  false,
                ]),
                'page_table_of_content_heading'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Table of content', 'blogmatic' ),
                ]),
                'page_typography_section_heading_toggle'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ]),
                'you_may_have_missed_post_query_settings_heading' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Query', 'blogmatic' ),
                ]),
                'you_may_have_missed_post_elements_settings_heading'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Post Elements Settings', 'blogmatic' ),
                ]),
                'you_may_have_missed_image_setting_heading'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Settings', 'blogmatic' ),
                ]),
                'you_may_have_missed_design_typography'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design',
                ]),
                'theme_footer_typography' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design',
                ]),
                'bottom_footer_typography'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ]),
                'widget_styles_general_settings_header'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'General Settings', 'blogmatic' ),
                ]),
                'widget_styles_sidebar_settings_header'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Sidebar Typography', 'blogmatic' ),
                ]),
                'widget_styles_headings_settings_header'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Heading Typography', 'blogmatic' ),
                ]),
                'logo_and_icon_section_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Logo & Site Icon', 'blogmatic' ),
                    'priority'  =>  5
                ]),
                'site_title_section_toggle'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Site Title & Tagline', 'blogmatic' ),
                    'priority'  =>  20
                ]),
            ];
            $totalCats = get_categories();
            if( $totalCats ) :
                foreach( $totalCats as $singleCat ) :
                    $cat_id = 'category_' . absint( $singleCat->term_id ) . '_color_heading';
                    $control_array[ $cat_id ] = [
                        'label' => esc_html( $singleCat->name ),
                    ];
                endforeach;
            endif;

            $totalTags = get_tags();
            $tag_priority = 10;
            if( $totalTags ) :
                foreach( $totalTags as $singleTag ) :
                    $tag_id = 'tag_' . absint( $singleTag->term_id ) . '_color_heading';
                    $control_array += [ $tag_id =>  [
                        'label' => esc_html( $singleTag->name ),
                    ]];
                    $tag_priority += 10;
                endforeach;
            endif;
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_heading_toggle() Method

        /**
         * Get all item sortable control
         * 
         * @since 1.0.0
         */
        public function get_item_sortable( $id = '' ) {
            $default = [ 'transport' =>  'refresh' ];
            
            $control_array = [];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_item_sortable() Method


        /**
         * Get all number controls
         * 
         * @since 1.0.0
         */
        public function get_number( $id = '' ) {
            $default = [
                'unit'  =>  'px',
                'input_attrs'   =>  $this->get_input_attrs(),
                'responsive'    =>  true
            ];
            $control_array = [
                'site_logo_width'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo Width (px)', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  400,
                        'min'   =>  100
                    ])
                ]),
                'search_icon_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Icon Size (px)', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs([])
                ]),
                'theme_mode_icon_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Icon Size', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs([])
                ]),
                'carousel_design_slider_icon_size'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Icon Size (px)', 'blogmatic' ),
                    'tab'   =>  'general',
                    'input_attrs'   =>  $this->get_input_attrs([])
                ]),
                'category_collection_number_of_columns' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'No. of columns', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  3,
                        'min'   =>  1
                    ])
                ]),
                'archive_section_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs(),
                    'tab'   =>  'design',
                    'responsive'    =>  false,
                    'transport' =>  'postMessage'
                ]),
                'single_page_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'tab'   =>  'design',
                    'responsive'    =>  false,
                ]),
                'page_border_radius'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs(),
                    'responsive'    =>  false,
                    'tab'   =>  'design'
                ]),
                'bottom_footer_logo_width'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo Width (px)', 'blogmatic' ),
                    'input_attrs'   =>  $this->get_input_attrs([
                        'max'   =>  400
                    ])
                ]),
                'category_collection_image_radius'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Border radius', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([]),
                    'responsive'    =>  true
                ]),
                /* Header Builder row controls */
                'header_first_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'header_second_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'header_third_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 3,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                /* Footer Builder row controls */
                'footer_first_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'footer_second_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ]),
                'footer_third_row_column'  =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Column count', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'         => 4,
                        'min'         => 1
                    ]),
                    'responsive'    =>  false
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_number() Method

        /**
         * Get all section heading controls
         * 
         * @since 1.0.0
         */
        public function get_section_heading( $id = '' ) {

            $control_array = [
                'header_sub_menu_header'    =>  [
                    'label' => esc_html__( 'Sub Menu', 'blogmatic' ),
                    'tab'   => 'design',
                ],
                'header_main_menu_header'    =>  [
                    'label' => esc_html__( 'Main Menu', 'blogmatic' ),
                    'tab'   => 'design',
                ],
                'typography_preset_header'    =>  [
                    'label' => esc_html__( 'Typography Preset', 'blogmatic' ),
                ],
                'heading_typographies'    =>  [
                    'label' => esc_html__( 'Headings', 'blogmatic' ),
                ],
                'disable_admin_notices_heading' =>  [
                    'label' => esc_html__( 'Admin Settings', 'blogmatic' ),
                ],
                'website_layout_header' =>  [
                    'label' => esc_html__( 'Website Layout', 'blogmatic' ),
                ],
                'site_hover_animation'  =>  [
                    'label' => esc_html__( 'Hover Animation', 'blogmatic' ),
                ],
                'archive_category_info_box_typography_heading'   =>  [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ],
                'archive_tag_info_box_typography_heading'   =>  [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ],
                'archive_author_info_box_typography_heading'   =>  [
                    'label' => esc_html__( 'Typography', 'blogmatic' ),
                    'tab'   =>  'design'
                ],
                'site_background_animation_settings_heading'   =>  [
                    'label' => esc_html__( 'Animation Settings', 'blogmatic' ),
                ],
                'theme_colors_section_heading'   =>  [
                    'label' => esc_html__( 'Theme Colors', 'blogmatic' ),
                ],
                'theme_presets_section_heading'   =>  [
                    'label' => esc_html__( 'Presets', 'blogmatic' ),
                ],
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_section_heading() Method

        /**
         * Get all redirect controls
         * 
         * @since 1.0.0
         */
        public function get_redirect_control( $id = '' ) {

            $control_array = [
                'canvas_menu_redirects' =>  [
                    'label' => esc_html__( 'Widgets', 'blogmatic' ),
                    'tab'   => 'general',
                    'choices'     => [
                        'canvas-menu-sidebar' => [
                            'type'  => 'section',
                            'id'    => 'sidebar-widgets-canvas-menu-sidebar',
                            'label' => esc_html__( 'Manage canvas menu widget', 'blogmatic' )
                        ]
                    ]
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_redirect_control() Method

        /**
         * Get all radio image controls
         * 
         * @since 1.0.0
         */
        public function get_radio_image( $id = '' ) {
            $theme_directory = get_template_directory_uri();
            $control_array = [
                'website_layout'  =>  [
                    'choices'  => [
                        'boxed--layout' => [
                            'label' => esc_html__( 'Boxed', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout' => [
                            'label' => esc_html__( 'Full Width', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ]  
                ],
                'archive_post_layout' =>  [
                   'label' =>  esc_html__( 'Archive Layout', 'blogmatic' ),
                   'choices'  => apply_filters( 'blogmatic_archive_layout_filter', [
                       'list' => [
                           'label' => esc_html__( 'List', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/archive-list.png'
                       ],
                       'mixed' => [
                           'label' => esc_html__( 'Mixed', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/archive-alter.png'
                       ],
                       'list-alter' => [
                           'label' => esc_html__( 'List Alter', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/archive-list-alter.png'
                       ]
                    ]),
                    'transport' =>  'refresh'
                ],
                'archive_sidebar_layout'  =>  [
                   'label' =>  esc_html__( 'Sidebar Layout', 'blogmatic' ),
                   'choices'  => [
                       'right-sidebar' => [
                           'label' => esc_html__( 'Right Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                       ],
                       'left-sidebar' => [
                           'label' => esc_html__( 'Left Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                       ],
                       'both-sidebar' => [
                           'label' => esc_html__( 'Both Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                       ],
                       'no-sidebar' => [
                           'label' => esc_html__( 'No Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                       ]
                    ],
                    'transport' =>  'refresh'
               ],   
                'single_post_layout'  =>  [
                   'label' =>  esc_html__( 'Single Layout', 'blogmatic' ),
                   'choices'  => [
                       'layout-one' => [
                           'label' => esc_html__( 'Layout 1', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/single-one.png'
                       ],
                       'layout-six' => [
                           'label' => esc_html__( 'Layout 2', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/single-six.png'
                       ]
                    ],
                    'transport' =>  'refresh'
                ],
                'single_sidebar_layout'   =>  [
                    'label' =>  esc_html__( 'Sidebar Layout', 'blogmatic' ),
                    'choices'  => [
                        'right-sidebar' => [
                            'label' => esc_html__( 'Right Sidebar', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                        ],
                        'left-sidebar' => [
                            'label' => esc_html__( 'Left Sidebar', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                        ],
                        'both-sidebar' => [
                            'label' => esc_html__( 'Both Sidebar', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                        ],
                        'no-sidebar' => [
                            'label' => esc_html__( 'No Sidebar', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                        ]
                    ],
                    'transport' =>  'refresh'
                ],
                'page_settings_sidebar_layout'    =>  [
                   'label' =>  esc_html__( 'Sidebar Layout', 'blogmatic' ),
                   'choices'  => [
                       'right-sidebar' => [
                           'label' => esc_html__( 'Right Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/right-sidebar.png'
                       ],
                       'left-sidebar' => [
                           'label' => esc_html__( 'Left Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/left-sidebar.png'
                       ],
                       'both-sidebar' => [
                           'label' => esc_html__( 'Both Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/both-sidebar.png'
                       ],
                       'no-sidebar' => [
                           'label' => esc_html__( 'No Sidebar', 'blogmatic' ),
                           'url'   => $theme_directory . '/assets/images/customizer/no-sidebar.png'
                       ]
                    ],
                    'transport' =>  'refresh'
                ],
                'header_builder_section_width'  =>  [
                    'label' => esc_html__( 'Section Width', 'blogmatic' ),
                    'choices' => [
                        'boxed--layout' =>  [
                            'label' => esc_html__('Boxed', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout'    =>  [
                            'label' => esc_html__('Full Width', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ]
                ],
                'footer_builder_section_width'  =>  [
                    'label' => esc_html__( 'Section Width', 'blogmatic' ),
                    'choices' => [
                        'boxed--layout' =>  [
                            'label' => esc_html__('Boxed', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/boxed-width.png'
                        ],
                        'full-width--layout'    =>  [
                            'label' => esc_html__('Full Width', 'blogmatic' ),
                            'url'   => $theme_directory . '/assets/images/customizer/full-width.png'
                        ]
                    ]
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_radio_image() Method

        /**
         * Get all icon picker controls
         * 
         * @since 1.0.0
         */
        public function get_icon_picker( $id = '' ) {
            $default = [
                'include_media' =>  true
            ];

            $control_array = [
                'theme_mode_dark_icon'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Choose Dark Icon', 'blogmatic' ),
                    'include_media' =>  false
                ]), 
                'theme_mode_light_icon'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Choose Light Icon', 'blogmatic' ),
                    'include_media' =>  false
                ]),
                'carousel_slider_prev_arrow'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Prev Arrow', 'blogmatic' ),
                    'transport' =>  'refresh'
                ]),
                'carousel_slider_next_arrow'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Next Arrow', 'blogmatic' ),
                    'transport' =>  'refresh'
                ]),
                'standard_post_format_icon_picker'    =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Standard post format', 'blogmatic' ),
                ]),
                'audio_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Audio post format', 'blogmatic' ),
                ]),
                'gallery_post_format_icon_picker' =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Gallery post format', 'blogmatic' ),
                ]),
                'image_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Image post format', 'blogmatic' ),
                ]),
                'quote_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Quote post format', 'blogmatic' ),
                ]),
                'video_post_format_icon_picker'   =>  $this->get_params( $default, [
                   'label' =>  esc_html__( 'Video post format', 'blogmatic' ),
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_icon_picker() Method

        /**
         * Get all text controls
         * 
         * @since 1.0.0
         */
        public function get_text( $id = '' ) {
            $default = [
                'label' =>  esc_html__( 'Button Label', 'blogmatic' ),
                'type'  =>  'text',
                'tab'   => 'general'
            ];

            $control_array = [
                'custom_button_label' =>  $this->get_params( $default, []),
                'stt_text'  =>  $this->get_params( $default, []),
                'single_post_related_posts_title'   =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Related articles title', 'blogmatic' )
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_text() Method

        /**
         * Get all select controls
         * 
         * @since 1.0.0
         */
        public function get_select( $id = '' ) {
            $default = [
                'type'  =>  'select',
                'transport' =>  'refresh'
            ];

            $control_array = [
                'site_title_tag_for_frontpage'    =>  $this->get_params( $default, [
                    'label'   =>  esc_html__( 'Site Title Tag (For Frontpage)', 'blogmatic' ),
                    'choices'   =>  apply_filters( 'blogmatic_get_title_tags_array_filter', [] ),
                    'priority'  =>  30
                ]),
                'site_title_tag_for_innerpage'    =>  $this->get_params( $default, [
                    'label'   =>  esc_html__( 'Site Title Tag (For Innerpage)', 'blogmatic' ),
                    'choices'   =>  apply_filters( 'blogmatic_get_title_tags_array_filter', [] ),
                    'priority'  =>  30
                ]),
                'header_menu_hover_effect'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover Effect', 'blogmatic' ),
                    'choices'   =>  [
                        'none'  =>  esc_html__( 'None', 'blogmatic' ),
                        'two'  =>  esc_html__( 'Effect 1', 'blogmatic' ),
                        'four'  =>  esc_html__( 'Effect 2', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'footer_menu_hover_effect'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover Effect', 'blogmatic' ),
                    'choices'   =>  [
                        'none'  =>  esc_html__( 'None', 'blogmatic' ),
                        'two'  =>  esc_html__( 'Effect 1', 'blogmatic' ),
                        'four'  =>  esc_html__( 'Effect 2', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'main_banner_post_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blogmatic' ),
                    'choices'   =>  blogmatic_post_order_args()
                ]),
                'main_banner_trailing_post_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blogmatic' ),
                    'choices'   =>  blogmatic_post_order_args()
                ]),
                'main_banner_image_sizes' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'carousel_post_order' =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blogmatic' ),
                    'choices'   =>  blogmatic_post_order_args(),
                ]),
                'carousel_image_sizes'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'category_collection_orderby' =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Order by', 'blogmatic' ),
                    'choices'   =>  [
                        'asc-name'  =>  esc_html__( 'A - Z', 'blogmatic' ),
                        'desc-name'  =>  esc_html__( 'Z - A', 'blogmatic' ),
                        'asc-count'  =>  esc_html__( 'Count(1, 2,.. 10)', 'blogmatic' ),
                        'desc-count'  =>  esc_html__( 'Count(10, 9,...1)', 'blogmatic' )
                    ],
                ]),
                'category_collection_image_size'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'category_collection_hover_effects'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Hover effects', 'blogmatic' ),
                    'choices'   =>  [
                        'none'   =>  esc_html__( 'None', 'blogmatic' ),
                        'one'   =>  esc_html__( 'Effect 1', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'archive_image_size'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'archive_pagination_type' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Pagination Type', 'blogmatic' ),
                    'choices'   =>  apply_filters( 'blogmatic_get_pagination_type_array_filter', [
                        'default'   => esc_html__( 'Default', 'blogmatic' ),
                        'number'    => esc_html__( 'Number', 'blogmatic' )
                    ]),
                ]),
                'single_image_size'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'page_image_size' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'you_may_have_missed_post_order'  =>  $this->get_params( $default, [
                    'label' =>  esc_html( 'Post Order', 'blogmatic' ),
                    'choices'   =>  blogmatic_post_order_args(),
                ]),
                'you_may_have_missed_image_sizes' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Image Sizes', 'blogmatic' ),
                    'choices'   =>  blogmatic_get_image_sizes_option_array_for_customizer(),
                ]),
                'bottom_footer_header_or_custom'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Logo From', 'blogmatic' ),
                    'choices'   =>  [
                        'header'  =>  esc_html__( 'Default Site Logo', 'blogmatic' ),
                        'custom'  =>  esc_html__( 'Custom', 'blogmatic' )
                    ],
                ]),
                'site_date_format'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Date format', 'blogmatic' ),
                    'description' => esc_html__( 'Date format applied to single and archive pages.', 'blogmatic' ),
                    'choices'   => [
                        'theme_format'  => esc_html__( 'Default by theme', 'blogmatic' ),
                        'default'   => esc_html__( 'Wordpress default date', 'blogmatic' )
                    ],
                ]),
                'post_title_hover_effects'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Post title hover effects', 'blogmatic' ),
                    'description' => esc_html__( 'Applied to post titles listed in archive pages.', 'blogmatic' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blogmatic' ),
                        'three'  => esc_html__( 'Effect One', 'blogmatic' ),  
                        'five'  => esc_html__( 'Effect Two', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'site_image_hover_effects'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Image hover effects', 'blogmatic' ),
                    'description' => esc_html__( 'Applied to post thumbanails listed in archive pages.', 'blogmatic' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blogmatic' ),
                        'three'  => esc_html__( 'Effect One', 'blogmatic' ),
                        'five'  => esc_html__( 'Effect Two', 'blogmatic' ) 
                    ],
                    'transport' =>  'postMessage'
                ]),
                'cursor_animation'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Cursor animation', 'blogmatic' ),
                    'description' => esc_html__( 'Applied to mouse pointer.', 'blogmatic' ),
                    'choices'   => [
                        'none' => esc_html__( 'None', 'blogmatic' ),
                        'two'  => esc_html__( 'Animation 1', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'site_breadcrumb_type'    =>  $this->get_params( $default, [
                    'label'     => esc_html__( 'Breadcrumb type', 'blogmatic' ),
                    'description' => esc_html__( 'If you use other than "default" one you will need to install and activate respective plugins Breadcrumb NavXT, Yoast SEO and Rank Math SEO', 'blogmatic' ),
                    'choices'   => [
                        'default' => esc_html__( 'Default', 'blogmatic' ),
                        'bcn'  => esc_html__( 'NavXT', 'blogmatic' ),
                        'yoast'  => esc_html__( 'Yoast SEO', 'blogmatic' ),
                        'rankmath'  => esc_html__( 'Rank Math', 'blogmatic' )
                    ]
                ]),
                'custom_button_animation_type'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Animation Type', 'blogmatic' ),
                    'choices'   => [
                        'none'  => esc_html__( 'None', 'blogmatic' ),
                        'three' => esc_html__( 'Effect One', 'blogmatic' ),
                        'four'  => esc_html__( 'Effect Two', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ]),
                'site_background_animation'    =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Background animation', 'blogmatic' ),
                    'choices'	=>	[
                        'none'	=>	esc_html__( 'None', 'blogmatic' ),
                        'two'	=>	esc_html__( 'Animation 1', 'blogmatic' )
                    ],
                    'transport' =>  'postMessage'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_select() Method

        /**
         * Get all border controls
         * 
         * @since 1.0.0
         */
        public function get_border( $id = '' ) {
            $default = [
                'label' =>  esc_html__( 'Border', 'blogmatic' ),
                'input_attr'    =>  [
                    'max'   =>  100,
                    'min'   =>  0,
                    'step'  =>  1
                ]
            ];

            $control_array = [];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_border() Method

        /**
         * Get all preset controls
         * 
         * @since 1.0.0
         */
        public function get_preset_colors( $id = '' ) {
            $default = [
            ];

            $control_array = [
                'solid_color_preset'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Solid Presets', 'blogmatic' ),
                    'description'   =>  esc_html__( 'Set color presets', 'blogmatic' ),
                ]),
                'gradient_color_preset'   =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Gradient Presets', 'blogmatic' ),
                    'description'   =>  esc_html__( 'Set gradient presets', 'blogmatic' ),
                    'blend' =>  'gradient',
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_preset_colors() Method

        /**
         * Get all color controls
         * 
         * @since 1.0.0
         */
        public function get_colors( $id = '' ) {
            $default = [
                'tab'   =>  'design',
                'involve'   =>  [ 'solid' ],
                'hover' =>  false,
            ];
            
            $control_array = [
                'site_background_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Background Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid', 'gradient' ],
                    'tab'   =>  'general',
                    'description'   =>  esc_html__( 'If background image is set, this will act as overlay.', 'blogmatic' )
                ]),
                // solid initial hover
                'social_icon_color'   => $this->get_params( $default, [
                    'label' => esc_html__( 'Social Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'footer_social_icon_color'   => $this->get_params( $default, [
                    'label' => esc_html__( 'Social Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'header_menu_color'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Text Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true,
                ]),
                'footer_menu_color'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Text Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true,
                ]),
                'header_sub_menu_color' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Text Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true,
                ]),
                'search_icon_color'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'theme_mode_dark_icon_color'  => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Dark Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'theme_mode_light_icon_color' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'Light Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                'canvas_menu_icon_color'   => $this->get_params( $default, [
                    'label'     => esc_html__( 'Canvas Menu Icon Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid' ],
                    'hover' =>  true
                ]),
                // initial hover solid gradient
                'header_custom_button_background_color_group'   => $this->get_params( $default, [
                    'label' => esc_html__( 'Background Color', 'blogmatic' ),
                    'involve'   =>  [ 'solid', 'gradient' ], 
                    'hover' =>  true
                ]),
                // solid gradient image
                'header_builder_background' => $this->get_params( $default, [
                   'label' => esc_html__( 'Background', 'blogmatic' ),
                   'involve' => [ 'solid', 'gradient', 'image' ]
                ]),
                /* Header builder row settings section */
                'header_first_row_background' => $this->get_params( $default, [
                   'label' => esc_html__( 'Background Color', 'blogmatic' ),
                   'involve' => [ 'solid', 'gradient' ]
                ]),
                'header_second_row_background' => $this->get_params( $default, [
                   'label' => esc_html__( 'Background Color', 'blogmatic' ),
                   'involve' => [ 'solid', 'gradient' ]
                ]),
                'header_third_row_background' => $this->get_params( $default, [
                   'label' => esc_html__( 'Background Color', 'blogmatic' ),
                   'involve' => [ 'solid', 'gradient' ]
                ]),
                /* Mobile Canvas */
                'mobile_canvas_icon_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Icon Color', 'blogmatic' ),
                   'involve' => [ 'solid' ],
                   'hover'  =>  true,
                   'tab'   =>  'design'
                ]),
                /* Date Time */
                'date_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Date Color', 'blogmatic' ),
                   'involve' => [ 'solid' ]
                ]),
                'time_color' => $this->get_params( $default, [
                   'label' => esc_html__( 'Time Color', 'blogmatic' ),
                   'involve' => [ 'solid' ]
                ])
            ];
            $totalCats = get_categories();
            if( $totalCats ) :
                foreach( $totalCats as $key => $singleCat ) :
                    $cat_color_id = 'category_' . absint( $singleCat->term_id ) . '_color';
                    $control_array[ 'category_top_spacing_' . $key ] = [];
                    $control_array[ $cat_color_id ] = [
                        'label' => esc_html__( 'Text Color', 'blogmatic' ),
                        'involve'   =>  [ 'solid' ],
                        'hover' =>  true,
                    ];

                    $background_id = 'category_background_' . absint( $singleCat->term_id ) . '_color';
                    $control_array[ $background_id ] = [
                        'label' => esc_html__( 'Background', 'blogmatic' ),
                        'involve'   =>  [ 'solid', 'gradient' ],
                        'hover' =>  true,
                    ];
                    if( count( $totalCats ) != ( $key + 1 ) ) $control_array[ 'category_bottom_spacing_' . $key ] = [];
                endforeach;
            endif;

            $totalTags = get_tags();
            $tag_priority = 10;
            if( $totalTags ) :
                foreach( $totalTags as $key => $singleTag ) :
                    $tag_color_id = 'tag_' . absint( $singleTag->term_id ) . '_color';
                    $control_array[ 'tag_top_spacing_' . $key ] = [];
                    $control_array += [ $tag_color_id =>  [
                        'label' => esc_html__( 'Text Color', 'blogmatic' ),
                        'involve'   =>  [ 'solid' ],
                        'hover' =>  true,
                    ]];

                    $background_id = 'tag_background_' . absint( $singleTag->term_id ) . '_color';
                    $control_array += [ $background_id   =>  [
                        'label' => esc_html__( 'Background', 'blogmatic' ),
                        'involve'   =>  [ 'solid', 'gradient' ],
                        'hover' =>  true,
                    ]];
                    $tag_priority += 10;
                    if( count( $totalTags ) != ( $key + 1 ) ) $control_array[ 'tag_bottom_spacing_' . $key ] = [];
                endforeach;
            endif;
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_colors() Method

        /**
         * Get all editor controls
         * 
         * @since 1.0.0
         */
        public function get_editor_control( $id = '' ) {
            $control_array = [];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_editor_control() Method

        /**
         * Get all Media controls
         * 
         * @since 1.0.0
         */
        public function get_media_control( $id = '' ) {
            $default = [
                'mime_type' => 'image',
                'transport' =>  'refresh'
            ];

            $control_array = [
                'bottom_footer_logo_option'   =>  $this->get_params( $default, [
                    'label' => esc_html__( 'Footer Logo', 'blogmatic' ),
                    'description' => esc_html__( 'Upload image for bottom footer', 'blogmatic' ),
                    'active_callback'   =>  function( $control ) {
                        return ( $control->manager->get_setting( 'bottom_footer_header_or_custom' )->value() == 'custom' );
                    },
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_media_control() Method

        /**
         * Get all wordpress default color controls
         * 
         * @since 1.0.0
         */
        public function get_predefined_colors( $id = '' ) {
            $default = [
                'tab'   =>  'design',
                'priority'  =>  20
            ];

            $control_array = [
                'site_title_hover_textcolor'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Title Hover Color', 'blogmatic' )
                ]),
                'site_description_color'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Site Description Color', 'blogmatic' )
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_predefined_colors() Method

        /**
         * Get all custom repeater controls
         * 
         * @since 1.0.0
         */
        public function get_custom_repeaters( $id = '' ) {
            $default = [ 'transport' =>  'refresh' ];

            $control_array = [
                'social_icons' =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Social Icons', 'blogmatic' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blogmatic' ),
                    'row_label'     => 'inherit-icon_class',
                    'add_new_label' => esc_html__( 'Add New Icon', 'blogmatic' ),
                    'fields'        => [
                        'icon_class'   => [
                            'type'          => 'fontawesome-icon-picker',
                            'label'         => esc_html__( 'Social Icon', 'blogmatic' ),
                            'description'   => esc_html__( 'Select from dropdown.', 'blogmatic' ),
                            'default'       => esc_attr( 'fab fa-instagram' ),
                            'families'  =>  'social'
                        ],
                        'icon_url'  => [
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL for icon', 'blogmatic' ),
                            'default'   => ''
                        ],
                        'item_option'             => 'show'
                    ]
                ]),
                'footer_social_icons' =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Social Icons', 'blogmatic' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blogmatic' ),
                    'row_label'     => 'inherit-icon_class',
                    'add_new_label' => esc_html__( 'Add New Icon', 'blogmatic' ),
                    'fields'        => [
                        'icon_class'   => [
                            'type'          => 'fontawesome-icon-picker',
                            'label'         => esc_html__( 'Social Icon', 'blogmatic' ),
                            'description'   => esc_html__( 'Select from dropdown.', 'blogmatic' ),
                            'default'       => esc_attr( 'fab fa-instagram' ),
                            'families'  =>  'social'
                        ],
                        'icon_url'  => [
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL for icon', 'blogmatic' ),
                            'default'   => ''
                        ],
                        'item_option'             => 'show'
                    ]
                ]),
                'advertisement_repeater'  =>  $this->get_params( $default, [
                    'label'         => esc_html__( 'Advertisements', 'blogmatic' ),
                    'description'   => esc_html__( 'Hold and drag vertically to re-order the icons', 'blogmatic' ),
                    'row_label'     => esc_html__( 'Advertisement', 'blogmatic' ),
                    'add_new_label' => esc_html__( 'Add New Advertisement', 'blogmatic' ),
                    'fields'        => [
                        'item_image'   => [
                            'type'          => 'image',
                            'label'         => esc_html__( 'Image', 'blogmatic' ),
                            'default'       => 0
                        ],
                        'item_url'  => [
                            'type'      => 'url',
                            'label'     => esc_html__( 'URL', 'blogmatic' ),
                            'default'   => ''
                        ],
                        'item_target'   =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Open in', 'blogmatic' ),
                            'default'   =>  '_self',
                            'options'   =>  [
                                '_blank'    =>  esc_html__( 'New tab', 'blogmatic' ),
                                '_self'    =>  esc_html__( 'Same tab', 'blogmatic' )
                            ]
                        ],
                        'item_rel_attribute'    =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Rel', 'blogmatic' ),
                            'default'   =>  'opener',
                            'options'   =>  [
                                'nofollow'  =>  esc_html__( 'No follow', 'blogmatic' ),
                                'noopener'  =>  esc_html__( 'No opener', 'blogmatic' ),
                                'noreferrer'  =>  esc_html__( 'No referrer', 'blogmatic' )
                            ]
                        ],
                        'item_heading'  =>  [
                            'type'  =>  'heading',
                            'label' =>  esc_html__( 'Display Area', 'blogmatic' )
                        ],
                        'item_checkbox_before_post_content' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'Before post content', 'blogmatic' ),  
                            'default'   =>  false
                        ],
                        'item_checkbox_after_post_content' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'After post content', 'blogmatic' ),  
                            'default'   =>  false
                        ],
                        'item_checkbox_random_post_archives' =>  [
                            'type'  =>  'checkbox',
                            'label' =>  esc_html__( 'Random post archives', 'blogmatic' ),  
                            'default'   =>  false
                        ],
                        'item_alignment'    =>   [
                            'type'  =>  'alignment',
                            'label' =>  esc_html__( 'Ad Alignment', 'blogmatic' ),
                            'default'   =>  'left',
                            'options'   =>  [
                                'left'  =>  esc_html__( 'fa-solid fa-align-left', 'blogmatic' ),
                                'center'  =>  esc_html__( 'fa-solid fa-align-center', 'blogmatic' ),
                                'right'  =>  esc_html__( 'fa-solid fa-align-right', 'blogmatic' )
                            ]
                        ],
                        'item_image_option' =>  [
                            'type'  =>  'select',
                            'label' =>  esc_html__( 'Image Option', 'blogmatic' ),
                            'default'   =>  'original',
                            'options'   =>  [
                                'full_width'  =>  esc_html__( 'Full Width', 'blogmatic' ),
                                'original'  =>  esc_html__( 'Original', 'blogmatic' )
                            ]
                        ],
                        'item_option'             => 'show'
                    ]
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_custom_repeaters() Method

        /**
         * Get all controls rendered using predefined number control
         * 
         * @since 1.0.0
         */
        public function get_custom_number_controls( $id = '' ) {
            $default = [
                'type'  =>  'number',
                'input_attrs'   =>  $this->get_input_attrs([
                    'min'   =>  1
                ]),
                'transport' =>  'refresh'
            ];

            $control_array = [
                'main_banner_no_of_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blogmatic' ),
                ]),
                'main_banner_trailing_no_of_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blogmatic' ),
                ]),
                'carousel_no_of_columns'   => $this->get_params( $default, [
                    'label' =>  esc_html__( 'No of Columns', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'min'   =>  2,
                        'max'   =>  3
                    ])
                ]),
                'carousel_no_of_posts_to_show'   => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blogmatic' ),
                ]),
                'category_collection_number'  => $this->get_params( $default, [
                    'label' => esc_html__( 'Number of category', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  10,
                        'min'   =>  1
                    ])
                ]),
                'you_may_have_missed_no_of_columns' => $this->get_params( $default, [
                    'label' =>  esc_html__( 'No of Columns', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'min'   =>  2,
                        'max'   =>  4
                    ]),
                    'transport' =>  'postMessage'
                ]),
                'you_may_have_missed_no_of_posts_to_show' => $this->get_params( $default, [
                    'label' =>  esc_html( 'No of posts to show', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  4,
                        'min'   =>  1
                    ])
                ]),
                'sidebar_border_radius' =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Border Radius (px)', 'blogmatic' ),
                    'input_attrs' => $this->get_input_attrs([
                        'max'   =>  50
                    ]),
                    'transport' =>  'postMessage'
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_custom_number_controls() Method

        /**
         * Get a list of all url controls
         * 
         * @since 1.0.0
         */
        public function get_url( $id = '' ) {
            $default = [
                'type'  =>  'url',
                'transport' =>  'refresh'
            ];

            $control_array = [
                'custom_button_redirect_href_link'    =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Redirect URL', 'blogmatic' ),
                    'description'   =>  esc_html__( 'Add url for the button to redirect', 'blogmatic' ),
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_url() Method

        /**
         * Get all multiselect controls
         * 
         * @since 1.0.0
         */
        public function get_multiselect_controls( $id = '' ) {
            $default = [
                'endpoint'   =>  'extend/get_taxonomy',
                'purpose'   =>  'post',
                'transport' =>  'refresh'
            ];

            $control_array = [
                // category
                'main_banner_slider_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                'main_banner_trailing_slider_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                'carousel_slider_categories'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                'category_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Category to include', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                'category_to_exclude' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Category to exclude', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                'you_may_have_missed_categories' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts Categories', 'blogmatic' ),
                    'purpose'   =>  'category'
                ]),
                // posts
                'main_banner_slider_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blogmatic' ),
                    'endpoint'   =>  'extend/get_posts'
                ]),
                'main_banner_trailing_slider_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blogmatic' ),
                    'endpoint'   =>  'extend/get_posts'
                ]),
                'carousel_slider_posts_to_include'  => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blogmatic' ),
                    'endpoint'   =>  'extend/get_posts'
                ]),
                'you_may_have_missed_posts_to_include' => $this->get_params( $default, [
                    'label'     => esc_html__( 'Posts To Include', 'blogmatic' ),
                    'endpoint'   =>  'extend/get_posts'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_multiselect_controls() Method

        /**
         * Get all normal multiselect controls
         * 
         * @since 1.0.0
         */
        public function get_normal_multiselect_controls( $id = '' ) {
            $default = [
                'label'     => esc_html__( 'Field of headings', 'blogmatic' ),
                'choices'   => [
                    [
                        'value' => 'h1',
                        'label' => esc_html__('H1', 'blogmatic' )
                    ],
                    [
                        'value' => 'h2',
                        'label' => esc_html__('H2', 'blogmatic' )
                    ],
                    [
                        'value' => 'h3',
                        'label' => esc_html__('H3', 'blogmatic' )
                    ],
                    [
                        'value' => 'h4',
                        'label' => esc_html__('H4', 'blogmatic' )
                    ],
                    [
                        'value' => 'h5',
                        'label' => esc_html__('H5', 'blogmatic' )
                    ],
                    [
                        'value' => 'h6',
                        'label' => esc_html__('H6', 'blogmatic' )
                    ]
                ],
                'transport' =>  'refresh'
            ];

            $control_array = [];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_normal_multiselect_controls() Method

        /**
         * Get all reflector controls
         * 
         * @since 1.0.0
         */
        public function get_builder_reflector_controls( $id ) {
            $default = [
                'label' =>  esc_html__( 'Row Widgets', 'blogmatic' )
            ];
            $control_array = [
                /* Header builder reflectors */
                'header_first_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	1,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                'header_second_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	2,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                'header_third_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'header',
                    'builder'	=>	'header_builder',
                    'row'	=>	3,
                    'responsive'    =>  'responsive-header',
                    'responsive_builder_id' =>  'responsive_header_builder'
                ]),
                /* Footer builder reflectors */
                'footer_first_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	1
                ]),
                'footer_second_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	2
                ]),
                'footer_third_row_reflector' => $this->get_params( $default, [
                    'placement'	=>	'footer',
                    'builder'	=>	'footer_builder',
                    'row'	=>	3
                ]),
                /* Responsive Header Builder reflector */
                'mobile_canvas_reflector' => $this->get_params( $default, [
                    'placement'	=>	'responsive-header',
                    'builder'	=>	'responsive_header_builder',
                    'row'	=>	4
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_builder_reflector_controls() Method

        /**
         * Get all responsive radio image  controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_radio_image( $id ) {
            $default = [];
            $theme_directory = get_template_directory_uri();
            $column_layouts = [
                'one' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_one.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 1 ]
                ],
                'two' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_two.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'three' => [
                    'label' => esc_html__( 'Layout Two', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_three.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'five' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_five.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'seven' => [
                    'label' => esc_html__( 'Layout Two', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_seven.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'thirteen' => [
                    'label' => esc_html__( 'Layout Three', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_thirteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 2 ]
                ],
                'sixteen' => [
                    'label' => esc_html__( 'Layout Three', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_sixteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 3 ]
                ]
            ];

            $footer_column_layouts = [
                'one' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_one.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 1 ]
                ],
                'two' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_two.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'three' => [
                    'label' => esc_html__( 'Layout Two', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_three.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 2 ]
                ],
                'five' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_five.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 3 ]
                ],
                'nine' => [
                    'label' => esc_html__( 'Layout One', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_nine.png',
                    'devices'	=>	[ 'smartphone', 'tablet', 'desktop' ],
                    'columns'	=>	[ 4 ]
                ],
                'thirteen' => [
                    'label' => esc_html__( 'Layout Three', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_thirteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 2 ]
                ],
                'sixteen' => [
                    'label' => esc_html__( 'Layout Two', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_sixteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 3 ]
                ],
                'eighteen' => [
                    'label' => esc_html__( 'Layout Two', 'blogmatic' ),
                    'url'   => $theme_directory . '/assets/images/customizer/builder_eighteen.png',
                    'devices'	=>	[ 'smartphone', 'tablet' ],
                    'columns'	=>	[ 4 ]
                ]
            ];
            $control_array = [
                /* Header layout row controls */
                'header_first_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'choices'  => $column_layouts
                ],
                'header_second_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'row'   =>  2,
                    'choices'  => $column_layouts
                ],
                'header_third_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'row'   =>  3,
                    'choices'  => $column_layouts
                ],
                /* Footer layout row controls */
                'footer_first_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
                'footer_second_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'row'   =>  2,
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
                'footer_third_row_column_layout'    =>  [
                    'label' =>  esc_html__( 'Column layout', 'blogmatic' ),
                    'row'   =>  3,
                    'builder'   =>  'footer',
                    'choices'  => $footer_column_layouts
                ],
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }   // End of get_responsive_radio_image() Method

        /**
         * Gets all textarea controls
         * 
         * @since 1.0.0
         */
        public function get_textareas( $id = '' ){
            $default = [];
            $control_array = [
                'bottom_footer_site_info' =>  [
                    'label' => esc_html__( 'Copyright Text', 'blogmatic' ),
                    'description' => esc_html__( 'Add %year% to retrieve current year.', 'blogmatic' ),
                    'transport' =>  'refresh',
                    'type'  =>  'textarea'
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Gets all responsive radio tab controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_radio_tab( $id = '' ){
            $default = [
                'choices' => [
                    [
                        'value' => 'left',
                        'icon'  =>  'editor-alignleft',
                        'label' =>  esc_html__( 'Left', 'blogmatic' )
                    ],
                    [
                        'value' => 'center',
                        'icon'  =>  'editor-aligncenter',
                        'label' =>  esc_html__( 'Center', 'blogmatic' )
                    ],
                    [
                        'value' => 'right',
                        'icon'  =>  'editor-alignright',
                        'label' =>  esc_html__( 'Right', 'blogmatic' )
                    ]
                ]
            ];
            $control_array = [
                /* Header builder first row */
                'header_first_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_first_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_first_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_first_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Header builder second row */
                'header_second_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_second_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_second_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_second_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Header builder third row */
                'header_third_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'header_third_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'header_third_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'header_third_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                /* Footer builder first row */
                'footer_first_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_first_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_first_row_column' )->value(), [ 4 ] ) );
                    },
                ]),
                /* Footer builder second row */
                'footer_second_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_second_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_second_row_column' )->value(), [ 4 ] ) );
                    },
                ]),
                /* Footer builder third row */
                'footer_third_row_column_one'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 1 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 1, 2, 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_two'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 2 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 2, 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_three'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 3 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 3, 4 ] ) );
                    },
                ]),
                'footer_third_row_column_four'  =>  $this->get_params( $default, [
                    'label' =>  esc_html__( 'Column 4 Alignment', 'blogmatic' ),
                    'tab'   =>  'column',
                    'active_callback'   =>  function( $control ) {
                        return ( in_array( $control->manager->get_setting( 'footer_third_row_column' )->value(), [ 4 ] ) );
                    },
                ]),
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all typography preset controls
         * 
         * @since 1.0.0
         */
        public function get_typography_preset_controls( $id = '' ) {

            $control_array = [
                'typography_presets' =>   [
                    'label' =>  esc_html__( 'Typography Preset', 'blogmatic' ),
                    'description'   =>  esc_html__( 'This is the control to use in future projects.', 'blogmatic' ),
                ]
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all preset color controls
         * 
         * @since 1.0.0
         */
        public function get_theme_colors( $id = '' ) {
            $default = [
                'transport' =>  'postMessage'
            ];

            $control_array = [
                // preset colors
                'theme_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Theme Color', 'blogmatic' ),
                    'variable'   => '--blogmatic-global-preset-theme-color'
                ]),
                'gradient_theme_color' => $this->get_params( $default, [
                    'label' => esc_html__( 'Gradient Theme Color', 'blogmatic' ),
                    'variable'   => '--blogmatic-global-preset-gradient-theme-color',
                    'involve'   =>  'gradient'
                ])
            ];
            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all divider controls
         * 
         * @since 1.0.0
         */
        public function get_divider_controls( $design_tab = false ) {
            return $design_tab ? [ 'tab' => 'design' ] : [];
        }

        /**
         * Returns all builder controls
         * 
         * @since 1.0.0
         */
        public function get_builder_controls( $id = '' ) {

            $default = [
                'transport' =>  'refresh'
            ];

            $control_array = [
                'header_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'header_builder_section_settings',
                    'responsive_builder'	=>	'responsive_header_builder',
                    'widgets'	=>	[
                        'site-logo'	=>	[
                            'label' 	=>	esc_html__( 'Site Logo and Title', 'blogmatic' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'title_tagline'
                        ],
                        'date-time'	=>	[
                            'label' 	=>	esc_html__( 'Date Time', 'blogmatic' ),
                            'icon' 	=>	'clock',
                            'section'	=>	'date_time_section'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blogmatic' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'social_icons_section'
                        ],
                        'search'	=>	[
                            'label' 	=>	esc_html__( 'Search', 'blogmatic' ),
                            'icon' 	=>	'search',
                            'section'	=>	'header_live_search_section'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Primary Menu', 'blogmatic' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'header_menu_options_section'
                        ],
                        'button'	=>	[
                            'label' 	=>	esc_html__( 'Button', 'blogmatic' ),
                            'icon' 	=>	'button',
                            'section'	=>	'custom_button_section'
                        ],
                        'theme-mode'	=>	[
                            'label' 	=>	esc_html__( 'Theme Mode', 'blogmatic' ),
                            'icon' 	=>	'lightbulb',
                            'section'	=>	'theme_mode_section'
                        ],
                        'off-canvas'	=>	[
                            'label' 	=>	esc_html__( 'Off Canvas', 'blogmatic' ),
                            'icon' 	=>	'text-page',
                            'section'	=>	'canvas_menu_section'
                        ]
                    ]
                ]),
                'footer_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'footer_builder_section_settings',
                    'placement'	=>	'footer',
                    'widgets'	=>	[
                        'logo'	=>	[
                            'label' 	=>	esc_html__( 'Logo', 'blogmatic' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'footer_logo'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blogmatic' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'footer_social_icons_section'
                        ],
                        'copyright'	=>	[
                            'label' 	=>	esc_html__( 'Copyright', 'blogmatic' ),
                            'icon' 	=>	'privacy',
                            'section'	=>	'footer_copyright'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Secondary Menu', 'blogmatic' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'footer_menu_options_section'
                        ],
                        'sidebar-one'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 1', 'blogmatic' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-one'
                        ],
                        'sidebar-two'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 2', 'blogmatic' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-two'
                        ],
                        'sidebar-three'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 3', 'blogmatic' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-three'
                        ],
                        'sidebar-four'	=>	[
                            'label' 	=>	esc_html__( 'Sidebar 4', 'blogmatic' ),
                            'icon' 	=>	'columns',
                            'section'	=>	'sidebar-widgets-footer-sidebar-column-four'
                        ],
                        'you-may-have-missed'	=>	[
                            'label' 	=>	esc_html__( 'You may have missed', 'blogmatic' ),
                            'icon' 	=>	'star-filled',
                            'section'	=>	'you_may_have_missed_section'
                        ],
                        'scroll-to-top'	=>	[
                            'label' 	=>	esc_html__( 'Scroll to Top', 'blogmatic' ),
                            'icon' 	=>	'arrow-up-alt2',
                            'section'	=>	'stt_options_section'
                        ],
                    ]
                ])
            ];

            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Returns all responsive builder controls
         * 
         * @since 1.0.0
         */
        public function get_responsive_builder_controls( $id = '' ) {

            $default = [
                'transport' =>  'refresh'
            ];

            $control_array = [
                'responsive_header_builder' => $this->get_params( $default, [
                    'builder_settings_section'	=>	'header_builder_section_settings',
                    'placement'	=>	'header',
                    'responsive_canvas_id'	=>	'responsive-canvas',
                    'responsive_section'	=>	'mobile_canvas_section',
                    'widgets'	=>	[
                        'site-logo'	=>	[
                            'label' 	=>	esc_html__( 'Site Logo and Title', 'blogmatic' ),
                            'icon' 	=>	'admin-site',
                            'section'	=>	'title_tagline'
                        ],
                        'date-time'	=>	[
                            'label' 	=>	esc_html__( 'Date Time', 'blogmatic' ),
                            'icon' 	=>	'clock',
                            'section'	=>	'date_time_section'
                        ],
                        'social-icons'	=>	[
                            'label' 	=>	esc_html__( 'Social Icons', 'blogmatic' ),
                            'icon' 	=>	'networking',
                            'section'	=>	'social_icons_section'
                        ],
                        'search'	=>	[
                            'label' 	=>	esc_html__( 'Search', 'blogmatic' ),
                            'icon' 	=>	'search',
                            'section'	=>	'header_live_search_section'
                        ],
                        'menu'	=>	[
                            'label' 	=>	esc_html__( 'Primary Menu', 'blogmatic' ),
                            'icon' 	=>	'menu',
                            'section'	=>	'header_menu_options_section'
                        ],
                        'button'	=>	[
                            'label' 	=>	esc_html__( 'Button', 'blogmatic' ),
                            'icon' 	=>	'button',
                            'section'	=>	'custom_button_section'
                        ],
                        'theme-mode'	=>	[
                            'label' 	=>	esc_html__( 'Theme Mode', 'blogmatic' ),
                            'icon' 	=>	'lightbulb',
                            'section'	=>	'theme_mode_section'
                        ],
                        'off-canvas'	=>	[
                            'label' 	=>	esc_html__( 'Off Canvas', 'blogmatic' ),
                            'icon' 	=>	'text-page',
                            'section'	=>	'canvas_menu_section'
                        ],
                        'toggle-button'	=>	[
                            'label' 	=>	esc_html__( 'Toggle Button', 'blogmatic' ),
                            'icon' 	=>	'ellipsis',
                            'section'	=>	'mobile_canvas_section'
                        ]
                    ]
                ])
            ];

            return ( $id ? $control_array[ $id ] : $control_array );
        }

        /**
         * Get controls parameters necessary in add_control function
         * 
         * @since 1.0.0
         */
        public function get_params( $default = [], $append = [] ) {
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
            return $default;
        }

        /**
         * Get input_attrs array
         * 
         * @since 1.0.0
         */
        public function get_input_attrs( $append = [] ) {
            $default = [
                'max'   =>  100,
                'min'   =>  0,
                'step'   =>  1,
                'reset'   =>  true
            ];
            if( ! empty( $append ) && is_array( $append ) ) return $append += $default;
            return $default;
        }
    }
 endif;