/* global wp, jQuery */
/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *  
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	const themeCalls = {
		blogmaticGenerateTypoCss: function( selector, value ) {
			const { preset, font_family, font_weight, text_transform, text_decoration, font_size, line_height, letter_spacing } = value
			var cssCode = ''
			cssCode += '.blogmatic_font_typography { \n'
			if( font_family ) cssCode += selector + '-family: ' + this.blogmaticGetTypographyFormat( preset, font_family.value, '-family' ) + ';\n'

			if( font_weight ) cssCode += selector + '-weight: ' + this.blogmaticGetTypographyFormat( preset, font_weight.value, '-weight' ) + '; \n' + selector + '-style: ' + this.blogmaticGetTypographyFormat( preset, font_weight.variant, '-style' ) + ';\n'
			
			if( text_transform ) cssCode += selector + '-texttransform: ' + this.blogmaticGetTypographyFormat( preset, text_transform, '-texttransform' ) + ';\n'

			if( text_decoration ) cssCode += selector + '-textdecoration: ' + this.blogmaticGetTypographyFormat( preset, text_decoration, '-textdecoration' ) + ';\n'

			if( font_size ) {
				if( font_size.desktop ) cssCode += selector + '-size: ' + this.blogmaticGetTypographyFormat( preset, font_size.desktop, '-size' ) + ';\n'
				if( font_size.tablet ) cssCode += selector + '-size-tab: ' + this.blogmaticGetTypographyFormat( preset, font_size.tablet, '-size-tab' ) + ';\n'
				if( font_size.smartphone ) cssCode += selector + '-size-mobile: ' + this.blogmaticGetTypographyFormat( preset, font_size.smartphone, '-size-mobile' ) + ';\n'
			}
			if( line_height ) {
				if( line_height.desktop ) cssCode += selector + '-lineheight: ' + this.blogmaticGetTypographyFormat( preset, line_height.desktop, '-lineheight' ) + ';\n'
				if( line_height.tablet ) cssCode += selector + '-lineheight-tab: ' + this.blogmaticGetTypographyFormat( preset, line_height.tablet, '-lineheight-tab' ) + ';\n'
				if( line_height.smartphone ) cssCode += selector + '-lineheight-mobile: ' + this.blogmaticGetTypographyFormat( preset, line_height.smartphone, '-lineheight-mobile' ) + ';\n'
			}
			if( letter_spacing ) {
				if( letter_spacing.desktop ) cssCode += selector + '-letterspacing: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.desktop, '-letterspacing' ) + ';\n'
				if( letter_spacing.tablet ) cssCode += selector + '-letterspacing-tab: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.tablet, '-letterspacing-tab' ) + ';\n'
				if( letter_spacing.smartphone ) cssCode += selector + '-letterspacing-mobile: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.smartphone, '-letterspacing-mobile' ) + ';\n'
			}
			cssCode += '}'
			return cssCode
		},
		blogmaticGenerateTypoCssWithSelector: function( selector, value ) {
			const { preset, font_family, font_weight, text_transform, text_decoration, font_size, line_height, letter_spacing } = value
			var cssCode = ''
			if( font_family ) cssCode += selector + ' { font-family: ' + this.blogmaticGetTypographyFormat( preset, font_family.value, '-family' ) + '; } \n'

			if( font_weight ) cssCode += selector + ' { font-weight: ' + this.blogmaticGetTypographyFormat( preset, font_weight.value, '-weight' ) + ';\n  font-style: ' + this.blogmaticGetTypographyFormat( preset, font_weight.variant, '-style' ) + '; } \n'

			if( text_transform ) cssCode += selector + ' { text-transform: ' + this.blogmaticGetTypographyFormat( preset, text_transform, '-texttransform' ) + '; } \n'
			
			if( text_decoration ) cssCode += selector + ' { text-decoration: ' + this.blogmaticGetTypographyFormat( preset, text_decoration, '-textdecoration' ) + '; } \n'

			if( font_size ) {
				if( font_size.desktop ) cssCode += selector + ' { font-size: ' + this.blogmaticGetTypographyFormat( preset, font_size.desktop, '-size' ) + '; } \n'
				if( font_size.tablet ) cssCode += '@media(max-width: 940px) { ' + selector + ' { font-size: ' + this.blogmaticGetTypographyFormat( preset, font_size.tablet, '-size-tab' ) + '; } } \n'
				if( font_size.smartphone ) cssCode += '@media(max-width: 610px) { ' + selector + ' { font-size: ' + this.blogmaticGetTypographyFormat( preset, font_size.smartphone, '-size-mobile' ) + '; } } \n'
			}
			if( line_height ) {
				if( line_height.desktop ) cssCode += selector + ' { line-height: ' + this.blogmaticGetTypographyFormat( preset, line_height.desktop, '-lineheight' ) + '; } \n'
				if( line_height.tablet ) cssCode += '@media(max-width: 940px) { ' + selector + ' { line-height: ' + this.blogmaticGetTypographyFormat( preset, line_height.tablet, '-lineheight-tab' ) + '; } } \n'
				if( line_height.smartphone ) cssCode += '@media(max-width: 610px) { ' + selector + ' { line-height: ' + this.blogmaticGetTypographyFormat( preset, line_height.smartphone, '-lineheight-mobile' ) + '; } } \n'
			}
			if( letter_spacing ) {
				if( letter_spacing.desktop ) cssCode += selector + ' { letter-spacing: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.desktop, '-letterspacing' ) + '; } \n'
				if( letter_spacing.tablet ) cssCode += '@media(max-width: 940px) { ' + selector + ' { letter-spacing: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.tablet, '-letterspacing-tab' ) + '; } } \n'
				if( letter_spacing.smartphone ) cssCode += '@media(max-width: 610px) { ' + selector + ' { letter-spacing: ' + this.blogmaticGetTypographyFormat( preset, letter_spacing.smartphone, '-letterspacing-mobile' ) + '; } } \n'
			}
			return cssCode
		},
		blogmaticGenerateStyleTag: function( code, id ) {
			if( code ) {
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id ).html( code )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + code + '</style>' )
				}
			} else {
				$( "head #" + id ).remove()
			}
		},
		blogmaticGetTypographyFormat: function( preset, value, suffix ) {
			if( preset === '-1' ) {
				let unitsArray = [ '-size', '-size-tab', '-size-mobile', '-lineheight', '-lineheight-tab', '-lineheight-mobile', '-letterspacing', '-letterspacing-tab', '-letterspacing-mobile' ]
				return ( unitsArray.includes( suffix ) ) ? value + 'px' : value;
			} else {
				let variable = 'var(--blogmatic-global-preset-typography-' + ( parseInt( preset ) + 1 ) + '-font' + suffix + ')';
				return variable
			}
		}
	}

	// typography preset
	wp.customize( 'typography_presets', function( value ) {
		value.bind( function(to) {
			const { typographies, labels } = to
			typographies.forEach(( typography, index ) => {
				ajaxFunctions.typoFontsEnqueue( typography )
				let variable = '--blogmatic-global-preset-typography-';
               	let count = index + 1;
               	variable += count + '-font';
				cssCode = themeCalls.blogmaticGenerateTypoCss( variable, typography )
				themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-typography-preset-' + count )
			})
		});
	});

	// background color
	wp.customize( 'background_image', function( value ) {
		value.bind( function(to) {
			if( to ) {
				$( 'body' ).addClass( 'has-background-image' )
			} else {
				$( 'body' ).removeClass( 'has-background-image' )
			}
		});
	});

	// theme color bind changes
	wp.customize( 'theme_color', function( value ) {
		value.bind( function( to ) {
			helperFunctions.generateStyle(to, 'theme-color-style', '--blogmatic-global-preset-theme-color')
		});
	});

	// gradient theme color bind changes
	wp.customize( 'gradient_theme_color', function( value ) {
		value.bind( function( to ) {
			helperFunctions.generateStyle(to, 'theme-preset-gradient-color-1-style', '--blogmatic-global-preset-gradient-theme-color')
		});
	});

	// solid color presets
	wp.customize( 'solid_color_preset', function( value ) {
		value.bind( function( to ) {
			const { active_palette: activePaletteIndex, color_palettes: colorPalettes } = to
			const ACTIVEPALETTE = colorPalettes[ activePaletteIndex ]
			helperFunctions.bulkGenerateStyle( ACTIVEPALETTE, 'blogmatic-solid-presets', '--blogmatic-global-preset-color-' )
		});
	});

	// gradient color presets
	wp.customize( 'gradient_color_preset', function( value ) {
		value.bind( function( to ) {
			const { active_palette: activePaletteIndex, color_palettes: colorPalettes } = to
			const ACTIVEPALETTE = colorPalettes[ activePaletteIndex ]
			helperFunctions.bulkGenerateStyle( ACTIVEPALETTE, 'blogmatic-gradient-presets', '--blogmatic-global-preset-gradient-' )
		});
	});

	// single post related articles title option
	wp.customize( 'single_post_related_posts_title', function( value ) {
		value.bind( function(to) {
			if( $( ".single-related-posts-section-wrap" ).find('.blogmatic-block-title span').length > 0 ) {
				$( ".single-related-posts-section-wrap" ).find('.blogmatic-block-title span').text( to )
			} else {
				$( ".single-related-posts-section-wrap .single-related-posts-section" ).prepend('<h2 class="blogmatic-block-title"><span>'+ to +'</span></h2>')
			}
		});
	});

	// blog description
	wp.customize( 'blogdescription_option', function( value ) {
		value.bind(function(to) {
			if( to ) {
				$( '.site-description' ).css( {
					clip: 'auto',
					position: 'relative',
				} );
			} else {
				$( '.site-description' ).css( {
					clip: 'rect(1px, 1px, 1px, 1px)',
					position: 'absolute',
				} );
			}
		})
	});

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			var cssCode = '.blogmatic-light-mode .site-header .site-title a { color: '+ to +' }'
			themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-site-title' )
		} );
	});

	// site title hover color
	wp.customize( 'site_title_hover_textcolor', function( value ) {
		value.bind( function( to ) {
			var cssCode = '.blogmatic-light-mode .site-header .site-title a:hover { color: '+ to +' }'
			themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-site-title-hover' )
		} );
	});

	// site description color
	wp.customize( 'site_description_color', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).css( {
				color: to,
			});
		} );
	});

	// single post related articles title option
	wp.customize( 'stt_text', function( value ) {
		value.bind( function(to) {
			if( $( ".blogmatic-scroll-btn" ).find('.icon-text').length > 0 ) {
				$( ".blogmatic-scroll-btn" ).find('.icon-text').text( to )
			} else {
				$( ".blogmatic-scroll-btn .scroll-top-wrap" ).prepend('<span class="icon-text">'+ to +'</span>')
			}
		});
	});

	var parsedCats = blogmaticPreviewObject.totalCats
	if( parsedCats ) {
		parsedCats = Object.keys( parsedCats ).map(( key ) => { return parsedCats[key] })
		parsedCats.forEach(function(item) {
			wp.customize( 'category_' + item.term_id + '_color', function( value ) {
				value.bind( function(to) {
					var cssCode = ''
					const { initial, hover } = to
					if( initial ) {
						cssCode += "body .post-categories .cat-item.cat-" + item.term_id + " a, body.archive.category.category-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i { color : " + blogmatic_get_color_format( initial[ initial.type ] ) + " } "
					}
					if( hover ) {
						cssCode += "body .post-categories .cat-item.cat-" + item.term_id + " a:hover, body.archive.category.category-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i:hover { color : " + blogmatic_get_color_format( hover[ hover.type ] ) + " } "
					}
					themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-category-' + item.term_id + '-style' )
				})
			})
			wp.customize( 'category_background_' + item.term_id + '_color', function( value ) {
				value.bind( function(to) {
					var cssCode = ''
					const { initial, hover } = to
					if( initial ) {
						cssCode += "body .post-categories .cat-item.cat-" + item.term_id + " a, body.archive.category.category-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i { background : " + blogmatic_get_color_format( initial[ hover.type ] ) + " } "
					}
					if( hover ) {
						cssCode += "body .post-categories .cat-item.cat-" + item.term_id + " a:hover, body.archive.category.category-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i:hover { background : " + blogmatic_get_color_format( hover[ hover.type ] ) + " } "
					}
					themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-category-background-' + item.term_id + '-style' )
				})
			})
		})
	}
	
	var parsedTags = blogmaticPreviewObject.totalTags
	if( parsedTags ) {
		parsedTags = Object.keys( parsedTags ).map(( key ) => { return parsedTags[key] })
		parsedTags.forEach(function(item) {
			wp.customize( 'tag_' + item.term_id + '_color', function( value ) {
				value.bind( function(to) {
					var cssCode = ''
					const { initial, hover } = to
					if( initial ) {
						cssCode += "body .tags-wrap .tags-item.tag-" + item.term_id + " span, body.archive.tag.tag-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i { color : " + blogmatic_get_color_format( initial[ hover.type ] ) + " } "
					}
					if( hover ) {
						cssCode += "body .tags-wrap .tags-item.tag-" + item.term_id + ":hover span, body.archive.tag.tag-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i:hover { color : " + blogmatic_get_color_format( hover[ hover.type ] ) + " } "
					}
					themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-tag-' + item.term_id + '-style' )
				})
			})
			wp.customize( 'tag_background_' + item.term_id + '_color', function( value ) {
				value.bind( function(to) {
					var cssCode = ''
					const { initial, hover } = to
					if( initial ) {
						cssCode += "body .tags-wrap .tags-item.tag-" + item.term_id + ", body.archive.tag.tag-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i { background : " + blogmatic_get_color_format( initial[ initial.type ] ) + " } "
					}
					if( hover ) {
						cssCode += "body .tags-wrap .tags-item.tag-" + item.term_id + ":hover, body.archive.tag.tag-" + item.term_id + " #blogmatic-main-wrap .page-header .blogmatic-container i:hover { background : " + blogmatic_get_color_format( hover[ hover.type ] ) + " } "
					}
					themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-tag-background-' + item.term_id + '-style' )
				})
			})
		})
	}

	// custom button label
	wp.customize( 'custom_button_label', function( value ) {
		value.bind( function( to ) {
			if( $( "#masthead .header-custom-button-wrapper" ).find('.custom-button-label').length > 0 ) {
				$( "#masthead .header-custom-button-wrapper" ).find('.custom-button-label').text( to )
			} else {
				$( "#masthead .header-custom-button-wrapper .header-custom-button" ).append('<span class="custom-button-label">'+ to +'</span>')
			}
		})
	})

	// category collection number of columns
	wp.customize( 'category_collection_number_of_columns', function( value ) {
		value.bind( function( to ) {
			if( to.desktop ) {
				$("#blogmatic-category-collection-section").removeClass( "column--one column--two column--three column--four column--five" )
				$("#blogmatic-category-collection-section").addClass( "column--" + blogmatic_get_numeric_string( to.desktop ) )
			}
			if( to.tablet ) {
				$("#blogmatic-category-collection-section").removeClass( "tab-column--one tab-column--two tab-column--three tab-column--four tab-column--five" )
				$("#blogmatic-category-collection-section").addClass( "tab-column--" + blogmatic_get_numeric_string( to.tablet ) )
			}
			if( to.smartphone ) {
				$("#blogmatic-category-collection-section").removeClass( "mobile-column--one mobile-column--two mobile-column--three mobile-column--four mobile-column--five" )
				$("#blogmatic-category-collection-section").addClass( "mobile-column--" + blogmatic_get_numeric_string( to.smartphone ) )
			}
		})
	})

	// cursor animation
	wp.customize( 'cursor_animation', function( value ) {
		value.bind( function(to) {
			if( to != 'none' ) {
				$('body .blogmatic-cursor').removeClass( 'type--two' ).addClass( 'type--' + to )
			} else {
				$('body .blogmatic-cursor').removeClass( 'type--two' )
			}
		});
	});

	// you may have missed no of columns
	wp.customize( 'you_may_have_missed_no_of_columns', function( value ) {
		value.bind( function(to) {
			$('#blogmatic-you-may-have-missed-section').removeClass( 'no-of-columns--two no-of-columns--three no-of-columns--four' ).addClass( 'no-of-columns--' + blogmatic_get_numeric_string( parseInt(to) ) )
		});
	});

	// you may have missed section title option
	wp.customize( 'you_may_have_missed_title_option', function( value ) {
		value.bind( function(to) {
			if( to ){
				$('#blogmatic-you-may-have-missed-section .section-title').show()
			} else {
				$('#blogmatic-you-may-have-missed-section .section-title').hide()
			}
		});
	});

	// canvas menu position
	wp.customize( 'canvas_menu_position', function( value ) {
		value.bind( function( to ) {
			if( to == 'right' ) {
				$('body').removeClass('blogmatic-canvas-position--left').addClass('blogmatic-canvas-position--right')
			} else {
				$('body').removeClass('blogmatic-canvas-position--right').addClass('blogmatic-canvas-position--left')
			}
		})
	})

	// post format
	var postFormatIds = { 
		'standard': 'standard_post_format_icon_picker',
		'audio': 'audio_post_format_icon_picker',
		'gallery': 'gallery_post_format_icon_picker',
		'image': 'image_post_format_icon_picker',
		'quote': 'quote_post_format_icon_picker',
		'video': 'video_post_format_icon_picker' 
	}
	Object.entries( postFormatIds ).map(( [ currentKey, currentValue ] ) => {
		wp.customize( currentValue, function( value ) {
			value.bind( function(to) {
				if( to.type == 'none' ) {
					$( 'article.format-'+ currentKey +' .post-format-ss-wrap .post-format-icon' ).hide()
				} else {
					$( 'article.format-'+ currentKey +' .post-format-ss-wrap .post-format-icon' ).show()
				}
			});
		});
	})

	// check if string is variable and formats 
	function blogmatic_get_color_format( color ) {
		if( color === null ) return color
		if( color.includes('--blogmatic-global-preset-') ) {
			return ( 'var('+ color +')' )
		} else {
			return color
		}
	}

	function blogmatic_get_background_style( control ) {
	   	if( control ) {
			var cssCode = '', mediaUrl = '', repeat = '', position = '', attachment = '', size = ''
			switch( control.type ) {
			case 'image' : 
			 		if( 'id' in control.image ) mediaUrl = 'background-image: url(' + control.image.url + ');'
					if( 'repeat' in control ) repeat = " background-repeat: "+ control.repeat + ';'
					if( 'position' in control ) position = " background-position: "+ control.position + ';'
					if( 'attachment' in control ) attachment = " background-attachment: "+ control.attachment + ';'
					if( 'size' in control ) size = " background-size: "+ control.size + ';'
					return cssCode.concat( mediaUrl, repeat, position, attachment, size )
				break;
			default: 
			if( 'type' in control ) return "background: " + blogmatic_get_color_format( control[control.type] )
		  }
		}
	}

	// converts integer to string for attibutes value 
	function blogmatic_get_numeric_string(int) {
		switch( int ) {
			case 2:
				return "two";
				break;
			case 3:
				return "three";
				break;
			case 4:
				return "four";
				break;
			case 5:
				return "five";
				break;
			case 6:
				return "six";
				break;
			case 7:
				return "seven";
				break;
			case 8:
				return "eight";
				break;
			case 9:
				return "nine";
				break;
			case 10:
				return "ten";
				break;
			default:
				return "one";
		}
	}

	// constants
	const ajaxFunctions = {
		typoFontsEnqueue: function( typography ) {
			const { font_family, font_weight } = typography
			let linkTag = document.getElementById('blogmatic-generated-typo-fonts')
			let googleFontsUrl = 'https://fonts.googleapis.com/css2?'
			let googleFontsUrlQuery
			let fontStyle = ( font_weight.variant === 'italic' ) ? 'ital,wght@' : 'wght@'
			if( linkTag !== null ) {
				let parser = new URL( linkTag.href )
				let query = parser.search
				let toAppend = parseTheFontsQuery( query, typography )
				linkTag.href = googleFontsUrl + toAppend
			} else {
				let newLinkTag = document.createElement('link')
				newLinkTag.rel = 'stylesheet'
				newLinkTag.id = 'blogmatic-generated-typo-fonts'
				googleFontsUrlQuery = 'family=' + font_family.value + ':' + fontStyle + font_weight.value
				newLinkTag.href = googleFontsUrl + googleFontsUrlQuery
				document.head.appendChild( newLinkTag );
			}
		}
	}

	/**
     * Append new font family 
     * 
     * @since 1.0.0
     */
    const parseTheFontsQuery = ( query, typography ) => {
        const { font_weight:WEIGHT, font_family:FAMILY } = typography
        let toParse = query
        let removeQuestionMark = toParse.replaceAll( '?', '' )
        let filteredQuery = removeQuestionMark.replaceAll( '&', '' )
        let fontFamilyQuery = filteredQuery.split( 'family=' )
        let fontStyleProperty = WEIGHT.variant === 'italic' ? 'ital' : 'wght'
        var fontFamily = [ FAMILY.value ], fontWeight = { [FAMILY.value]: [ WEIGHT.value ] }, fontStyle = { [FAMILY.value]: [ fontStyleProperty ]}
		let filteredFamily = fontFamily.map(( current ) => {
			return current.replaceAll( '%20', ' ' )
		})
        fontFamilyQuery.forEach(( current ) => {
            if( current !== '' ) {
                let splitFamily = current.split( ':' )
                let family = splitFamily[0]
                if ( ! filteredFamily.includes( family ) ) filteredFamily.push( family );
                let splitWeightAndStyle = splitFamily[1].split('@')
                let weight = splitWeightAndStyle[1].replaceAll( '0,', '' ).replaceAll( '1,', '' ).replaceAll( ',', '' )
                let style = splitWeightAndStyle[0]
                if ( ! fontWeight[family] ) fontWeight[family] = []
                if ( ! fontStyle[family] ) fontStyle[family] = []
                if ( ! fontStyle[family].includes( style ) ) fontStyle[family].push( ...style.split(',') );
				
                if ( ! fontWeight[family].includes( weight ) ) fontWeight[family].push( ...weight.split(';') );
            }
        })
        let toAppend = filteredFamily.map(( family ) => {
			let sortedWeights = fontWeight[family].sort(( first, second ) => { return first - second })
			let duplicateRemovedWeights =  [ ...new Set( sortedWeights ) ]	//weights
			let duplicateRemovedStyles =  [ ...new Set( fontStyle[family] ) ]	// styles
			var structuredFontStyles, temporaryStyles = []
			if( duplicateRemovedStyles.includes( 'ital' ) ) {
				duplicateRemovedWeights.forEach(( current ) => { 
					if( current !== undefined && current !== '' ) temporaryStyles.push( '0,' + current + ';' )
				})
				duplicateRemovedWeights.forEach(( current, index ) => { 
					if( current !== undefined && current !== '' ) temporaryStyles.push( '1,' + current + ( index + 1 === duplicateRemovedWeights.length ? '' : ';' ) )
				})
				structuredFontStyles = temporaryStyles.join('')
			} else {
				structuredFontStyles = duplicateRemovedWeights.join(';')
			}
            return 'family=' + family + ':' + duplicateRemovedStyles.sort() + '@' + structuredFontStyles
        }).join('&')
        return toAppend;
    }

	// constants
	const helperFunctions = {
		generateStyle: function(color, id, variable) {
			if(color) {
				if( id === 'theme-color-style' ) {
					var styleText = 'body { ' + variable + ': ' + color + '}';
				} else {
					var styleText = 'body { ' + variable + ': ' + blogmatic_get_color_format( color ) + '}';
				}
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id).text( styleText )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + styleText + '</style>' )
				}
			}
		},
		bulkGenerateStyle: function( colors, id, variablePrefix ) {
			if( colors.length > 0 ) {
				let styleText = 'body {'
				colors.forEach(( color, index ) => {
					let count = index + 1
					styleText += variablePrefix + count + ': ' + color + ';'
				})
				styleText += '}'
				
				if( $( "head #" + id ).length > 0 ) {
					$( "head #" + id).text( styleText )
				} else {
					$( "head" ).append( '<style id="' + id + '">' + styleText + '</style>' )
				}
			}
		}
	}

	class BlogmaticCustomize {

		/**
		 * Method that gets called when class is instantiated
		 * 
		 * @since 1.0.0
		 */
		constructor() {
			this.preview();
		}

		/**
		 * Set suffix in given id
		 * 
		 * @since 1.0.0
		 */
		setSuffix = ( id, suffix, property = '' ) => {
			if( property != '' ) {
				return id + '-' + suffix + '+' + property
			} else {
				return id + '-' + suffix
			}
		}

		/**
		 * checks if the given string is class or css variable
		 * 
		 * @since 1.0.0
		 */
		isVariale = ( selector ) => {
			let mainSelector = selector
			if( typeof selector == 'object' ) {
				mainSelector = selector['selector']
			}
			if( mainSelector.length < 12 ) return false;
			let prefix = mainSelector.slice( 0, 11 )
			if( prefix == '--blogmatic' ) {
				return true;
			} else {
				return false;
			}
		}

		/**
		 * Returns list of all typography controls id and selectors 
		 * 
		 * @since 1.0.0
		 */	
		_getTypography = () => {
			let suffix = 'typography'

			return {
				// variable
				[ this.setSuffix( 'global_button_typo' , suffix) ] : '--blogmatic-readmore-font',
				[ this.setSuffix( 'site_title_typo' , suffix) ] : '--blogmatic-site-title',
				[ this.setSuffix( 'site_description_typo' , suffix) ] : '--blogmatic-site-description',
				[ this.setSuffix( 'custom_button_text_typography' , suffix) ] : '--blogmatic-custom-button',
				[ this.setSuffix( 'main_menu_typo' , suffix) ] : '--blogmatic-menu',
				[ this.setSuffix( 'footer_menu_typography' , suffix) ] : '--blogmatic-footer-menu',
				[ this.setSuffix( 'date_time_typography' , suffix) ] : '--blogmatic-date-time',
				[ this.setSuffix( 'main_menu_sub_menu_typo' , suffix) ] : '--blogmatic-submenu',
				[ this.setSuffix( 'archive_title_typo' , suffix) ] : '--blogmatic-post-title-font',
				[ this.setSuffix( 'archive_excerpt_typo' , suffix) ] : '--blogmatic-post-content-font',
				[ this.setSuffix( 'archive_category_typo' , suffix) ] : '--blogmatic-category-font',
				[ this.setSuffix( 'archive_date_typo' , suffix) ] : '--blogmatic-date-font',
				[ this.setSuffix( 'archive_author_typo' , suffix) ] : '--blogmatic-author-font',
				[ this.setSuffix( 'archive_read_time_typo' , suffix) ] : '--blogmatic-readtime-font',
				[ this.setSuffix( 'archive_comment_typo' , suffix) ] : '--blogmatic-comment-font',
				[ this.setSuffix( 'category_collection_typo' , suffix) ] : '--blogmatic-category-collection-font',
				[ this.setSuffix( 'you_may_have_missed_design_section_title_typography' , suffix) ] : '--blogmatic-youmaymissed-block-title-font',
				[ this.setSuffix( 'you_may_have_missed_design_post_title_typography' , suffix) ] : '--blogmatic-youmaymissed-title-font',
				[ this.setSuffix( 'you_may_have_missed_design_post_categories_typography' , suffix) ] : '--blogmatic-youmaymissed-category-font',
				[ this.setSuffix( 'you_may_have_missed_design_post_date_typography' , suffix) ] : '--blogmatic-youmaymissed-date-font',
				[ this.setSuffix( 'you_may_have_missed_design_post_author_typography' , suffix) ] : '--blogmatic-youmaymissed-author-font',
				[ this.setSuffix( 'sidebar_block_title_typography' , suffix) ] : '--blogmatic-widget-block-font',
				[ this.setSuffix( 'sidebar_post_title_typography' , suffix) ] : '--blogmatic-widget-title-font',
				[ this.setSuffix( 'sidebar_category_typography' , suffix) ] : '--blogmatic-widget-category-font',
				[ this.setSuffix( 'sidebar_date_typography' , suffix) ] : '--blogmatic-widget-date-font',
				[ this.setSuffix( 'sidebar_date_typography' , suffix) ] : '--blogmatic-widget-date-font',
				[ this.setSuffix( 'main_banner_design_post_title_typography' , suffix) ] : '--blogmatic-banner-title-font',
				[ this.setSuffix( 'main_banner_design_post_excerpt_typography' , suffix) ] : '--blogmatic-banner-excerpt-font',
				// classes
				[ this.setSuffix( 'breadcrumb_typo', suffix ) ] : 'body .blogmatic-breadcrumb-wrap ul li span[itemprop="name"]',
				[ this.setSuffix( 'archive_category_info_box_title_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.category .page-header .page-title, .archive.date .page-header .page-title',
				[ this.setSuffix( 'archive_category_info_box_description_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.category .page-header .archive-description',
				[ this.setSuffix( 'archive_tag_info_box_title_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.tag .page-header .page-title',
				[ this.setSuffix( 'archive_tag_info_box_description_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.tag .page-header .archive-description',
				[ this.setSuffix( 'archive_author_info_box_title_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.author .page-header .page-title',
				[ this.setSuffix( 'archive_author_info_box_description_typo', suffix ) ] : 'body.blogmatic_font_typography.archive.author .page-header .archive-description',
				[ this.setSuffix( 'single_title_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography .site-main article .entry-title, body.single-post.blogmatic_font_typography .single-header-content-wrap .entry-title',
				[ this.setSuffix( 'single_content_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography .site-main article .entry-content',
				[ this.setSuffix( 'single_category_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography #primary article .post-categories .cat-item a, body.single-post.blogmatic_font_typography .single-header-content-wrap .post-categories .cat-item a',
				[ this.setSuffix( 'single_date_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography .post-meta-wrap .post-date, body.single-post.blogmatic_font_typography .single-header-content-wrap.post-meta .post-date',
				[ this.setSuffix( 'single_author_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography .site-main article .post-meta-wrap .byline, body.single-post.blogmatic_font_typography .single-header-content-wrap .post-meta-wrap .byline',
				[ this.setSuffix( 'single_read_time_typo', suffix ) ] : 'body.single-post.blogmatic_font_typography #primary .blogmatic-inner-content-wrap .post-meta  .post-read-time, body.single-post.blogmatic_font_typography .single-header-content-wrap .post-meta  .post-read-time, body.single-post.blogmatic_font_typography .single-header-content-wrap .post-meta  .post-comments-num',
				[ this.setSuffix( 'page_title_typo', suffix ) ] : 'body.page.blogmatic_font_typography #blogmatic-main-wrap #primary article .entry-title',
				[ this.setSuffix( 'page_content_typo', suffix ) ] : 'body.page.blogmatic_font_typography article .entry-content',
				[ this.setSuffix( 'main_banner_design_post_categories_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-main-banner-section .post-categories .cat-item a',
				[ this.setSuffix( 'main_banner_design_post_date_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-main-banner-section .main-banner-wrap .post-elements .post-date',
				[ this.setSuffix( 'main_banner_design_post_author_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-main-banner-section .main-banner-wrap .byline',
				[ this.setSuffix( 'carousel_design_post_title_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-carousel-section .carousel-wrap .post-elements .post-title',
				[ this.setSuffix( 'carousel_design_post_categories_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-carousel-section .post-categories .cat-item a',
				[ this.setSuffix( 'carousel_design_post_date_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-carousel-section .carousel-wrap .post-elements .post-date',
				[ this.setSuffix( 'carousel_design_post_author_typography', suffix ) ] : '.blogmatic_font_typography .blogmatic-carousel-section .carousel-wrap .post-elements .byline a',
				[ this.setSuffix( 'carousel_design_post_excerpt_typography', suffix ) ] : 'body.blogmatic_font_typography .blogmatic-carousel-section .carousel-wrap .post-elements .post-excerpt .excerpt-content',
				[ this.setSuffix( 'heading_one_typo', suffix ) ] : 'body article h1',
				[ this.setSuffix( 'heading_two_typo', suffix ) ] : 'body article h2',
				[ this.setSuffix( 'heading_three_typo', suffix ) ] : 'body article h3',
				[ this.setSuffix( 'heading_four_typo', suffix ) ] : 'body article h4',
				[ this.setSuffix( 'heading_five_typo', suffix ) ] : 'body article h5',
				[ this.setSuffix( 'heading_six_typo', suffix ) ] : 'body article h6',
				[ this.setSuffix( 'sidebar_heading_one_typography', suffix ) ] : 'body aside h1.wp-block-heading',
				[ this.setSuffix( 'sidebar_heading_two_typo', suffix ) ] : 'body aside h2.wp-block-heading',
				[ this.setSuffix( 'sidebar_heading_three_typo', suffix ) ] : 'body aside h3.wp-block-heading',
				[ this.setSuffix( 'sidebar_heading_four_typo', suffix ) ] : 'body aside h4.wp-block-heading',
				[ this.setSuffix( 'sidebar_heading_five_typo', suffix ) ] : 'body aside h5.wp-block-heading',
				[ this.setSuffix( 'sidebar_heading_six_typo', suffix ) ] : 'body aside h6.wp-block-heading',
				[ this.setSuffix( 'sidebar_pagination_button_typo', suffix ) ] : 'body .blogmatic-widget-loader .load-more',
				[ this.setSuffix( 'footer_title_typography', suffix ) ] : 'body footer .widget_block .wp-block-group__inner-container .wp-block-heading, body footer section.widget .widget-title, body footer .wp-block-heading',
				[ this.setSuffix( 'footer_text_typography', suffix ) ] : 'body footer ul.wp-block-latest-posts a, body footer ol.wp-block-latest-comments li footer, body footer ul.wp-block-archives a, body footer ul.wp-block-categories a, body footer ul.wp-block-page-list a, body footer .widget_blogmatic_post_grid_widget .post-grid-wrap .post-title, body footer .menu .menu-item a, body footer .widget_blogmatic_category_collection_widget .categories-wrap .category-item .category-name, body footer .widget_blogmatic_post_list_widget .post-list-wrap .post-title a',
				[ this.setSuffix( 'bottom_footer_text_typography', suffix ) ] : 'body footer .site-info',
				[ this.setSuffix( 'bottom_footer_link_typography', suffix ) ] : 'body footer .site-info a',
				[ this.setSuffix( 'site_background_color', suffix, property ) ]: 'body:before',
			}	
		};	// End of _getTypography method

		/**
		 * Returns a list of border control id and its releted selector
		 * 
		 * @since 1.0.0
		 */
		_getBorder = () => {
			let suffix = 'border'

			return {}
		}

		/**
		 * Returns a list of color control ids and its related selector
		 * 
		 * @since 1.0.0
		 */
		_getColor = () => {
			let suffix = 'color'
			let property = 'background'

			return {
				[ this.setSuffix( 'social_icon_color', suffix ) ]: '--blogmatic-header-social-color',
				[ this.setSuffix( 'footer_social_icon_color', suffix ) ]: '--blogmatic-footer-social-color',
				[ this.setSuffix( 'header_menu_color', suffix ) ]: '--blogmatic-menu-color',
				[ this.setSuffix( 'footer_menu_color', suffix ) ]: '--blogmatic-footer-menu-color',
				[ this.setSuffix( 'mobile_canvas_icon_color', suffix ) ]: '--blogmatic-mobile-canvas-icon-color',
				[ this.setSuffix( 'header_sub_menu_color', suffix ) ]: '--blogmatic-menu-color-submenu',
				[ this.setSuffix( 'search_icon_color', suffix ) ]: '--blogmatic-search-icon-color',
				[ this.setSuffix( 'theme_mode_dark_icon_color', suffix ) ]: '--blogmatic-theme-darkmode-color',
				[ this.setSuffix( 'theme_mode_light_icon_color', suffix ) ]: '--blogmatic-theme-mode-color',
				[ this.setSuffix( 'canvas_menu_icon_color', suffix ) ]: '--blogmatic-canvas-icon-color',
				[ this.setSuffix( 'header_custom_button_background_color_group', suffix ) ]: '--blogmatic-custom-button-bk-color',
				[ this.setSuffix( 'date_color', suffix ) ]: '--blogmatic-date-color',
				[ this.setSuffix( 'time_color', suffix ) ]: '--blogmatic-time-color',
				// all background
				[ this.setSuffix( 'header_builder_background', suffix, property ) ]: 'body.blogmatic-light-mode .site-header',
				/* Header Builder Row Backgrounds */
				[ this.setSuffix( 'header_first_row_background', suffix, property ) ]: 'body.blogmatic-light-mode .site-header .row-one',
				[ this.setSuffix( 'header_second_row_background', suffix, property ) ]: 'body.blogmatic-light-mode .site-header .row-two',
				[ this.setSuffix( 'header_third_row_background', suffix, property ) ]: 'body.blogmatic-light-mode .site-header .row-three',
			}
		}

		/**
		 * Returns all checkbox controls id and selectors
		 * 
		 * @since 1.0.0
		 */
		_getCheckbox = () => {
			let suffix = 'checkbox'
			let property = 'hide-on-mobile'

			return {
				// archive
				[ this.setSuffix( 'show_readmore_button_mobile_option', suffix, property ) ] : 'body.blog .blogmatic-article-inner .post-button, body.archive .blogmatic-article-inner .post-button, body.home .blogmatic-article-inner .post-button, body.search .blogmatic-article-inner .post-button',
				// global
				[ this.setSuffix( 'show_breadcrumb_on_mobile', suffix, property ) ] : 'body .blogmatic-breadcrumb-element',
				[ this.setSuffix( 'show_background_animation_on_mobile', suffix, property ) ] : 'body .blogmatic-background-animation',
				[ this.setSuffix( 'show_scroll_to_top_on_mobile', suffix, property ) ] : 'body #blogmatic-scroll-to-top',
				[ this.setSuffix( 'carousel_show_arrow_on_hover', suffix, 'arrow-on-hover--on' ) ]: '#blogmatic-carousel-section',
				[ this.setSuffix( 'main_banner_show_arrow_on_hover', suffix, 'arrow-on-hover--on' ) ]: '#blogmatic-main-banner-section',
				/* Header sticky */
				[ this.setSuffix( 'header_first_row_header_sticky', suffix, 'row-sticky' ) ]: 'body .site-header .row-one',
				[ this.setSuffix( 'header_second_row_header_sticky', suffix, 'row-sticky' ) ]: 'body .site-header .row-two',
				[ this.setSuffix( 'header_third_row_header_sticky', suffix, 'row-sticky' ) ]: 'body .site-header .row-three'
			}
		}

		/**
		 * Returns all spacing controls with its id and selector
		 * 
		 * @since 1.0.0
		 */
		_getSpacing = () => {
			let suffix = 'spacing'
			let property = 'padding'
   
			return {
				// border-radius
				[ this.setSuffix( 'carousel_image_border_radius', suffix, 'border-radius' ) ] : '.blogmatic-carousel-section article.post-item .post-thumb',
				[ this.setSuffix( 'you_may_have_missed_image_border_radius', suffix, 'border-radius' ) ] : '.blogmatic-you-may-have-missed-section .post-thumbnail-wrapper',
				/* Header Builder Row Spacings */
				[ this.setSuffix( 'header_first_row_padding', suffix, property ) ]: 'body .site-header .row-one',
				[ this.setSuffix( 'header_second_row_padding', suffix, property ) ]: 'body .site-header .row-two',
				[ this.setSuffix( 'header_third_row_padding', suffix, property ) ]: 'body .site-header .row-three',
				/* Footer Builder Row Spacings */
				[ this.setSuffix( 'footer_first_row_padding', suffix, property ) ]: 'body .site-footer .row-one',
				[ this.setSuffix( 'footer_second_row_padding', suffix, property ) ]: 'body .site-footer .row-two',
				[ this.setSuffix( 'footer_third_row_padding', suffix, property ) ]: 'body .site-footer .row-three',
			}
		}	// End of _getSpacing() Method

		/**
		 * Returns all responsive number controls with its id and its related selectors
		 * 
		 * @since 1.0.0
		 */
		_getResponsiveNumber = () => {
			let suffix = 'responsiveNumber'
			let property = 'width'

			return {
				[ this.setSuffix( 'site_logo_width', suffix, property ) ] : 'body .site-branding img',
				[ this.setSuffix( 'theme_mode_icon_size', suffix, [ property, 'font-size' ] ) ] : 'body .site-header .mode-toggle img, body .site-header .mode-toggle i',
				[ this.setSuffix( 'main_banner_design_slider_icon_size', suffix, [ property, 'font-size' ] ) ] : 'body .blogmatic-main-banner-section .swiper-arrow img, body .blogmatic-main-banner-section .swiper-arrow i',
				[ this.setSuffix( 'carousel_design_slider_icon_size', suffix, [ property, 'font-size' ] ) ] : 'body .blogmatic-carousel-section .carousel-wrap .swiper-arrow i, body .blogmatic-carousel-section .carousel-wrap .swiper-arrow img',
				[ this.setSuffix( 'bottom_footer_logo_width', suffix, property ) ] : 'body .footer-logo img',
				[ this.setSuffix( 'search_icon_size', suffix, 'font-size' ) ] : 'body .site-header .search-trigger i',
				[ this.setSuffix( 'category_collection_image_radius', suffix, 'border-radius' ) ] : 'body .blogmatic-category-collection-section .category-wrap a'
			}
		}	// End of _getResponsiveNumber() Method

		/**
		 * Returns list of box shadow controls with its and selectors
		 * 
		 * @since 1.0.0
		 */
		_getBoxShadow = () => {
			let suffix = 'boxShadow'
			
			return {}
		}	// End of _getBoxShadow() Method

		/**
		 * Returns all controls that just toggle classes
		 * 
		 * 
		 * @since 1.0.0
		 */
		_getToggleClassControls = () => {
			let suffix = 'toggleClass'

			return {
				[ this.setSuffix( 'header_builder_section_width', suffix ) ] : {
					'selector' : 'header.site-header',
					'toggleClass' : 'boxed--layout full-width--layout'
				},
				[ this.setSuffix( 'footer_builder_section_width', suffix ) ] : {
					'selector' : 'footer.site-footer',
					'toggleClass' : 'boxed--layout full-width--layout'
				},
				// Header Builder First row
				[ this.setSuffix( 'header_first_row_column', suffix, 'column-' ) ] : {
					'selector' : 'header.site-header .bb-bldr-row.row-one',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				// Header Builder Second row
				[ this.setSuffix( 'header_second_row_column', suffix, 'column-' ) ] : {
					'selector' : 'header.site-header .bb-bldr-row.row-two',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				// Header Builder Third row
				[ this.setSuffix( 'header_third_row_column', suffix, 'column-' ) ] : {
					'selector' : 'header.site-header .bb-bldr-row.row-three',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				// Footer Builder First row
				[ this.setSuffix( 'footer_first_row_column', suffix, 'column-' ) ] : {
					'selector' : 'footer.site-footer .bb-bldr-row.row-one',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				// Footer Builder Second row
				[ this.setSuffix( 'footer_second_row_column', suffix, 'column-' ) ] : {
					'selector' : 'footer.site-footer .bb-bldr-row.row-two',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				// Footer Builder Three row
				[ this.setSuffix( 'footer_three_row_column', suffix, 'column-' ) ] : {
					'selector' : 'footer.site-footer .bb-bldr-row.row-three',
					'toggleClass' : 'column-1 column-2 column-3 column-4'
				},
				[ this.setSuffix( 'site_background_animation', suffix, 'background-animation--' ) ] : {
					'selector' : 'body',
					'toggleClass' : 'background-animation--none background-animation--one background-animation--two background-animation--three'
				},
				[ this.setSuffix( 'post_title_hover_effects', suffix, 'title-hover--' ) ] : {
					'selector' : 'body',
					'toggleClass' : 'title-hover--none title-hover--three title-hover--five'
				},
				[ this.setSuffix( 'site_image_hover_effects', suffix, 'image-hover--' ) ] : {
					'selector' : 'body',
					'toggleClass' : 'image-hover--none image-hover--three image-hover--five'
				},
				[ this.setSuffix( 'website_layout', suffix ) ] : {
					'selector' : 'body',
					'toggleClass' : 'boxed--layout full-width--layout'
				},
				[ this.setSuffix( 'header_menu_hover_effect', suffix, 'hover-effect--' ) ] : {
					'selector' : '#site-navigation',
					'toggleClass' : 'hover-effect--none hover-effect--two hover-effect--four'
				},
				[ this.setSuffix( 'custom_button_animation_type', suffix, 'animation-type--' ) ] : {
					'selector' : '.header-custom-button-wrapper a.header-custom-button',
					'toggleClass' : 'animation-type--none animation-type--three animation-type--four'
				},
				[ this.setSuffix( 'main_banner_post_elements_alignment', suffix, 'banner-align--' ) ] : {
					'selector' : '.blogmatic-main-banner-section',
					'toggleClass' : 'banner-align--right banner-align--center banner-align--left'
				},
				[ this.setSuffix( 'carousel_post_elements_alignment', suffix, 'carousel-align--' ) ] : {
					'selector' : '#blogmatic-carousel-section',
					'toggleClass' : 'carousel-align--center carousel-align--right carousel-align--left'
				},
				[ this.setSuffix( 'archive_post_elements_alignment', suffix, 'archive-align--' ) ] : {
					'selector' : 'body.archive .blogmatic-inner-content-wrap, body.blog .blogmatic-inner-content-wrap, body.home .blogmatic-inner-content-wrap, body.search .blogmatic-inner-content-wrap',
					'toggleClass' : 'archive-align--left archive-align--center archive-align--right'
				},
				[ this.setSuffix( 'single_post_content_alignment', suffix, 'content-alignment--' ) ] : {
					'selector' : 'body.single #primary .blogmatic-inner-content-wrap .entry-content',
					'toggleClass' : 'content-alignment--left content-alignment--center content-alignment--right'
				},
				[ this.setSuffix( 'category_collection_hover_effects', suffix, 'hover-effect--' ) ] : {
					'selector' : '#blogmatic-category-collection-section',
					'toggleClass' : 'hover-effect--none hover-effect--one'
				},
				[ this.setSuffix( 'you_may_have_missed_post_elements_alignment', suffix, 'you-may-have-missed-align--' ) ] : {
					'selector' : '.blogmatic-you-may-have-missed-section',
					'toggleClass' : 'you-may-have-missed-align--center you-may-have-missed-align--left you-may-have-missed-align--right'
				},
				[ this.setSuffix( 'mobile_canvas_alignment', suffix, 'alignment--' ) ] : {
					'selector' : 'header .bb-bldr--responsive .bb-bldr-row.mobile-canvas',
					'toggleClass' : 'alignment--left alignment--right alignment--center'
				}
			}
		}	// End of _getToggleClassControls() Method

		/**
		 * Returns all controls ids and selecters where text is dynamic
		 * 
		 * @since 1.0.0
		 */
		_getAddTextControls = () => {
			let suffix = 'addText'

			return {
				[ this.setSuffix( 'blogname', suffix )]  : '.site-title a',
				[ this.setSuffix( 'blogdescription', suffix )]  : '.site-description'
			}
		}	// End _getAddTextControls() Method

		/**
		 * Returns all border radius controls
		 *
		 * @since 1.0.0
		 */
		_getBorderRadius = () => {
			let suffix = 'borderRadius'
			let property = 'border-radius'

			return {
				[ this.setSuffix( 'sidebar_border_radius', suffix, property ) ]  : 'body .widget, body #widget_block',
				[ this.setSuffix( 'archive_section_border_radius', suffix, property ) ]  : 'body #blogmatic-main-wrap > .blogmatic-container > .row #primary .blogmatic-inner-content-wrap article .blogmatic-article-inner',
				[ this.setSuffix( 'single_page_border_radius', suffix, property ) ]  : 'body.single-post .post-thumbnail.no-single-featured-image, body.single-post #blogmatic-main-wrap .blogmatic-container .row #primary .blogmatic-inner-content-wrap article > div, body.single-post #blogmatic-main-wrap .blogmatic-container .row #primary nav.navigation, body.single-post #blogmatic-main-wrap .blogmatic-container .row #primary .single-related-posts-section-wrap.layout--list, body.single-post #primary article .post-card .bmm-author-thumb-wrap',
				[ this.setSuffix( 'page_border_radius', suffix, property ) ]  : '.page #blogmatic-main-wrap #primary article, .error404 .error-404',
			}
		}

		/**
		 * Returns all responsive radio image
		 *
		 * @since 1.0.0
		 */
		_getResponsiveRadioImage = () => {
			let suffix = 'responsiveRadioImage'

			return {
				[ this.setSuffix( 'header_first_row_column_layout', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one'
				},
				[ this.setSuffix( 'header_second_row_column_layout', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two'
				},
				[ this.setSuffix( 'header_third_row_column_layout', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three'
				},
				[ this.setSuffix( 'footer_first_row_column_layout', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one'
				},
				[ this.setSuffix( 'footer_second_row_column_layout', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two'
				},
				[ this.setSuffix( 'footer_third_row_column_layout', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three'
				},
			}
		}

		/**
		 * Returns all responsive radio tab
		 *
		 * @since 1.0.0
		 */
		_getResponsiveRadioTab = () => {
			let suffix = 'responsiveRadioTab'

			return {

				/* Header Builder first row */
				[ this.setSuffix( 'header_first_row_column_one', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.one',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.one'
				},
				[ this.setSuffix( 'header_first_row_column_two', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.two',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.two'
				},
				[ this.setSuffix( 'header_first_row_column_three', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.three',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-one .bb-bldr-column.three'
				},
				/* Header Builder second row */
				[ this.setSuffix( 'header_second_row_column_one', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.one',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.one'
				},
				[ this.setSuffix( 'header_second_row_column_two', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.two',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.two'
				},
				[ this.setSuffix( 'header_second_row_column_three', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.three',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-two .bb-bldr-column.three'
				},
				/* Header Builder third row */
				[ this.setSuffix( 'header_third_row_column_one', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.one',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.one'
				},
				[ this.setSuffix( 'header_third_row_column_two', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.two',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.two'
				},
				[ this.setSuffix( 'header_third_row_column_three', suffix ) ]  : {
					'desktop': 'header.site-header .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three',
					'tablet': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.three',
					'smartphone': 'header.site-header .bb-bldr--responsive .bb-bldr-row.row-three .bb-bldr-column.three'
				},
				/* Footer Builder first row */
				[ this.setSuffix( 'footer_first_row_column_one', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.one'
				},
				[ this.setSuffix( 'footer_first_row_column_two', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.two'
				},
				[ this.setSuffix( 'footer_first_row_column_three', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.three'
				},
				[ this.setSuffix( 'footer_first_row_column_four', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.four',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.four',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-one .bb-bldr-column.four'
				},
				/* Footer Builder second row */
				[ this.setSuffix( 'footer_second_row_column_one', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.one'
				},
				[ this.setSuffix( 'footer_second_row_column_two', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.two'
				},
				[ this.setSuffix( 'footer_second_row_column_three', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.three'
				},
				[ this.setSuffix( 'footer_second_row_column_four', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.four',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.four',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-two .bb-bldr-column.four'
				},
				/* Footer Builder third row */
				[ this.setSuffix( 'footer_third_row_column_one', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.one'
				},
				[ this.setSuffix( 'footer_third_row_column_two', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.two'
				},
				[ this.setSuffix( 'footer_third_row_column_three', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.three'
				},
				[ this.setSuffix( 'footer_third_row_column_four', suffix ) ]  : {
					'desktop': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.four',
					'tablet': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.four',
					'smartphone': 'footer.site-footer .bb-bldr--normal .bb-bldr-row.row-three .bb-bldr-column.four'
				},
			}
		}

		/**
		 * Get all controls
		 * 
		 * @since 1.0.0
		 */
		_getControls = () => {
			let allControls = {}
			allControls = { ...allControls, ...this._getTypography() }
			allControls = { ...allControls, ...this._getBorder() }
			allControls = { ...allControls, ...this._getColor() }
			allControls = { ...allControls, ...this._getCheckbox() }
			allControls = { ...allControls, ...this._getSpacing() }
			allControls = { ...allControls, ...this._getResponsiveNumber() }
			allControls = { ...allControls, ...this._getBoxShadow() }
			allControls = { ...allControls, ...this._getToggleClassControls() }
			allControls = { ...allControls, ...this._getAddTextControls() }
			allControls = { ...allControls, ...this._getBorderRadius() }
			allControls = { ...allControls, ...this._getResponsiveRadioImage() }
			allControls = { ...allControls, ...this._getResponsiveRadioTab() }
			return allControls;
		}	// End of _getControls()  method

		/**
		 * change preview according to change
		 * 
		 * @since 1.0.0
		 */
		preview = () => {
			let controls = this._getControls()
			const THIS = this
			const TYPEARRAY = [ 'checkbox', 'toggleClass', 'addText', 'responsiveRadioImage', 'responsiveRadioTab' ]
			Object.entries( controls ).map(([ controlId, selector ]) => {
				const HYPEN = controlId.indexOf('-')
				const ID = controlId.slice( 0, HYPEN )
				const CONTROLTYPE = controlId.slice( HYPEN + 1 )
				const [ TYPE, PROPERTY ] = CONTROLTYPE.split('+')
				var styleTagId = ID.replaceAll( '_', '-' )
				wp.customize( ID, function( value ) {
					value.bind( function( to ) {
						if( ! TYPEARRAY.includes( TYPE ) ) {
							var cssCode = THIS.generateCssCode( CONTROLTYPE, selector, to, ID )
							if( cssCode ) {
								themeCalls.blogmaticGenerateStyleTag( cssCode, 'blogmatic-' + styleTagId )
							} else {
								themeCalls.blogmaticGenerateStyleTag( '', 'blogmatic-' + styleTagId )
							}
						} else {
							THIS.generateCssCode( CONTROLTYPE, selector, to, ID )
						}
					});
				});
			})
		}	// End of Preview() Method

		/**
		 * generate css code for preview
		 * 
		 * @since 1.0.0
		 */
		generateCssCode = ( controlType, selector, value, controlId ) => {
			const [ TYPE, PROPERTY ] = controlType.split('+')
			const ID = controlId
			if( TYPE ) {
				var cssCode = ''
				let isVariable = ( [ 'responsiveRadioImage', 'responsiveRadioTab' ].includes( controlType ) ) ? '' : this.isVariale( selector )
				switch( TYPE ) {
					case 'typography' :
							ajaxFunctions.typoFontsEnqueue( value )
							if( isVariable ) {
								cssCode = themeCalls.blogmaticGenerateTypoCss( selector, value )	// variable
							} else {
								cssCode = themeCalls.blogmaticGenerateTypoCssWithSelector( selector, value )	// class
							}
						break;
					case 'border' :
							cssCode += selector + " {\n"
							cssCode += "border-color: " + blogmatic_get_color_format( value.color ) + ';\n'
							cssCode += "border-style: " + value.type + ";\n"
							let { top, right, bottom, left } = value.width
							cssCode += "border-width: " + top + "px  "+ right + "px " + bottom + "px " + left + "px; \n } "
						break;
					case 'color' :
							if( isVariable ) {
								if( 'initial' in value ) {
									cssCode += 'body { '+ selector +' : ' + blogmatic_get_color_format( value.initial[ value.initial.type ] ) + ' }';
									cssCode += 'body { '+ selector +'-hover : ' + blogmatic_get_color_format( value.hover[ value.hover.type ] ) + ' }';
								} else {
									cssCode += 'body { '+ selector +': ' + blogmatic_get_color_format( value[ value.type ] ) + ' }';
								}
							} else {
								if( 'initial' in value ) {
									cssCode += selector + ' { '+ PROPERTY +': ' + blogmatic_get_color_format( value.initial[ value.initial.type ] ) + ' }';
									cssCode += selector + ' { '+ PROPERTY +': ' + blogmatic_get_color_format( value.hover[ value.hover.type ] ) + ' }';
								} else {
									cssCode += selector + ' { ' + blogmatic_get_background_style( value ) + ' }';
								}
							}
						break;
					case 'checkbox' :
							if( $( selector ).hasClass( PROPERTY ) ) {
								$( selector ).removeClass( PROPERTY )
							} else {
								$( selector ).addClass( PROPERTY )
							}
							return
						break;
					case 'spacing' :
							if( value.desktop ) {
								let desktop = value.desktop
								cssCode += selector + '{ '+ PROPERTY +': ' + desktop.top + 'px ' + desktop.right + 'px ' + desktop.bottom + 'px ' + desktop.left + 'px }';
							}
							if( value.tablet ) {
								let tablet = value.tablet
								cssCode += '@media(max-width: 940px) {'+ selector  +'{ '+ PROPERTY +': ' + tablet.top + 'px ' + tablet.right + 'px ' + tablet.bottom + 'px ' + tablet.left + 'px } }';
							}
							if( value.smartphone ) {
								let smartphone = value.smartphone
								cssCode += '@media(max-width: 610px) {'+ selector  +'{ '+ PROPERTY +': ' + smartphone.top + 'px ' + smartphone.right + 'px ' + smartphone.bottom + 'px ' + smartphone.left + 'px } }';
							}
						break;
					case 'responsiveNumber' :
							// desktop
							const percentControls = []
							let unit = percentControls.includes( ID ) ? '%' : 'px'
							if( PROPERTY != 'image-ratio' ) {
								const PROPERTIES = PROPERTY.split(',')
								if( Array.isArray( PROPERTIES ) ) {
									var cssCodeArray = PROPERTIES.map( current => {
										return selector + '{ '+ current +': ' + value.desktop + unit + '}'
									} )
									cssCode += cssCodeArray.join('')
								} else {
									if( $( selector ).length > 0 ) cssCode += selector + '{ '+ PROPERTY +': ' + value.desktop + unit + '}'
								}
							}  else {
								if( isVariable ) {
									cssCode += 'body{ '+ selector +': ' + value.desktop + '}'
								} else {
									cssCode += selector + '{ padding-bottom: calc(' + value.desktop +  ' * 100%) }'
								}
							}

							// tablet
							if( PROPERTY != 'image-ratio' ) {
								const PROPERTIES = PROPERTY.split(',')
								if( Array.isArray( PROPERTIES ) ) {
									var cssCodeArray = PROPERTIES.map( current => {
										return '@media(max-width: 994px) { '+ selector + '{ '+ current +': ' + value.tablet + unit + '} }'
									} )
									cssCode += cssCodeArray.join('')
								} else {
									cssCode += '@media(max-width: 994px) { '+ selector + '{ '+ PROPERTY +': ' + value.tablet + unit + '} } '
								}
							}  else {
								if( isVariable ) {
									cssCode += '@media(max-width: 994px) { body {' + selector + '-tab :' + value.tablet + '} }'
								} else {
									cssCode += '@media(max-width: 994px) { ' + selector + ' { padding-bottom: calc(' + value.tablet +  ' * 100%) } }'
								}
							}

							// smartphone
							if( PROPERTY != 'image-ratio' ) {
								const PROPERTIES = PROPERTY.split(',')
								if( Array.isArray( PROPERTIES ) ) {
									var cssCodeArray = PROPERTIES.map( current => {
										return '@media(max-width: 610px) { '+ selector + '{ '+ current +': ' + value.smartphone + unit + '} } '
									} )
									cssCode += cssCodeArray.join('')
								} else {
									cssCode += '@media(max-width: 610px) { '+ selector + '{ '+ PROPERTY +': ' + value.smartphone + unit + '} } '
								}
							}  else {
								if( isVariable ) {
									cssCode += '@media(max-width: 610px){ body {' + selector + '-mobile:' + value.smartphone + '} }'
								} else {
									cssCode += '@media(max-width: 610px){ ' + selector + '{ padding-bottom: calc(' + value.smartphone +  ' * 100%) } }'
								}
							}
						break;
					case 'boxShadow' :
							const { option, hoffset, voffset, blur, spread, type, color } = value
							if( option != undefined && option ) {
								if( type == 'outset' ) {
									cssCode += selector['selector'] + " { box-shadow: " + hoffset + "px " + voffset + "px " + blur + "px " + spread + "px " + blogmatic_get_color_format( color ) + " } "
								} else {
									cssCode += selector['selector'] + " { box-shadow: " + type + " " + hoffset + "px " + voffset + "px " + blur + "px " + spread + "px " + blogmatic_get_color_format( color ) + " } "
								}
							}
						break;
					case 'toggleClass' :
							let classToAdd = ( PROPERTY === undefined ) ? value : PROPERTY + value
							$( selector['selector'] ).removeClass( selector['toggleClass'] ).addClass( classToAdd )
						break;
					case 'addText' :
							$( selector ).text( value )
						break;
					case 'borderRadius' :
							cssCode += selector + " { " + PROPERTY + ": " + value + "px } "
						break;
					case 'responsiveRadioImage' :
							const { desktop: desktopVal, tablet: tabletVal, smartphone: smartphoneVal } = value
							const { desktop, tablet, smartphone } = selector

							$(desktop).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/layout-\S+/g ) || [] ).join(' ');
							}).addClass( 'layout-' + desktopVal )
							
							$(tablet).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/tablet-layout-\S+/g ) || [] ).join(' ');
							}).addClass( 'tablet-layout-' + tabletVal )

							$(smartphone).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/smartphone-layout-\S+/g ) || [] ).join(' ');
							}).addClass( 'smartphone-layout-' + smartphoneVal )
						break;
					case 'responsiveRadioTab' :
							const { desktop: desktopTab, tablet: tabletTab, smartphone: smartphoneTab } = value
							const { desktop: desktopSel, tablet: tabletSel, smartphone: smartphoneSel } = selector

							$( desktopSel ).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/alignment-\S+/g ) || [] ).join(' ');
							}).addClass( 'alignment-' + desktopTab )
							
							$( tabletSel ).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/tablet-alignment-\S+/g ) || [] ).join(' ');
							}).addClass( 'tablet-alignment--' + tabletTab )

							$( smartphoneSel ).removeClass(function( index, _thisClass ) {
								return ( _thisClass.match(/smartphone-alignment-\S+/g ) || [] ).join(' ');
							}).addClass( 'smartphone-alignment--' + smartphoneTab )
						break;
					default:
						cssCode = TYPE + ' default'
				}
				return cssCode;
			}
		}	// End of generateCssCode() method
	}

	new BlogmaticCustomize();
}( jQuery ) );