<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Blogmatic
 */
use Blogmatic\CustomizerDefault as BMC;

get_header();

if( did_action( 'elementor/loaded' ) && class_exists( 'Nekit_Render_Templates_Html' ) ) :
	$Nekit_render_templates_html = new Nekit_Render_Templates_Html();
	if( $Nekit_render_templates_html->is_template_available('404') ) {
		$single_rendered = true;
		echo $Nekit_render_templates_html->current_builder_template();
	} else {
		$single_rendered = false;
	}
else :
	$single_rendered = false;
endif;

if( ! $single_rendered ) :
	do_action( 'blogmatic_main_content_opening' );
	$error_page_button_icon = BMC\blogmatic_get_customizer_option( 'error_page_button_icon' );
	$page_settings_sidebar_layout = BMC\blogmatic_get_customizer_option( 'page_settings_sidebar_layout' );
	if( in_array( $page_settings_sidebar_layout, ['left-sidebar','both-sidebar'] )  ) get_sidebar('left');
	?>
		<main id="primary" class="site-main">
			<section class="error-404 not-found">
				<header class="page-header">
					<h1 class="page-title"><?php echo esc_html__( 'Oops! That page can’t be found.', 'blogmatic' ); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">
					<p><?php echo esc_html__( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'blogmatic' ); ?></p>
					<div class="back_to_home_btn">
						<a href="<?php echo esc_url( home_url() ); ?>">
							<?php
								echo blogmatic_get_icon_control_html( $error_page_button_icon );
								echo '<span class="button-label">'. esc_html__( 'Back to Home', 'blogmatic' ) .'</span>';
							?>
						</a>	
					</div>
				</div><!-- .page-content -->
			</section><!-- .error-404 -->
		</main><!-- #main -->

	<?php
	if( in_array( $page_settings_sidebar_layout, ['right-sidebar','both-sidebar'] )  ) get_sidebar();
	do_action( 'blogmatic_main_content_closing' );
endif;

get_footer();