!(function ($) {
  wp.customize.controlConstructor["bloglo-background"] =
    wp.customize.Control.extend({
      ready: function () {
        "use strict";
        var range,
          range_input,
          bloglo_range_input_number_timeout,
          control = this,
          value = control.setting._value;
        control.container.find(".background-image-advanced").hide(),
          control.container.on(
            "change",
            ".background-repeat select",
            function () {
              control.saveValue("background-repeat", $(this).val());
            }
          ),
          control.container.on(
            "change click",
            ".background-size input",
            function () {
              control.saveValue("background-size", $(this).val());
            }
          ),
          control.container.on(
            "change click",
            ".background-attachment input",
            function () {
              control.saveValue("background-attachment", $(this).val());
            }
          ),
          control.container.on(
            "click",
            ".background-image-upload-button",
            function (e) {
              var image = wp
                .media({
                  multiple: !1,
                  title: control.params.l10n.select_image,
                  button: { text: control.params.l10n.use_image },
                })
                .open()
                .on("select", function () {
                  var previewImage,
                    imageUrl,
                    imageID,
                    preview,
                    removeButton,
                    uploadedImageJSON = image
                      .state()
                      .get("selection")
                      .first()
                      .toJSON();
                  (previewImage = _.isUndefined(uploadedImageJSON.sizes)
                    ? uploadedImageJSON.url
                    : _.isUndefined(uploadedImageJSON.sizes.medium)
                    ? _.isUndefined(uploadedImageJSON.sizes.thumbnail)
                      ? _.isUndefined(uploadedImageJSON.sizes.full)
                        ? uploadedImageJSON.url
                        : uploadedImageJSON.sizes.full.url
                      : uploadedImageJSON.sizes.thumbnail.url
                    : uploadedImageJSON.sizes.medium.url),
                    (imageUrl = uploadedImageJSON.url),
                    (imageID = uploadedImageJSON.id),
                    uploadedImageJSON.width,
                    uploadedImageJSON.height,
                    "" !== imageUrl &&
                      (control.container
                        .find(".background-image-advanced")
                        .show(),
                      control.container
                        .find(".advanced-settings")
                        .removeClass("hidden")
                        .addClass("up")),
                    control.saveValue("background-image", imageUrl),
                    control.saveValue("background-image-id", imageID),
                    (preview = control.container.find(
                      ".placeholder, .thumbnail"
                    )),
                    (removeButton = control.container.find(
                      ".background-image-upload-remove-button"
                    )),
                    preview.length &&
                      preview
                        .removeClass()
                        .addClass("thumbnail thumbnail-image")
                        .html('<img src="' + previewImage + '" alt="" />'),
                    removeButton.length && removeButton.show();
                });
              e.preventDefault();
            }
          ),
          control.container.on(
            "click",
            ".background-image-upload-remove-button",
            function (e) {
              var preview, removeButton;
              e.preventDefault(),
                control.saveValue("background-image", ""),
                control.saveValue("background-image-id", ""),
                (preview = control.container.find(".placeholder, .thumbnail")),
                (removeButton = control.container.find(
                  ".background-image-upload-remove-button"
                )),
                control.container.find(".background-image-advanced").hide(),
                control.container
                  .find(".advanced-settings")
                  .addClass("hidden")
                  .removeClass("up"),
                preview.length &&
                  preview
                    .removeClass()
                    .addClass("placeholder")
                    .html(control.params.l10n.placeholder),
                removeButton.length && removeButton.hide();
            }
          ),
          control.container.on("click", ".advanced-settings", function (e) {
            $(this).toggleClass("up"),
              control.container.find(".background-image-advanced").toggle();
          }),
          control.container
            .find("input.bloglo-range-input")
            .on("change keyup", function () {
              control.autocorrect_range_input_number(
                $(this),
                1e3,
                bloglo_range_input_number_timeout
              );
            })
            .on("focusout", function () {
              control.autocorrect_range_input_number(
                $(this),
                0,
                bloglo_range_input_number_timeout
              );
            }),
          control.container
            .find("input[type=range]")
            .on("mousedown", function () {
              (range = $(this)),
                (range_input = range.parent().children(".bloglo-range-input")),
                (value = range.attr("value")),
                range_input.val(value),
                range.mousemove(function () {
                  (value = range.attr("value")),
                    range_input.val(value),
                    clearTimeout(bloglo_range_input_number_timeout),
                    (bloglo_range_input_number_timeout = setTimeout(
                      function () {
                        control.saveValue(range.data("key"), value);
                      },
                      25
                    ));
                });
            });
      },
      saveValue: function (property, value) {
        var val = this.setting.get();
        value !== (val = val || {})[property] &&
          (((val = JSON.parse(JSON.stringify(val)))[property] = value),
          this.setting.set(val));
      },
      autocorrect_range_input_number: function (input_number, timeout) {
        var range_input = input_number,
          range = range_input.parent().find('input[type="range"]'),
          value = parseFloat(range_input.val()),
          reset = parseFloat(
            range.find(".bloglo-reset-range").attr("data-reset_value")
          ),
          step = parseFloat(range_input.attr("step")),
          min = parseFloat(range_input.attr("min")),
          max = parseFloat(range_input.attr("max"));
        clearTimeout(timeout),
          (timeout = setTimeout(function () {
            if (isNaN(value)) {
              return (
                range_input.val(reset), void range.val(reset).trigger("change")
              );
            }
            1 <= step &&
              0 != value % 1 &&
              ((value = Math.round(value)),
              range_input.val(value),
              range.val(value).trigger("change")),
              value > max &&
                (range_input.val(max), range.val(max).trigger("change")),
              value < min &&
                (range_input.val(min), range.val(min).trigger("change"));
          }, timeout)),
          range.val(value).trigger("change"),
          this.saveValue(range.data("key"), value);
      },
    });
})(jQuery);
!(function (e) {
  wp.customize.controlConstructor["bloglo-background"] =
    wp.customize.Control.extend({
      ready: function () {
        "use strict";
        var a,
          n,
          t,
          i = this,
          r = i.setting._value;
        i.container.find(".background-image-advanced").hide(),
          i.container.on("change", ".background-repeat select", function () {
            i.saveValue("background-repeat", e(this).val());
          }),
          i.container.on("change click", ".background-size input", function () {
            i.saveValue("background-size", e(this).val());
          }),
          i.container.on(
            "change click",
            ".background-attachment input",
            function () {
              i.saveValue("background-attachment", e(this).val());
            }
          ),
          i.container.on(
            "click",
            ".background-image-upload-button",
            function (e) {
              var a = wp
                .media({
                  multiple: !1,
                  title: i.params.l10n.select_image,
                  button: { text: i.params.l10n.use_image },
                })
                .open()
                .on("select", function () {
                  var e,
                    n,
                    t,
                    r,
                    o,
                    u = a.state().get("selection").first().toJSON();
                  (e = _.isUndefined(u.sizes)
                    ? u.url
                    : _.isUndefined(u.sizes.medium)
                    ? _.isUndefined(u.sizes.thumbnail)
                      ? _.isUndefined(u.sizes.full)
                        ? u.url
                        : u.sizes.full.url
                      : u.sizes.thumbnail.url
                    : u.sizes.medium.url),
                    (n = u.url),
                    (t = u.id),
                    u.width,
                    u.height,
                    "" !== n &&
                      (i.container.find(".background-image-advanced").show(),
                      i.container
                        .find(".advanced-settings")
                        .removeClass("hidden")
                        .addClass("up")),
                    i.saveValue("background-image", n),
                    i.saveValue("background-image-id", t),
                    (r = i.container.find(".placeholder, .thumbnail")),
                    (o = i.container.find(
                      ".background-image-upload-remove-button"
                    )),
                    r.length &&
                      r
                        .removeClass()
                        .addClass("thumbnail thumbnail-image")
                        .html('<img src="' + e + '" alt="" />'),
                    o.length && o.show();
                });
              e.preventDefault();
            }
          ),
          i.container.on(
            "click",
            ".background-image-upload-remove-button",
            function (e) {
              var a, n;
              e.preventDefault(),
                i.saveValue("background-image", ""),
                i.saveValue("background-image-id", ""),
                (a = i.container.find(".placeholder, .thumbnail")),
                (n = i.container.find(
                  ".background-image-upload-remove-button"
                )),
                i.container.find(".background-image-advanced").hide(),
                i.container
                  .find(".advanced-settings")
                  .addClass("hidden")
                  .removeClass("up"),
                a.length &&
                  a
                    .removeClass()
                    .addClass("placeholder")
                    .html(i.params.l10n.placeholder),
                n.length && n.hide();
            }
          ),
          i.container.on("click", ".advanced-settings", function (a) {
            e(this).toggleClass("up"),
              i.container.find(".background-image-advanced").toggle();
          }),
          i.container
            .find("input.bloglo-range-input")
            .on("change keyup", function () {
              i.autocorrect_range_input_number(e(this), 1e3, t);
            })
            .on("focusout", function () {
              i.autocorrect_range_input_number(e(this), 0, t);
            }),
          i.container.find("input[type=range]").on("mousedown", function () {
            (a = e(this)),
              (n = a.parent().children(".bloglo-range-input")),
              (r = a.attr("value")),
              n.val(r),
              a.mousemove(function () {
                (r = a.attr("value")),
                  n.val(r),
                  clearTimeout(t),
                  (t = setTimeout(function () {
                    i.saveValue(a.data("key"), r);
                  }, 25));
              });
          });
      },
      saveValue: function (e, a) {
        var n = this.setting.get();
        a !== (n = n || {})[e] &&
          (((n = JSON.parse(JSON.stringify(n)))[e] = a), this.setting.set(n));
      },
      autocorrect_range_input_number: function (e, a) {
        var n = e,
          t = n.parent().find('input[type="range"]'),
          i = parseFloat(n.val()),
          r = parseFloat(
            t.find(".bloglo-reset-range").attr("data-reset_value")
          ),
          o = parseFloat(n.attr("step")),
          u = parseFloat(n.attr("min")),
          s = parseFloat(n.attr("max"));
        clearTimeout(a),
          (a = setTimeout(function () {
            if (isNaN(i)) return n.val(r), void t.val(r).trigger("change");
            1 <= o &&
              0 != i % 1 &&
              ((i = Math.round(i)), n.val(i), t.val(i).trigger("change")),
              i > s && (n.val(s), t.val(s).trigger("change")),
              i < u && (n.val(u), t.val(u).trigger("change"));
          }, a)),
          t.val(i).trigger("change"),
          this.saveValue(t.data("key"), i);
      },
    });
})(jQuery);
