<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogistic
 */
use Blogistic\CustomizerDefault as BIT;
get_header();

if( did_action( 'elementor/loaded' ) && class_exists( 'Nekit_Render_Templates_Html' ) ) :
	$Nekit_render_templates_html = new Nekit_Render_Templates_Html();
	if( $Nekit_render_templates_html->is_template_available('single') ) {
		$single_rendered = true;
		echo $Nekit_render_templates_html->current_builder_template();
	} else {
		$single_rendered = false;
	}
else :
	$single_rendered = false;
endif;

if( ! $single_rendered ) :
	do_action( 'blogistic_main_content_opening' );
	$page_settings_sidebar_layout = BIT\blogistic_get_customizer_option( 'page_settings_sidebar_layout' );
	if( in_array( $page_settings_sidebar_layout, [ 'left-sidebar', 'both-sidebar' ] ) ) get_sidebar( 'left' );
	?>
		<main id="primary" class="site-main">

			<?php
			while ( have_posts() ) :
				the_post();

				get_template_part( 'template-parts/content', 'page' );

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile; // End of the loop.
			?>

		</main><!-- #main -->

	<?php
	$array['position'] = ['right-sidebar', 'both-sidebar'];
	if( in_array( $page_settings_sidebar_layout, [ 'right-sidebar', 'both-sidebar' ] ) ) get_sidebar();
	do_action( 'blogistic_main_content_closing' );
endif;
get_footer();