<?php
/**
 * The Header for our theme.
 *
 * @package Blogger Choice
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="toggle"><a class="toggleMenu" href="#"><?php esc_html_e('Menu','blogger-choice'); ?></a></div>
<div id="header">
  <div class="top_headbar">
    <div class="container">
      <div class="row">
        <div class="col-md-6 menus">
          <div class="menubox header">
            <div class="nav">
             <?php wp_nav_menu( array('theme_location'  => 'primary') ); ?>
            </div>
            <div class="clearfix"></div>
          </div>
        </div>
        <div class="col-md-6">
          <div class="row">
            <div class="col-md-4 socialbox">
              <?php if( get_theme_mod( 'multipurpose_blog_cont_facebook','' ) != '') { ?>
                <a href="<?php echo esc_url( get_theme_mod( 'multipurpose_blog_cont_facebook','https://www.facebook.com/' ) ); ?>"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
              <?php } ?>
              <?php if( get_theme_mod( 'multipurpose_blog_cont_twitter','' ) != '') { ?>
                <a href="<?php echo esc_url( get_theme_mod( 'multipurpose_blog_cont_twitter','https://twitter.com/' ) ); ?>"><i class="fab fa-twitter" aria-hidden="true"></i></a>
              <?php } ?>
              <?php if( get_theme_mod( 'multipurpose_blog_google_plus','' ) != '') { ?>
                <a href="<?php echo esc_url( get_theme_mod( 'multipurpose_blog_google_plus','https://plus.google.com/' ) ); ?>"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a>
              <?php } ?>
              <?php if( get_theme_mod( 'multipurpose_blog_pinterest','' ) != '') { ?>
                <a href="<?php echo esc_url( get_theme_mod( 'multipurpose_blog_pinterest','https://www.pinterest.com/' ) ); ?>"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a>
              <?php } ?>
              <?php if( get_theme_mod( 'multipurpose_blog_tumblr','' ) != '') { ?>
                <a href="<?php echo esc_url( get_theme_mod( 'multipurpose_blog_tumblr','https://www.tumblr.com/' ) ); ?>"><i class="fab fa-tumblr" aria-hidden="true"></i></a>
              <?php } ?>
            </div>
            <div class="top-contact col-md-4 col-xs-12 col-sm-4">
              <?php if( get_theme_mod( 'multipurpose_blog_contact','' ) != '') { ?>
                <span class="call"><i class="fa fa-phone" aria-hidden="true"></i><?php echo esc_html( get_theme_mod('multipurpose_blog_contact',__('(518) 356-5373','blogger-choice') )); ?></span>
               <?php } ?>
            </div>   
            <div class="top-contact col-md-4 col-xs-12 col-sm-4">
              <?php if( get_theme_mod( 'multipurpose_blog_email','' ) != '') { ?>
                <span class="email"><i class="fa fa-envelope" aria-hidden="true"></i><?php echo esc_html( get_theme_mod('multipurpose_blog_email',__('support@vwthemes.com','blogger-choice')) ); ?></span>
              <?php } ?>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="clearfix"></div>
  </div>
  <div class="logo_bar">
    <div class="logo wow bounceInDown">
      <?php if( has_custom_logo() ){ multipurpose_blog_the_custom_logo();
         }else{ ?>
        <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_attr(bloginfo( 'name' )); ?></a></h1>
        <?php $description = get_bloginfo( 'description', 'display' );
        if ( $description || is_customize_preview() ) : ?> 
          <p class="site-description"><?php echo esc_html($description); ?></p>       
      <?php endif; }?>
    </div>   
    <div class="clear"></div>
  </div>
</div><?php /** header **/ ?>