<?php
/**
 * Theme Functions.
 */

add_action( 'wp_enqueue_scripts', 'blogger_choice_enqueue_styles' );
	function blogger_choice_enqueue_styles() {
    	$parent_style = 'multipurpose-blog-style'; // Style handle of parent theme.
		wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'blogger-choice-style', get_stylesheet_uri(), array( $parent_style ) );
}

// Customizer Section
function blogger_choice_customizer ( $wp_customize ) {

	//Our Blog Category section
  	$wp_customize->add_section('blogger_choice_our_blog_cat_section',array(
	    'title' => __('Our Blog Category Section','blogger-choice'),
	    'description' => '',
	    'priority'  => null,
	    'panel' => 'multipurpose_blog_panel_id',
	)); 

	$categories = get_categories();
	$cats = array();
	$i = 0;
  	foreach($categories as $category){
  	if($i==0){
	$default = $category->slug;
	$i++;
	}
	$cats[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('blogger_choice_our_category',array(
	    'default' => 'select',
	    'sanitize_callback' => 'sanitize_text_field',
  	));

  	$wp_customize->add_control('blogger_choice_our_category',array(
	    'type'    => 'select',
	    'choices' => $cats,
	    'label' => __('Select Category to display Latest Post','blogger-choice'),
	    'section' => 'blogger_choice_our_blog_cat_section',
	));
}
add_action( 'customize_register', 'blogger_choice_customizer' );

/* Theme Widgets Setup */
function blogger_choice_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Home Sidebar', 'blogger-choice' ),
		'description'   => __( 'Appears on Home Page', 'blogger-choice' ),
		'id'            => 'home',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'blogger_choice_widgets_init' );

define('blogger_choice_LINK_CREDIT','https://wordpress.org','blogger-choice');

if ( ! function_exists( 'blogger_choice_link_credit' ) ) {
	function blogger_choice_link_credit(){
			echo "<a href=".esc_url(blogger_choice_LINK_CREDIT)." target='_blank'>". esc_html__('wordpress.org','blogger-choice') ."</a>";
	}
}

?>