<?php
/**
 * A custom template displayed on the site's Blog page.
 *
 */

get_header() ?>

<section id="homepage-features" class="content-container">
	<?php BlogfolioTemplate::showWidgetContainer( 'homepage' ) ?>

	<div class="post-tiles latest-posts">
	<?php if( Blogfolio::config( 'feature-newest-post' ) and ! is_paged() && have_posts() ) : the_post() ?>
		<div <?php post_class( 'latest-post blog-post post-tile' ) ?>>
			<?php the_post_thumbnail( 'large' ) ?>
			<div class="post-preview"><?php BlogfolioTemplate::showPostPreview() ?></div>
			<a class="post-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute() ?>"><span class="title-text"><?php the_title() ?></span></a>
		</div>
	<?php endif ?>
	<?php while( have_posts() ) : the_post() ?>
		<div <?php post_class( 'blog-post post-tile' ) ?>>
			<?php the_post_thumbnail() ?>
			<div class="post-preview"><?php BlogfolioTemplate::showPostPreview() ?></div>
			<a class="post-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute() ?>"><span class="title-text"><?php the_title() ?></span></a>
		</div>
	<?php endwhile ?>
	</div>

	<?php BlogfolioTemplate::paginate( 'loop' ) ?>
</section>

<?php get_footer() ?>