<?php
/**
 * Theme header template.
 * As is standard, should be included first in every template.
 *
 */
 
?><!DOCTYPE html>
<!--[if lt IE 7 ]><html <?php language_attributes() ?> class="no-js ie ie6 lte7 lte8 lte9"><![endif]-->
<!--[if IE 7 ]><html <?php language_attributes() ?> class="no-js ie ie7 lte7 lte8 lte9"><![endif]-->
<!--[if IE 8 ]><html <?php language_attributes() ?> class="no-js ie ie8 lte8 lte9"><![endif]-->
<!--[if IE 9 ]><html <?php language_attributes() ?> class="no-js ie ie9 lte9"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--><html <?php language_attributes() ?>><!--<![endif]-->
    <head>
        <meta charset="<?php bloginfo( 'charset' ) ?>"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=false"/>
        <title><?php wp_title( '|', true, 'right' ); ?></title>
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ) ?>"/>
		<?php
			if ( is_singular() && get_option( 'thread_comments' ) )
				wp_enqueue_script( 'comment-reply' );

			wp_head();
		?>
	</head>
	<body <?php body_class() ?>>
		<div class="page-container container">

		<header id="page-header">
			<div class="container">
				<a class="assistive-text" href="#page-content" title="<?php esc_attr_e( 'Skip to content', 'blogfolio' ) ?>"><?php _e( 'Skip to content', 'blogfolio' ) ?></a>

				<div id="top-bar">
					<div class="container">
					<?php do_action( 'blogfolio_topbar' ) ?>
					</div>
				</div>

				<div class="site-banner">
					<h1 class="site-title">
						<a href="<?php echo esc_url( home_url( '/' ) ) ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ) ?>" rel="home">
						<?php if( get_header_image() ) : ?>
							<img src="<?php header_image() ?>" height="<?php echo get_custom_header()->height ?>" width="<?php echo get_custom_header()->width ?>" alt="<?php bloginfo( 'name' ) ?>"/>
						<?php endif; ?>
							<span class="<?php echo display_header_text() ? 'text' : 'assistive' ?>"><?php bloginfo( 'name' ) ?></span>
						</a>
					</h1>
					<h2 class="site-subtitle"><?php bloginfo( 'description' ) ?></h2>
				</div>

				<?php do_action( 'blogfolio_site_header' ) ?>
			</div>
		</header>

		<section id="page-content">
			<div class="container">
			<?php do_action( 'blogfolio_before_content' ) ?>