<?php
/**
 * Theme template for displaying an author profile.
 *
 */

// There should really be a more API-centric way of getting the author metadata. $author_name and $author are magical globals.
$curauth = isset( $_GET['author_name'] ) ? get_user_by( 'slug', $author_name ) : get_userdata( intval( $author ) );

get_header() ?>

<section class="content-container author-page">
	<h1>Published by <?php echo $curauth->display_name ?></h1>
	<div class="synopsis">
		<p class="description"><?php echo $curauth->description ?></p>
		<dl>
			<dt>Website</dt>
			<dd><a href="<?php echo esc_url( $curauth->user_url ) ?>"><?php echo esc_url( $curauth->user_url ) ?></a></dd>
		</dl>
	</div>

	<?php get_template_part( 'loop', 'author' ) ?>
</section>

<?php get_footer() ?>