<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogflux
 */

?>

<div class="wedevs-post-wrapper">
    
    <article id="article-post-<?php the_ID(); ?>" <?php post_class('wedevs-post wedevs-article-post'); ?> itemscope itemtype="https://schema.org/Blog">

        <div class="entry-thumbnail entry-thumbnail-effect">
            
            <?php blogflux_post_thumbnail('large'); ?>

            <?php if ('post' === get_post_type()) : ?>
                <div class="entry-meta">
                    <?php
                    blogflux_posted_on();
                    ?>
                </div>
            <?php endif; ?>
            
        </div>

        <div class="entry-details">
            <div class="site-row">
                <div class="site-column site-column-4 site-column-sm-12">
                    <?php if ('post' === get_post_type()) : ?>

                        <div class="entry-meta entry-meta-posted-by">
                            <?php blogflux_posted_by($c_title = true, $image = true); ?>
                        </div>

                        <?php blogflux_entry_tag(); ?>

                        <?php
                            if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) {

                                $comment_count = get_comments_number(get_the_ID());
                                $comment_url = get_comments_link(get_the_ID());
                                ?>

                                <div class="comment-link">
                                    <?php blogflux_get_theme_svg('comment'); ?>
                                    <a href="<?php echo esc_url($comment_url); ?>">
                                        <?php echo absint($comment_count) . esc_html__(' Comments', 'blogflux'); ?>
                                    </a>
                                </div>

                            <?php } ?>

                            <div class="wedevs-social-share">
                                <?php blogflux_social_share(); ?>
                            </div>

                    <?php endif; ?>
                </div>
                <div class="site-column site-column-8 site-column-sm-12">

                    <header class="entry-header">

                        <?php if ('post' === get_post_type()) : ?>

                            <div class="entry-meta entry-meta-categories">
                                <?php blogflux_entry_cat(); ?>
                            </div>

                        <?php endif;

                        if (is_singular()) :
                            the_title('<h1 class="entry-title font-size-large" itemprop="headline">', '</h1>');
                        else :
                            the_title('<h2 class="entry-title font-size-big" itemprop="headline"><a itemprop="url" href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
                        endif; ?>

                    </header><!-- .entry-header -->

                    <div class="entry-content" itemprop="text">

                        <?php
                        if (has_excerpt()) {

                            the_excerpt();

                        } else {

                            echo '<p>';
                            echo esc_html(wp_trim_words(get_the_content(), 25, '...'));
                            echo '</p>';

                        }
                        ?>


                        <?php if (!is_singular()) : ?>
                            
                                <a href="<?php the_permalink(); ?>" class="wedevs-btn wedevs-btn-primary">
                                    <?php esc_html_e('Continue Reading', 'blogflux'); ?>
                                    <?php blogflux_get_theme_svg('arrow-right'); ?>
                                </a>
                            
                        <?php endif; ?>

                    </div><!-- .entry-content -->

                </div>
            </div>
        </div>
        

    </article><!-- #post-<?php the_ID(); ?> -->
    
    <?php if (!is_search()) {
        blogflux_archive_recommended_posts();
    } ?>
    

</div>