<?php
/**
 * Social Icon Widgets.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_social_icon_widgets') ) :

    function blogflux_social_icon_widgets(){
        
        register_widget('Blogflux_Sidebar_Social_Icon_Widget');

    }

endif;

add_action('widgets_init', 'blogflux_social_icon_widgets');


if ( !class_exists('Blogflux_Sidebar_Social_Icon_Widget') ) :

    // Recent Post widget Form & Display

    class Blogflux_Sidebar_Social_Icon_Widget extends Blogflux_Widget_Base{

        function __construct(){

            $opts = array(
                'classname' => 'blogflux_social_icon_widget',
                'description' => esc_html__('Display social icon. You can enable and manage settings from Customizer -> Theme Option.', 'blogflux'),
                'customize_selective_refresh' => true,
            );


            $fields = array(
                'display_style' => array(
                    'label' => esc_html__('Layout:', 'blogflux'),
                    'type' => 'select',
                    'default' => 'layout-1',
                    'options' => array(
                        'layout-1' => esc_html__('Layout One','blogflux'),
                        'layout-2' => esc_html__('Layout Two','blogflux'),
                    ),
                ),
            );

            parent::__construct( 'blogflux-social-icon', esc_html__('Devs: Social Icon Widget', 'blogflux'), $opts, array(), $fields );

        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget( $args, $instance ){

            $params = $this->get_params( $instance );

            echo $args['before_widget'];

            $display_style = isset( $params['display_style'] ) ? $params['display_style'] : '';

            blogflux_social_icon( $display_style, $social_label = true );
            
            echo $args['after_widget'];
        }

    }

endif;