<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Blogflux
 */

if ( ! function_exists( 'blogflux_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function blogflux_posted_on( $title = true ) {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);

		$year = get_the_date('Y');
        $month = get_the_date('m');
        $day = get_the_date('d');
        $link = get_day_link($year, $month, $day);

		if( $title ){
			$posted_on = sprintf(
				/* translators: %s: post date. */
				esc_html_x( 'Posted on %s', 'post date', 'blogflux' ),
				'<a href="' . esc_url( $link ) . '" rel="bookmark">' . $time_string . '</a>'
			);
		}else{
			$posted_on = '<a href="' . esc_url( $link ) . '" rel="bookmark">' . $time_string . '</a>';
		}

		echo '<span class="posted-on" itemprop="datePublished">' . $posted_on . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;

if ( ! function_exists( 'blogflux_posted_by' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function blogflux_posted_by( $title = true, $image = false  ) {

		if( $image ){


	        
	      
	        echo wp_kses_post( get_avatar( get_the_author_meta( 'ID' ) ) );
	      

	      

	        $byline = '<span class="author vcard" itemprop="name"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta('ID') ) ) . '">' .esc_html__('by ','blogflux'). esc_html(get_the_author()) . '</a></span>';

	        echo $byline;

	      


		}else{

			if( $title ){
			
				$byline = sprintf(
					/* translators: %s: post author. */
					esc_html_x( 'by %s', 'post author', 'blogflux' ),
					'<span class="author vcard" itemprop="name"><a class="url fn n" itemprop="url" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
				);

			}else{

				$byline = '<span class="author vcard" itemprop="name"><a class="url fn n" itemprop="url" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>';

		    }

		    echo '<span class="byline" itemprop="author" itemscope itemtype="https://schema.org/Person"> ' . $byline . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		    
		}

	}
endif;

if ( ! function_exists( 'blogflux_entry_cat' ) ) :

	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */

	function blogflux_entry_cat() {

		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {

			/* translators: used between list items, there is a space after the comma */
            $categories = get_the_category();
            if ($categories) {

            
                /* translators: 1: list of categories. */
            
                
                    foreach( $categories as $category ){

                        $cat_name = $category->name;
                        $cat_slug = $category->slug;
                        $cat_url = get_category_link( $category->term_id ); ?>

                        <a href="<?php echo esc_url( $cat_url ); ?>" rel="category tag">
                            <?php echo esc_html( $cat_name ); ?>
                        </a>

                    <?php }
              

            }

		}

	}

endif;

if ( ! function_exists( 'blogflux_entry_tag' ) ) :

	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */

	function blogflux_entry_tag() {

		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {

			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list('', esc_html__(',', 'blogflux'));
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<div class="entry-meta entry-meta-tags hidden-xs-screen">'. blogflux_get_theme_svg( 'tag',true ).esc_html__( 'Tagged', 'blogflux' ) .esc_html__( '%1$s', 'blogflux' ) .'</div>', $tags_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}

		}

	}

endif;

if ( ! function_exists( 'blogflux_post_thumbnail' ) ) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function blogflux_post_thumbnail( $size = 'post-thumbnail', $else = true ) {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( $else && is_singular() ) :
			?>

			<div class="post-thumbnail">
				<?php the_post_thumbnail(); ?>
			</div><!-- .post-thumbnail -->

		<?php else : ?>

			<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
				<?php
					the_post_thumbnail(
						$size,
						array(
							'alt' => the_title_attribute(
								array(
									'echo' => false,
								)
							),
							'itemprop' => 'image'
						)
					);
				?>
			</a>

			<?php
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'wp_body_open' ) ) :
	/**
	 * Shim for sites older than 5.2.
	 *
	 * @link https://core.trac.wordpress.org/ticket/12563
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
endif;
