<?php
/**
* Sidebar Metabox.
*
* @package Blogflux
*/
 
add_action( 'add_meta_boxes', 'blogflux_metabox' );

if( ! function_exists( 'blogflux_metabox' ) ):


    function  blogflux_metabox() {
        
        add_meta_box(
            'theme-custom-metabox',
            esc_html__( 'Sidebar Settings', 'blogflux' ),
            'blogflux_post_metafield_callback',
            'post', 
            'side', 
            'high'
        );
        add_meta_box(
            'theme-custom-metabox',
            esc_html__( 'Sidebar Settings', 'blogflux' ),
            'blogflux_post_metafield_callback',
            'page',
            'side', 
            'high'
        ); 
    }

endif;

$blogflux_post_sidebar_fields =  blogflux_sidebar_options();


/**
 * Callback function for post option.
*/
if( ! function_exists( 'blogflux_post_metafield_callback' ) ):
    
    function blogflux_post_metafield_callback() {
        global $post, $blogflux_post_sidebar_fields;
        $post_type = get_post_type($post->ID);
        wp_nonce_field( basename( __FILE__ ), 'blogflux_post_meta_nonce' ); ?>
        
        <div class="wedevs-meta-wrap">
            <?php
            $blogflux_post_sidebar = esc_html( get_post_meta( $post->ID, 'blogflux_post_sidebar_option', true ) ); 
            if( $blogflux_post_sidebar == '' ){ $blogflux_post_sidebar = 'right-sidebar'; }

            foreach ( $blogflux_post_sidebar_fields as $key => $blogflux_post_sidebar_field) { ?>

                <div class="components-panel__row">
                    <div class="components-base-control__field">
                        <div class="components-base-control">
                        
                            <span class="components-checkbox-control__input-container">
                                <input type="radio" name="blogflux_post_sidebar_option" value="<?php echo esc_attr( $key ); ?>" <?php if( $key == $blogflux_post_sidebar ){ echo "checked='checked'";} if( empty( $blogflux_post_sidebar ) && $key =='right-sidebar' ){ echo "checked='checked'"; } ?>/>
                            </span>

                            <label class="components-checkbox-control__label">
                                <?php echo esc_html( $blogflux_post_sidebar_field); ?>
                            </label>

                        </div>
                    </div>
                </div>

            <?php } ?>

        </div>

    <?php
    }
endif;

// Save metabox value.
add_action( 'save_post', 'blogflux_save_post_meta' );

if( ! function_exists( 'blogflux_save_post_meta' ) ):

    function blogflux_save_post_meta( $post_id ) {

        global $post;

        if ( !isset( $_POST[ 'blogflux_post_meta_nonce' ] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['blogflux_post_meta_nonce'] ) ), basename( __FILE__ ) ) ){
            return;
        }

        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ){
            return;
        }
            
        if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {  
            if ( !current_user_can( 'edit_page', $post_id ) ){  
                return $post_id;
            }
        }elseif( !current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }

        $blogflux_post_sidebar_option_old = esc_html( get_post_meta( $post_id, 'blogflux_post_sidebar_option', true ) ); 
        $blogflux_post_sidebar_option_new = isset( $_POST['blogflux_post_sidebar_option'] ) ? blogflux_sanitize_sidebar_option_meta( wp_unslash( $_POST['blogflux_post_sidebar_option'] ) ) : '';

        if ( $blogflux_post_sidebar_option_new && $blogflux_post_sidebar_option_new != $blogflux_post_sidebar_option_old ){
            update_post_meta ( $post_id, 'blogflux_post_sidebar_option', $blogflux_post_sidebar_option_new );
        }elseif( '' == $blogflux_post_sidebar_option_new && $blogflux_post_sidebar_option_old ) {
            delete_post_meta( $post_id,'blogflux_post_sidebar_option', $blogflux_post_sidebar_option_old );
        }
        
    }

endif;   