<?php
/**
 * Featured Category Section.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_gallery_section') ) :

    function blogflux_gallery_section(){

        $blogflux_default = blogflux_get_default_theme_options();
        $enable_gallery_slider = get_theme_mod( 'enable_gallery_slider', $blogflux_default['enable_gallery_slider'] );
        $gallery_section_title = get_theme_mod( 'gallery_section_title' );
        $gallery_section_sub_title = get_theme_mod( 'gallery_section_sub_title');
        $gallery_section_link = get_theme_mod( 'gallery_section_link');
        $gallery_link_text = get_theme_mod( 'gallery_link_text');

        if( $enable_gallery_slider ){

         ?>
            <section class="wedevs-social-images wedevs-block">
                <?php if (!empty($gallery_section_title) || !empty($gallery_section_sub_title)) { ?>
                    <div class="site-wrapper">
                        <div class="site-row">
                            <div class="site-column site-column-12">
                                <div class="wedevs-section-head text-center mb-48">
                                    <?php if (!empty($gallery_section_title)) { ?>
                                        <h2 class="font-size-big mb-8">
                                            <?php echo esc_html($gallery_section_title); ?>
                                        </h2>
                                    <?php } ?>
                                    <?php if (!empty($gallery_section_sub_title)) { ?>
                                    <p class = "m-0">
                                        <?php echo esc_html($gallery_section_sub_title); ?>
                                        <a href="<?php echo esc_url($gallery_section_link); ?>"> <?php echo esc_html($gallery_link_text); ?> </a>
                                    </p>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <div class="social-images-container">
                    <?php
                    for( $i = 1; $i <= 8; $i++  ){
                    $gallery_section_image = get_theme_mod('gallery_image_section_'.$i); ?>
                        <?php if (!empty($gallery_section_image)) { ?>
                            <div class="image-size-small wedevs-optimize-image">
                                <a href="<?php echo esc_url($gallery_section_image); ?>">
                                    <img src="<?php echo esc_url($gallery_section_image); ?>" alt="">
                                </a>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
            </section>
        <?php
        }

    }

endif;