<?php
/**
 * Typography Functions.
 *
 * @package blogflux
 */

add_action('wp_ajax_blogflux_fonts_ajax', 'blogflux_fonts_ajax_cb');
add_action('wp_ajax_nopriv_blogflux_fonts_ajax', 'blogflux_fonts_ajax_cb');

if( !function_exists('blogflux_fonts_ajax_cb') ):

    // Recommendec Post Ajax Call Function.
    function blogflux_fonts_ajax_cb() {

        $family = isset( $_POST['family'] ) ? sanitize_text_field( $_POST['family'] ) : '';
        $arr = blogflux_font_array();
        $key = array_search($family, array_column($arr, 'family'));

        $variants = $arr[$key]['variants'];
        if( $variants ){
            $i = 1;
            foreach( $variants as $key => $value ){

                echo "<option value='".$key."'>".$value."</option>";
                $i++;
            }
        }
    }

endif;

if( !function_exists('blogflux_fonts_variants') ):

    // Recommendec Post Ajax Call Function.
    function blogflux_fonts_variants( $font_family = '' ) {

        $arr = blogflux_font_array();
        $key = array_search($font_family, array_column($arr, 'family'));
        $variants_lists = '';
        $key;
        $variants = $arr[$key]['variants'];
        if( $variants ){
            foreach( $variants as $value ){

                $variants_lists .= $value.',';
            }
        }

        return $variants_lists;

    }

endif;

if( !function_exists('blogflux_google_fonts') ):

    function blogflux_google_fonts(){

        $google_fonts = blogflux_font_array();
        foreach ($google_fonts as $key => $value) {
            $google_font[$value['family']] =  $value['family'] ;
        }
        return( $google_font );
    }

endif;

if( !function_exists('blogflux_font_array') ):

    function blogflux_font_array() {

        /* Google font listing in to database */
        $font_decoded = '[{"family":"ABeeZee","variants":{"regular":"regular","italic":"italic"}},{"family":"Abel","variants":{"regular":"regular"}},{"family":"Abhaya Libre","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Abril Fatface","variants":{"regular":"regular"}},{"family":"Aclonica","variants":{"regular":"regular"}},{"family":"Acme","variants":{"regular":"regular"}},{"family":"Actor","variants":{"regular":"regular"}},{"family":"Adamina","variants":{"regular":"regular"}},{"family":"Advent Pro","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Aguafina Script","variants":{"regular":"regular"}},{"family":"Akaya Kanadaka","variants":{"regular":"regular"}},{"family":"Akaya Telivigala","variants":{"regular":"regular"}},{"family":"Akronim","variants":{"regular":"regular"}},{"family":"Aladin","variants":{"regular":"regular"}},{"family":"Alata","variants":{"regular":"regular"}},{"family":"Alatsi","variants":{"regular":"regular"}},{"family":"Aldrich","variants":{"regular":"regular"}},{"family":"Alef","variants":{"regular":"regular","700":"700"}},{"family":"Alegreya","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Alegreya SC","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Alegreya Sans","variants":{"100":"100","100italic":"100italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Alegreya Sans SC","variants":{"100":"100","100italic":"100italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Aleo","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Alex Brush","variants":{"regular":"regular"}},{"family":"Alfa Slab One","variants":{"regular":"regular"}},{"family":"Alice","variants":{"regular":"regular"}},{"family":"Alike","variants":{"regular":"regular"}},{"family":"Alike Angular","variants":{"regular":"regular"}},{"family":"Allan","variants":{"regular":"regular","700":"700"}},{"family":"Allerta","variants":{"regular":"regular"}},{"family":"Allerta Stencil","variants":{"regular":"regular"}},{"family":"Allura","variants":{"regular":"regular"}},{"family":"Almarai","variants":{"300":"300","regular":"regular","700":"700","800":"800"}},{"family":"Almendra","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Almendra Display","variants":{"regular":"regular"}},{"family":"Almendra SC","variants":{"regular":"regular"}},{"family":"Amarante","variants":{"regular":"regular"}},{"family":"Amaranth","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Amatic SC","variants":{"regular":"regular","700":"700"}},{"family":"Amethysta","variants":{"regular":"regular"}},{"family":"Amiko","variants":{"regular":"regular","600":"600","700":"700"}},{"family":"Amiri","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Amita","variants":{"regular":"regular","700":"700"}},{"family":"Anaheim","variants":{"regular":"regular"}},{"family":"Andada","variants":{"regular":"regular"}},{"family":"Andika","variants":{"regular":"regular"}},{"family":"Andika New Basic","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Angkor","variants":{"regular":"regular"}},{"family":"Annie Use Your Telescope","variants":{"regular":"regular"}},{"family":"Anonymous Pro","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Antic","variants":{"regular":"regular"}},{"family":"Antic Didone","variants":{"regular":"regular"}},{"family":"Antic Slab","variants":{"regular":"regular"}},{"family":"Anton","variants":{"regular":"regular"}},{"family":"Antonio","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Arapey","variants":{"regular":"regular","italic":"italic"}},{"family":"Arbutus","variants":{"regular":"regular"}},{"family":"Arbutus Slab","variants":{"regular":"regular"}},{"family":"Architects Daughter","variants":{"regular":"regular"}},{"family":"Archivo","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Archivo Black","variants":{"regular":"regular"}},{"family":"Archivo Narrow","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Aref Ruqaa","variants":{"regular":"regular","700":"700"}},{"family":"Arima Madurai","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","700":"700","800":"800","900":"900"}},{"family":"Arimo","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Arizonia","variants":{"regular":"regular"}},{"family":"Armata","variants":{"regular":"regular"}},{"family":"Arsenal","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Artifika","variants":{"regular":"regular"}},{"family":"Arvo","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Arya","variants":{"regular":"regular","700":"700"}},{"family":"Asap","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Asap Condensed","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Asar","variants":{"regular":"regular"}},{"family":"Asset","variants":{"regular":"regular"}},{"family":"Assistant","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Astloch","variants":{"regular":"regular","700":"700"}},{"family":"Asul","variants":{"regular":"regular","700":"700"}},{"family":"Athiti","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Atma","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Atomic Age","variants":{"regular":"regular"}},{"family":"Aubrey","variants":{"regular":"regular"}},{"family":"Audiowide","variants":{"regular":"regular"}},{"family":"Autour One","variants":{"regular":"regular"}},{"family":"Average","variants":{"regular":"regular"}},{"family":"Average Sans","variants":{"regular":"regular"}},{"family":"Averia Gruesa Libre","variants":{"regular":"regular"}},{"family":"Averia Libre","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Averia Sans Libre","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Averia Serif Libre","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"B612","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"B612 Mono","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Bad Script","variants":{"regular":"regular"}},{"family":"Bahiana","variants":{"regular":"regular"}},{"family":"Bahianita","variants":{"regular":"regular"}},{"family":"Bai Jamjuree","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Ballet","variants":{"regular":"regular"}},{"family":"Baloo 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Bhai 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Bhaina 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Chettan 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Da 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Paaji 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Tamma 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Tammudu 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Baloo Thambi 2","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Balsamiq Sans","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Balthazar","variants":{"regular":"regular"}},{"family":"Bangers","variants":{"regular":"regular"}},{"family":"Barlow","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Barlow Condensed","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Barlow Semi Condensed","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Barriecito","variants":{"regular":"regular"}},{"family":"Barrio","variants":{"regular":"regular"}},{"family":"Basic","variants":{"regular":"regular"}},{"family":"Baskervville","variants":{"regular":"regular","italic":"italic"}},{"family":"Battambang","variants":{"regular":"regular","700":"700"}},{"family":"Baumans","variants":{"regular":"regular"}},{"family":"Bayon","variants":{"regular":"regular"}},{"family":"Be Vietnam","variants":{"100":"100","100italic":"100italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Bebas Neue","variants":{"regular":"regular"}},{"family":"Belgrano","variants":{"regular":"regular"}},{"family":"Bellefair","variants":{"regular":"regular"}},{"family":"Belleza","variants":{"regular":"regular"}},{"family":"Bellota","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Bellota Text","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"BenchNine","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Benne","variants":{"regular":"regular"}},{"family":"Bentham","variants":{"regular":"regular"}},{"family":"Berkshire Swash","variants":{"regular":"regular"}},{"family":"Beth Ellen","variants":{"regular":"regular"}},{"family":"Bevan","variants":{"regular":"regular"}},{"family":"Big Shoulders Display","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Big Shoulders Inline Display","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Big Shoulders Inline Text","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Big Shoulders Stencil Display","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Big Shoulders Stencil Text","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Big Shoulders Text","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Bigelow Rules","variants":{"regular":"regular"}},{"family":"Bigshot One","variants":{"regular":"regular"}},{"family":"Bilbo","variants":{"regular":"regular"}},{"family":"Bilbo Swash Caps","variants":{"regular":"regular"}},{"family":"BioRhyme","variants":{"200":"200","300":"300","regular":"regular","700":"700","800":"800"}},{"family":"BioRhyme Expanded","variants":{"200":"200","300":"300","regular":"regular","700":"700","800":"800"}},{"family":"Biryani","variants":{"200":"200","300":"300","regular":"regular","600":"600","700":"700","800":"800","900":"900"}},{"family":"Bitter","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Black And White Picture","variants":{"regular":"regular"}},{"family":"Black Han Sans","variants":{"regular":"regular"}},{"family":"Black Ops One","variants":{"regular":"regular"}},{"family":"Blinker","variants":{"100":"100","200":"200","300":"300","regular":"regular","600":"600","700":"700","800":"800","900":"900"}},{"family":"Bodoni Moda","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Bokor","variants":{"regular":"regular"}},{"family":"Bona Nova","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Bonbon","variants":{"regular":"regular"}},{"family":"Boogaloo","variants":{"regular":"regular"}},{"family":"Bowlby One","variants":{"regular":"regular"}},{"family":"Bowlby One SC","variants":{"regular":"regular"}},{"family":"Brawler","variants":{"regular":"regular"}},{"family":"Bree Serif","variants":{"regular":"regular"}},{"family":"Brygada 1918","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Bubblegum Sans","variants":{"regular":"regular"}},{"family":"Bubbler One","variants":{"regular":"regular"}},{"family":"Buda","variants":{"300":"300"}},{"family":"Buenard","variants":{"regular":"regular","700":"700"}},{"family":"Bungee","variants":{"regular":"regular"}},{"family":"Bungee Hairline","variants":{"regular":"regular"}},{"family":"Bungee Inline","variants":{"regular":"regular"}},{"family":"Bungee Outline","variants":{"regular":"regular"}},{"family":"Bungee Shade","variants":{"regular":"regular"}},{"family":"Butcherman","variants":{"regular":"regular"}},{"family":"Butterfly Kids","variants":{"regular":"regular"}},{"family":"Cabin","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Cabin Condensed","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Cabin Sketch","variants":{"regular":"regular","700":"700"}},{"family":"Caesar Dressing","variants":{"regular":"regular"}},{"family":"Cagliostro","variants":{"regular":"regular"}},{"family":"Cairo","variants":{"200":"200","300":"300","regular":"regular","600":"600","700":"700","900":"900"}},{"family":"Caladea","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Calistoga","variants":{"regular":"regular"}},{"family":"Calligraffitti","variants":{"regular":"regular"}},{"family":"Cambay","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Cambo","variants":{"regular":"regular"}},{"family":"Candal","variants":{"regular":"regular"}},{"family":"Cantarell","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Cantata One","variants":{"regular":"regular"}},{"family":"Cantora One","variants":{"regular":"regular"}},{"family":"Capriola","variants":{"regular":"regular"}},{"family":"Cardo","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Carme","variants":{"regular":"regular"}},{"family":"Carrois Gothic","variants":{"regular":"regular"}},{"family":"Carrois Gothic SC","variants":{"regular":"regular"}},{"family":"Carter One","variants":{"regular":"regular"}},{"family":"Castoro","variants":{"regular":"regular","italic":"italic"}},{"family":"Catamaran","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Caudex","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Caveat","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Caveat Brush","variants":{"regular":"regular"}},{"family":"Cedarville Cursive","variants":{"regular":"regular"}},{"family":"Ceviche One","variants":{"regular":"regular"}},{"family":"Chakra Petch","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Changa","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Changa One","variants":{"regular":"regular","italic":"italic"}},{"family":"Chango","variants":{"regular":"regular"}},{"family":"Charm","variants":{"regular":"regular","700":"700"}},{"family":"Charmonman","variants":{"regular":"regular","700":"700"}},{"family":"Chathura","variants":{"100":"100","300":"300","regular":"regular","700":"700","800":"800"}},{"family":"Chau Philomene One","variants":{"regular":"regular","italic":"italic"}},{"family":"Chela One","variants":{"regular":"regular"}},{"family":"Chelsea Market","variants":{"regular":"regular"}},{"family":"Chenla","variants":{"regular":"regular"}},{"family":"Cherry Cream Soda","variants":{"regular":"regular"}},{"family":"Cherry Swash","variants":{"regular":"regular","700":"700"}},{"family":"Chewy","variants":{"regular":"regular"}},{"family":"Chicle","variants":{"regular":"regular"}},{"family":"Chilanka","variants":{"regular":"regular"}},{"family":"Chivo","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Chonburi","variants":{"regular":"regular"}},{"family":"Cinzel","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Cinzel Decorative","variants":{"regular":"regular","700":"700","900":"900"}},{"family":"Clicker Script","variants":{"regular":"regular"}},{"family":"Coda","variants":{"regular":"regular","800":"800"}},{"family":"Coda Caption","variants":{"800":"800"}},{"family":"Codystar","variants":{"300":"300","regular":"regular"}},{"family":"Coiny","variants":{"regular":"regular"}},{"family":"Combo","variants":{"regular":"regular"}},{"family":"Comfortaa","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Comic Neue","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Coming Soon","variants":{"regular":"regular"}},{"family":"Commissioner","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Concert One","variants":{"regular":"regular"}},{"family":"Condiment","variants":{"regular":"regular"}},{"family":"Content","variants":{"regular":"regular","700":"700"}},{"family":"Contrail One","variants":{"regular":"regular"}},{"family":"Convergence","variants":{"regular":"regular"}},{"family":"Cookie","variants":{"regular":"regular"}},{"family":"Copse","variants":{"regular":"regular"}},{"family":"Corben","variants":{"regular":"regular","700":"700"}},{"family":"Cormorant","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Cormorant Garamond","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Cormorant Infant","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Cormorant SC","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Cormorant Unicase","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Cormorant Upright","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Courgette","variants":{"regular":"regular"}},{"family":"Courier Prime","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Cousine","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Coustard","variants":{"regular":"regular","900":"900"}},{"family":"Covered By Your Grace","variants":{"regular":"regular"}},{"family":"Crafty Girls","variants":{"regular":"regular"}},{"family":"Creepster","variants":{"regular":"regular"}},{"family":"Crete Round","variants":{"regular":"regular","italic":"italic"}},{"family":"Crimson Pro","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Crimson Text","variants":{"regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Croissant One","variants":{"regular":"regular"}},{"family":"Crushed","variants":{"regular":"regular"}},{"family":"Cuprum","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Cute Font","variants":{"regular":"regular"}},{"family":"Cutive","variants":{"regular":"regular"}},{"family":"Cutive Mono","variants":{"regular":"regular"}},{"family":"DM Mono","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic"}},{"family":"DM Sans","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic"}},{"family":"DM Serif Display","variants":{"regular":"regular","italic":"italic"}},{"family":"DM Serif Text","variants":{"regular":"regular","italic":"italic"}},{"family":"Damion","variants":{"regular":"regular"}},{"family":"Dancing Script","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Dangrek","variants":{"regular":"regular"}},{"family":"Darker Grotesque","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"David Libre","variants":{"regular":"regular","500":"500","700":"700"}},{"family":"Dawning of a New Day","variants":{"regular":"regular"}},{"family":"Days One","variants":{"regular":"regular"}},{"family":"Dekko","variants":{"regular":"regular"}},{"family":"Dela Gothic One","variants":{"regular":"regular"}},{"family":"Delius","variants":{"regular":"regular"}},{"family":"Delius Swash Caps","variants":{"regular":"regular"}},{"family":"Delius Unicase","variants":{"regular":"regular","700":"700"}},{"family":"Della Respira","variants":{"regular":"regular"}},{"family":"Denk One","variants":{"regular":"regular"}},{"family":"Devonshire","variants":{"regular":"regular"}},{"family":"Dhurjati","variants":{"regular":"regular"}},{"family":"Didact Gothic","variants":{"regular":"regular"}},{"family":"Diplomata","variants":{"regular":"regular"}},{"family":"Diplomata SC","variants":{"regular":"regular"}},{"family":"Do Hyeon","variants":{"regular":"regular"}},{"family":"Dokdo","variants":{"regular":"regular"}},{"family":"Domine","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Donegal One","variants":{"regular":"regular"}},{"family":"Doppio One","variants":{"regular":"regular"}},{"family":"Dorsa","variants":{"regular":"regular"}},{"family":"Dosis","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"DotGothic16","variants":{"regular":"regular"}},{"family":"Dr Sugiyama","variants":{"regular":"regular"}},{"family":"Duru Sans","variants":{"regular":"regular"}},{"family":"Dynalight","variants":{"regular":"regular"}},{"family":"EB Garamond","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic"}},{"family":"Eagle Lake","variants":{"regular":"regular"}},{"family":"East Sea Dokdo","variants":{"regular":"regular"}},{"family":"Eater","variants":{"regular":"regular"}},{"family":"Economica","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Eczar","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"El Messiri","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Electrolize","variants":{"regular":"regular"}},{"family":"Elsie","variants":{"regular":"regular","900":"900"}},{"family":"Elsie Swash Caps","variants":{"regular":"regular","900":"900"}},{"family":"Emblema One","variants":{"regular":"regular"}},{"family":"Emilys Candy","variants":{"regular":"regular"}},{"family":"Encode Sans","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Encode Sans Condensed","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Encode Sans Expanded","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Encode Sans SC","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Encode Sans Semi Condensed","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Encode Sans Semi Expanded","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Engagement","variants":{"regular":"regular"}},{"family":"Englebert","variants":{"regular":"regular"}},{"family":"Enriqueta","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Epilogue","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Erica One","variants":{"regular":"regular"}},{"family":"Esteban","variants":{"regular":"regular"}},{"family":"Euphoria Script","variants":{"regular":"regular"}},{"family":"Ewert","variants":{"regular":"regular"}},{"family":"Exo","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Exo 2","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Expletus Sans","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Fahkwang","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Fanwood Text","variants":{"regular":"regular","italic":"italic"}},{"family":"Farro","variants":{"300":"300","regular":"regular","500":"500","700":"700"}},{"family":"Farsan","variants":{"regular":"regular"}},{"family":"Fascinate","variants":{"regular":"regular"}},{"family":"Fascinate Inline","variants":{"regular":"regular"}},{"family":"Faster One","variants":{"regular":"regular"}},{"family":"Fasthand","variants":{"regular":"regular"}},{"family":"Fauna One","variants":{"regular":"regular"}},{"family":"Faustina","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Federant","variants":{"regular":"regular"}},{"family":"Federo","variants":{"regular":"regular"}},{"family":"Felipa","variants":{"regular":"regular"}},{"family":"Fenix","variants":{"regular":"regular"}},{"family":"Festive","variants":{"regular":"regular"}},{"family":"Finger Paint","variants":{"regular":"regular"}},{"family":"Fira Code","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Fira Mono","variants":{"regular":"regular","500":"500","700":"700"}},{"family":"Fira Sans","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Fira Sans Condensed","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Fira Sans Extra Condensed","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Fjalla One","variants":{"regular":"regular"}},{"family":"Fjord One","variants":{"regular":"regular"}},{"family":"Flamenco","variants":{"300":"300","regular":"regular"}},{"family":"Flavors","variants":{"regular":"regular"}},{"family":"Fondamento","variants":{"regular":"regular","italic":"italic"}},{"family":"Fontdiner Swanky","variants":{"regular":"regular"}},{"family":"Forum","variants":{"regular":"regular"}},{"family":"Francois One","variants":{"regular":"regular"}},{"family":"Frank Ruhl Libre","variants":{"300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Fraunces","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Freckle Face","variants":{"regular":"regular"}},{"family":"Fredericka the Great","variants":{"regular":"regular"}},{"family":"Fredoka One","variants":{"regular":"regular"}},{"family":"Freehand","variants":{"regular":"regular"}},{"family":"Fresca","variants":{"regular":"regular"}},{"family":"Frijole","variants":{"regular":"regular"}},{"family":"Fruktur","variants":{"regular":"regular"}},{"family":"Fugaz One","variants":{"regular":"regular"}},{"family":"Fuggles","variants":{"regular":"regular"}},{"family":"GFS Didot","variants":{"regular":"regular"}},{"family":"GFS Neohellenic","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Gabriela","variants":{"regular":"regular"}},{"family":"Gaegu","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Gafata","variants":{"regular":"regular"}},{"family":"Galada","variants":{"regular":"regular"}},{"family":"Galdeano","variants":{"regular":"regular"}},{"family":"Galindo","variants":{"regular":"regular"}},{"family":"Gamja Flower","variants":{"regular":"regular"}},{"family":"Gayathri","variants":{"100":"100","regular":"regular","700":"700"}},{"family":"Gelasio","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Gentium Basic","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Gentium Book Basic","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Geo","variants":{"regular":"regular","italic":"italic"}},{"family":"Geostar","variants":{"regular":"regular"}},{"family":"Geostar Fill","variants":{"regular":"regular"}},{"family":"Germania One","variants":{"regular":"regular"}},{"family":"Gidugu","variants":{"regular":"regular"}},{"family":"Gilda Display","variants":{"regular":"regular"}},{"family":"Girassol","variants":{"regular":"regular"}},{"family":"Give You Glory","variants":{"regular":"regular"}},{"family":"Glass Antiqua","variants":{"regular":"regular"}},{"family":"Glegoo","variants":{"regular":"regular","700":"700"}},{"family":"Gloria Hallelujah","variants":{"regular":"regular"}},{"family":"Goblin One","variants":{"regular":"regular"}},{"family":"Gochi Hand","variants":{"regular":"regular"}},{"family":"Goldman","variants":{"regular":"regular","700":"700"}},{"family":"Gorditas","variants":{"regular":"regular","700":"700"}},{"family":"Gothic A1","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Gotu","variants":{"regular":"regular"}},{"family":"Goudy Bookletter 1911","variants":{"regular":"regular"}},{"family":"Graduate","variants":{"regular":"regular"}},{"family":"Grand Hotel","variants":{"regular":"regular"}},{"family":"Grandstander","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Gravitas One","variants":{"regular":"regular"}},{"family":"Great Vibes","variants":{"regular":"regular"}},{"family":"Grenze","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Grenze Gotisch","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Griffy","variants":{"regular":"regular"}},{"family":"Gruppo","variants":{"regular":"regular"}},{"family":"Gudea","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Gugi","variants":{"regular":"regular"}},{"family":"Gupter","variants":{"regular":"regular","500":"500","700":"700"}},{"family":"Gurajada","variants":{"regular":"regular"}},{"family":"Habibi","variants":{"regular":"regular"}},{"family":"Hachi Maru Pop","variants":{"regular":"regular"}},{"family":"Halant","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Hammersmith One","variants":{"regular":"regular"}},{"family":"Hanalei","variants":{"regular":"regular"}},{"family":"Hanalei Fill","variants":{"regular":"regular"}},{"family":"Handlee","variants":{"regular":"regular"}},{"family":"Hanuman","variants":{"regular":"regular","700":"700"}},{"family":"Happy Monkey","variants":{"regular":"regular"}},{"family":"Harmattan","variants":{"regular":"regular","700":"700"}},{"family":"Headland One","variants":{"regular":"regular"}},{"family":"Heebo","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Henny Penny","variants":{"regular":"regular"}},{"family":"Hepta Slab","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Herr Von Muellerhoff","variants":{"regular":"regular"}},{"family":"Hi Melody","variants":{"regular":"regular"}},{"family":"Hind","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Hind Guntur","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Hind Madurai","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Hind Siliguri","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Hind Vadodara","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Holtwood One SC","variants":{"regular":"regular"}},{"family":"Homemade Apple","variants":{"regular":"regular"}},{"family":"Homenaje","variants":{"regular":"regular"}},{"family":"IBM Plex Mono","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"IBM Plex Sans","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"IBM Plex Sans Condensed","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"IBM Plex Serif","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"IM Fell DW Pica","variants":{"regular":"regular","italic":"italic"}},{"family":"IM Fell DW Pica SC","variants":{"regular":"regular"}},{"family":"IM Fell Double Pica","variants":{"regular":"regular","italic":"italic"}},{"family":"IM Fell Double Pica SC","variants":{"regular":"regular"}},{"family":"IM Fell English","variants":{"regular":"regular","italic":"italic"}},{"family":"IM Fell English SC","variants":{"regular":"regular"}},{"family":"IM Fell French Canon","variants":{"regular":"regular","italic":"italic"}},{"family":"IM Fell French Canon SC","variants":{"regular":"regular"}},{"family":"IM Fell Great Primer","variants":{"regular":"regular","italic":"italic"}},{"family":"IM Fell Great Primer SC","variants":{"regular":"regular"}},{"family":"Ibarra Real Nova","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Iceberg","variants":{"regular":"regular"}},{"family":"Iceland","variants":{"regular":"regular"}},{"family":"Imbue","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Imprima","variants":{"regular":"regular"}},{"family":"Inconsolata","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Inder","variants":{"regular":"regular"}},{"family":"Indie Flower","variants":{"regular":"regular"}},{"family":"Inika","variants":{"regular":"regular","700":"700"}},{"family":"Inknut Antiqua","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Inria Sans","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Inria Serif","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Inter","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Irish Grover","variants":{"regular":"regular"}},{"family":"Istok Web","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Italiana","variants":{"regular":"regular"}},{"family":"Italianno","variants":{"regular":"regular"}},{"family":"Itim","variants":{"regular":"regular"}},{"family":"Jacques Francois","variants":{"regular":"regular"}},{"family":"Jacques Francois Shadow","variants":{"regular":"regular"}},{"family":"Jaldi","variants":{"regular":"regular","700":"700"}},{"family":"JetBrains Mono","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic"}},{"family":"Jim Nightshade","variants":{"regular":"regular"}},{"family":"Jockey One","variants":{"regular":"regular"}},{"family":"Jolly Lodger","variants":{"regular":"regular"}},{"family":"Jomhuria","variants":{"regular":"regular"}},{"family":"Jomolhari","variants":{"regular":"regular"}},{"family":"Josefin Sans","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Josefin Slab","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Jost","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Joti One","variants":{"regular":"regular"}},{"family":"Jua","variants":{"regular":"regular"}},{"family":"Judson","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Julee","variants":{"regular":"regular"}},{"family":"Julius Sans One","variants":{"regular":"regular"}},{"family":"Junge","variants":{"regular":"regular"}},{"family":"Jura","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Just Another Hand","variants":{"regular":"regular"}},{"family":"Just Me Again Down Here","variants":{"regular":"regular"}},{"family":"K2D","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Kadwa","variants":{"regular":"regular","700":"700"}},{"family":"Kalam","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Kameron","variants":{"regular":"regular","700":"700"}},{"family":"Kanit","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Kantumruy","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Karantina","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Karla","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic"}},{"family":"Karma","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Katibeh","variants":{"regular":"regular"}},{"family":"Kaushan Script","variants":{"regular":"regular"}},{"family":"Kavivanar","variants":{"regular":"regular"}},{"family":"Kavoon","variants":{"regular":"regular"}},{"family":"Kdam Thmor","variants":{"regular":"regular"}},{"family":"Keania One","variants":{"regular":"regular"}},{"family":"Kelly Slab","variants":{"regular":"regular"}},{"family":"Kenia","variants":{"regular":"regular"}},{"family":"Khand","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Khmer","variants":{"regular":"regular"}},{"family":"Khula","variants":{"300":"300","regular":"regular","600":"600","700":"700","800":"800"}},{"family":"Kirang Haerang","variants":{"regular":"regular"}},{"family":"Kite One","variants":{"regular":"regular"}},{"family":"Kiwi Maru","variants":{"300":"300","regular":"regular","500":"500"}},{"family":"Knewave","variants":{"regular":"regular"}},{"family":"KoHo","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Kodchasan","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Kosugi","variants":{"regular":"regular"}},{"family":"Kosugi Maru","variants":{"regular":"regular"}},{"family":"Kotta One","variants":{"regular":"regular"}},{"family":"Koulen","variants":{"regular":"regular"}},{"family":"Kranky","variants":{"regular":"regular"}},{"family":"Kreon","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Kristi","variants":{"regular":"regular"}},{"family":"Krona One","variants":{"regular":"regular"}},{"family":"Krub","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Kufam","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Kulim Park","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Kumar One","variants":{"regular":"regular"}},{"family":"Kumar One Outline","variants":{"regular":"regular"}},{"family":"Kumbh Sans","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Kurale","variants":{"regular":"regular"}},{"family":"La Belle Aurore","variants":{"regular":"regular"}},{"family":"Lacquer","variants":{"regular":"regular"}},{"family":"Laila","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Lakki Reddy","variants":{"regular":"regular"}},{"family":"Lalezar","variants":{"regular":"regular"}},{"family":"Lancelot","variants":{"regular":"regular"}},{"family":"Langar","variants":{"regular":"regular"}},{"family":"Lateef","variants":{"regular":"regular"}},{"family":"Lato","variants":{"100":"100","100italic":"100italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"League Script","variants":{"regular":"regular"}},{"family":"Leckerli One","variants":{"regular":"regular"}},{"family":"Ledger","variants":{"regular":"regular"}},{"family":"Lekton","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Lemon","variants":{"regular":"regular"}},{"family":"Lemonada","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Lexend","variants":{"100":"100","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Lexend Deca","variants":{"regular":"regular"}},{"family":"Lexend Exa","variants":{"regular":"regular"}},{"family":"Lexend Giga","variants":{"regular":"regular"}},{"family":"Lexend Mega","variants":{"regular":"regular"}},{"family":"Lexend Peta","variants":{"regular":"regular"}},{"family":"Lexend Tera","variants":{"regular":"regular"}},{"family":"Lexend Zetta","variants":{"regular":"regular"}},{"family":"Libre Barcode 128","variants":{"regular":"regular"}},{"family":"Libre Barcode 128 Text","variants":{"regular":"regular"}},{"family":"Libre Barcode 39","variants":{"regular":"regular"}},{"family":"Libre Barcode 39 Extended","variants":{"regular":"regular"}},{"family":"Libre Barcode 39 Extended Text","variants":{"regular":"regular"}},{"family":"Libre Barcode 39 Text","variants":{"regular":"regular"}},{"family":"Libre Barcode EAN13 Text","variants":{"regular":"regular"}},{"family":"Libre Baskerville","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Libre Caslon Display","variants":{"regular":"regular"}},{"family":"Libre Caslon Text","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Libre Franklin","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Life Savers","variants":{"regular":"regular","700":"700","800":"800"}},{"family":"Lilita One","variants":{"regular":"regular"}},{"family":"Lily Script One","variants":{"regular":"regular"}},{"family":"Limelight","variants":{"regular":"regular"}},{"family":"Linden Hill","variants":{"regular":"regular","italic":"italic"}},{"family":"Literata","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Liu Jian Mao Cao","variants":{"regular":"regular"}},{"family":"Livvic","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Lobster","variants":{"regular":"regular"}},{"family":"Lobster Two","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Londrina Outline","variants":{"regular":"regular"}},{"family":"Londrina Shadow","variants":{"regular":"regular"}},{"family":"Londrina Sketch","variants":{"regular":"regular"}},{"family":"Londrina Solid","variants":{"100":"100","300":"300","regular":"regular","900":"900"}},{"family":"Long Cang","variants":{"regular":"regular"}},{"family":"Lora","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Love Ya Like A Sister","variants":{"regular":"regular"}},{"family":"Loved by the King","variants":{"regular":"regular"}},{"family":"Lovers Quarrel","variants":{"regular":"regular"}},{"family":"Luckiest Guy","variants":{"regular":"regular"}},{"family":"Lusitana","variants":{"regular":"regular","700":"700"}},{"family":"Lustria","variants":{"regular":"regular"}},{"family":"M PLUS 1p","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","800":"800","900":"900"}},{"family":"M PLUS Rounded 1c","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","800":"800","900":"900"}},{"family":"Ma Shan Zheng","variants":{"regular":"regular"}},{"family":"Macondo","variants":{"regular":"regular"}},{"family":"Macondo Swash Caps","variants":{"regular":"regular"}},{"family":"Mada","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","900":"900"}},{"family":"Magra","variants":{"regular":"regular","700":"700"}},{"family":"Maiden Orange","variants":{"regular":"regular"}},{"family":"Maitree","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Major Mono Display","variants":{"regular":"regular"}},{"family":"Mako","variants":{"regular":"regular"}},{"family":"Mali","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Mallanna","variants":{"regular":"regular"}},{"family":"Mandali","variants":{"regular":"regular"}},{"family":"Manjari","variants":{"100":"100","regular":"regular","700":"700"}},{"family":"Manrope","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Mansalva","variants":{"regular":"regular"}},{"family":"Manuale","variants":{"regular":"regular","500":"500","600":"600","700":"700","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Marcellus","variants":{"regular":"regular"}},{"family":"Marcellus SC","variants":{"regular":"regular"}},{"family":"Marck Script","variants":{"regular":"regular"}},{"family":"Margarine","variants":{"regular":"regular"}},{"family":"Markazi Text","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Marko One","variants":{"regular":"regular"}},{"family":"Marmelad","variants":{"regular":"regular"}},{"family":"Martel","variants":{"200":"200","300":"300","regular":"regular","600":"600","700":"700","800":"800","900":"900"}},{"family":"Martel Sans","variants":{"200":"200","300":"300","regular":"regular","600":"600","700":"700","800":"800","900":"900"}},{"family":"Marvel","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Mate","variants":{"regular":"regular","italic":"italic"}},{"family":"Mate SC","variants":{"regular":"regular"}},{"family":"Maven Pro","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"McLaren","variants":{"regular":"regular"}},{"family":"Meddon","variants":{"regular":"regular"}},{"family":"MedievalSharp","variants":{"regular":"regular"}},{"family":"Medula One","variants":{"regular":"regular"}},{"family":"Meera Inimai","variants":{"regular":"regular"}},{"family":"Megrim","variants":{"regular":"regular"}},{"family":"Meie Script","variants":{"regular":"regular"}},{"family":"Merienda","variants":{"regular":"regular","700":"700"}},{"family":"Merienda One","variants":{"regular":"regular"}},{"family":"Merriweather","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Merriweather Sans","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic"}},{"family":"Metal","variants":{"regular":"regular"}},{"family":"Metal Mania","variants":{"regular":"regular"}},{"family":"Metamorphous","variants":{"regular":"regular"}},{"family":"Metrophobic","variants":{"regular":"regular"}},{"family":"Michroma","variants":{"regular":"regular"}},{"family":"Milonga","variants":{"regular":"regular"}},{"family":"Miltonian","variants":{"regular":"regular"}},{"family":"Miltonian Tattoo","variants":{"regular":"regular"}},{"family":"Mina","variants":{"regular":"regular","700":"700"}},{"family":"Miniver","variants":{"regular":"regular"}},{"family":"Miriam Libre","variants":{"regular":"regular","700":"700"}},{"family":"Mirza","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Miss Fajardose","variants":{"regular":"regular"}},{"family":"Mitr","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Modak","variants":{"regular":"regular"}},{"family":"Modern Antiqua","variants":{"regular":"regular"}},{"family":"Mogra","variants":{"regular":"regular"}},{"family":"Molengo","variants":{"regular":"regular"}},{"family":"Molle","variants":{"italic":"italic"}},{"family":"Monda","variants":{"regular":"regular","700":"700"}},{"family":"Monofett","variants":{"regular":"regular"}},{"family":"Monoton","variants":{"regular":"regular"}},{"family":"Monsieur La Doulaise","variants":{"regular":"regular"}},{"family":"Montaga","variants":{"regular":"regular"}},{"family":"Montez","variants":{"regular":"regular"}},{"family":"Montserrat","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Montserrat Alternates","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Montserrat Subrayada","variants":{"regular":"regular","700":"700"}},{"family":"Moul","variants":{"regular":"regular"}},{"family":"Moulpali","variants":{"regular":"regular"}},{"family":"Mountains of Christmas","variants":{"regular":"regular","700":"700"}},{"family":"Mouse Narratives","variants":{"regular":"regular"}},{"family":"Mr Bedfort","variants":{"regular":"regular"}},{"family":"Mr Dafoe","variants":{"regular":"regular"}},{"family":"Mr De Haviland","variants":{"regular":"regular"}},{"family":"Mrs Saint Delafield","variants":{"regular":"regular"}},{"family":"Mrs Sheppards","variants":{"regular":"regular"}},{"family":"Mukta","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Mukta Mahee","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Mukta Malar","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Mukta Vaani","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Mulish","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"MuseoModerno","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Mystery Quest","variants":{"regular":"regular"}},{"family":"NTR","variants":{"regular":"regular"}},{"family":"Nanum Brush Script","variants":{"regular":"regular"}},{"family":"Nanum Gothic","variants":{"regular":"regular","700":"700","800":"800"}},{"family":"Nanum Gothic Coding","variants":{"regular":"regular","700":"700"}},{"family":"Nanum Myeongjo","variants":{"regular":"regular","700":"700","800":"800"}},{"family":"Nanum Pen Script","variants":{"regular":"regular"}},{"family":"Nerko One","variants":{"regular":"regular"}},{"family":"Neucha","variants":{"regular":"regular"}},{"family":"Neuton","variants":{"200":"200","300":"300","regular":"regular","italic":"italic","700":"700","800":"800"}},{"family":"New Rocker","variants":{"regular":"regular"}},{"family":"New Tegomin","variants":{"regular":"regular"}},{"family":"News Cycle","variants":{"regular":"regular","700":"700"}},{"family":"Newsreader","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic"}},{"family":"Niconne","variants":{"regular":"regular"}},{"family":"Niramit","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Nixie One","variants":{"regular":"regular"}},{"family":"Nobile","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic"}},{"family":"Nokora","variants":{"regular":"regular","700":"700"}},{"family":"Norican","variants":{"regular":"regular"}},{"family":"Nosifer","variants":{"regular":"regular"}},{"family":"Notable","variants":{"regular":"regular"}},{"family":"Nothing You Could Do","variants":{"regular":"regular"}},{"family":"Noticia Text","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Noto Sans","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Noto Sans HK","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Noto Sans JP","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Noto Sans KR","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Noto Sans SC","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Noto Sans TC","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Noto Serif","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Noto Serif JP","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","900":"900"}},{"family":"Noto Serif KR","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","900":"900"}},{"family":"Noto Serif SC","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","900":"900"}},{"family":"Noto Serif TC","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","900":"900"}},{"family":"Nova Cut","variants":{"regular":"regular"}},{"family":"Nova Flat","variants":{"regular":"regular"}},{"family":"Nova Mono","variants":{"regular":"regular"}},{"family":"Nova Oval","variants":{"regular":"regular"}},{"family":"Nova Round","variants":{"regular":"regular"}},{"family":"Nova Script","variants":{"regular":"regular"}},{"family":"Nova Slim","variants":{"regular":"regular"}},{"family":"Nova Square","variants":{"regular":"regular"}},{"family":"Numans","variants":{"regular":"regular"}},{"family":"Nunito","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Nunito Sans","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Odibee Sans","variants":{"regular":"regular"}},{"family":"Odor Mean Chey","variants":{"regular":"regular"}},{"family":"Offside","variants":{"regular":"regular"}},{"family":"Oi","variants":{"regular":"regular"}},{"family":"Old Standard TT","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Oldenburg","variants":{"regular":"regular"}},{"family":"Oleo Script","variants":{"regular":"regular","700":"700"}},{"family":"Oleo Script Swash Caps","variants":{"regular":"regular","700":"700"}},{"family":"Open Sans","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Open Sans Condensed","variants":{"300":"300","300italic":"300italic","700":"700"}},{"family":"Oranienbaum","variants":{"regular":"regular"}},{"family":"Orbitron","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Oregano","variants":{"regular":"regular","italic":"italic"}},{"family":"Orelega One","variants":{"regular":"regular"}},{"family":"Orienta","variants":{"regular":"regular"}},{"family":"Original Surfer","variants":{"regular":"regular"}},{"family":"Oswald","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Otomanopee One","variants":{"regular":"regular"}},{"family":"Over the Rainbow","variants":{"regular":"regular"}},{"family":"Overlock","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Overlock SC","variants":{"regular":"regular"}},{"family":"Overpass","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Overpass Mono","variants":{"300":"300","regular":"regular","600":"600","700":"700"}},{"family":"Ovo","variants":{"regular":"regular"}},{"family":"Oxanium","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Oxygen","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Oxygen Mono","variants":{"regular":"regular"}},{"family":"PT Mono","variants":{"regular":"regular"}},{"family":"PT Sans","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"PT Sans Caption","variants":{"regular":"regular","700":"700"}},{"family":"PT Sans Narrow","variants":{"regular":"regular","700":"700"}},{"family":"PT Serif","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"PT Serif Caption","variants":{"regular":"regular","italic":"italic"}},{"family":"Pacifico","variants":{"regular":"regular"}},{"family":"Padauk","variants":{"regular":"regular","700":"700"}},{"family":"Palanquin","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Palanquin Dark","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Pangolin","variants":{"regular":"regular"}},{"family":"Paprika","variants":{"regular":"regular"}},{"family":"Parisienne","variants":{"regular":"regular"}},{"family":"Passero One","variants":{"regular":"regular"}},{"family":"Passion One","variants":{"regular":"regular","700":"700","900":"900"}},{"family":"Pathway Gothic One","variants":{"regular":"regular"}},{"family":"Patrick Hand","variants":{"regular":"regular"}},{"family":"Patrick Hand SC","variants":{"regular":"regular"}},{"family":"Pattaya","variants":{"regular":"regular"}},{"family":"Patua One","variants":{"regular":"regular"}},{"family":"Pavanam","variants":{"regular":"regular"}},{"family":"Paytone One","variants":{"regular":"regular"}},{"family":"Peddana","variants":{"regular":"regular"}},{"family":"Peralta","variants":{"regular":"regular"}},{"family":"Permanent Marker","variants":{"regular":"regular"}},{"family":"Petit Formal Script","variants":{"regular":"regular"}},{"family":"Petrona","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Philosopher","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Piazzolla","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Piedra","variants":{"regular":"regular"}},{"family":"Pinyon Script","variants":{"regular":"regular"}},{"family":"Pirata One","variants":{"regular":"regular"}},{"family":"Plaster","variants":{"regular":"regular"}},{"family":"Play","variants":{"regular":"regular","700":"700"}},{"family":"Playball","variants":{"regular":"regular"}},{"family":"Playfair Display","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Playfair Display SC","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Podkova","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Poiret One","variants":{"regular":"regular"}},{"family":"Poller One","variants":{"regular":"regular"}},{"family":"Poly","variants":{"regular":"regular","italic":"italic"}},{"family":"Pompiere","variants":{"regular":"regular"}},{"family":"Pontano Sans","variants":{"regular":"regular"}},{"family":"Poor Story","variants":{"regular":"regular"}},{"family":"Poppins","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Port Lligat Sans","variants":{"regular":"regular"}},{"family":"Port Lligat Slab","variants":{"regular":"regular"}},{"family":"Potta One","variants":{"regular":"regular"}},{"family":"Pragati Narrow","variants":{"regular":"regular","700":"700"}},{"family":"Prata","variants":{"regular":"regular"}},{"family":"Preahvihear","variants":{"regular":"regular"}},{"family":"Press Start 2P","variants":{"regular":"regular"}},{"family":"Pridi","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Princess Sofia","variants":{"regular":"regular"}},{"family":"Prociono","variants":{"regular":"regular"}},{"family":"Prompt","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Prosto One","variants":{"regular":"regular"}},{"family":"Proza Libre","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Public Sans","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Puritan","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Purple Purse","variants":{"regular":"regular"}},{"family":"Qahiri","variants":{"regular":"regular"}},{"family":"Quando","variants":{"regular":"regular"}},{"family":"Quantico","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Quattrocento","variants":{"regular":"regular","700":"700"}},{"family":"Quattrocento Sans","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Questrial","variants":{"regular":"regular"}},{"family":"Quicksand","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Quintessential","variants":{"regular":"regular"}},{"family":"Qwigley","variants":{"regular":"regular"}},{"family":"Racing Sans One","variants":{"regular":"regular"}},{"family":"Radley","variants":{"regular":"regular","italic":"italic"}},{"family":"Rajdhani","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Rakkas","variants":{"regular":"regular"}},{"family":"Raleway","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Raleway Dots","variants":{"regular":"regular"}},{"family":"Ramabhadra","variants":{"regular":"regular"}},{"family":"Ramaraja","variants":{"regular":"regular"}},{"family":"Rambla","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Rammetto One","variants":{"regular":"regular"}},{"family":"Ranchers","variants":{"regular":"regular"}},{"family":"Rancho","variants":{"regular":"regular"}},{"family":"Ranga","variants":{"regular":"regular","700":"700"}},{"family":"Rasa","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Rationale","variants":{"regular":"regular"}},{"family":"Ravi Prakash","variants":{"regular":"regular"}},{"family":"Recursive","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Red Hat Display","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Red Hat Text","variants":{"regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic"}},{"family":"Red Rose","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Redressed","variants":{"regular":"regular"}},{"family":"Reem Kufi","variants":{"regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Reenie Beanie","variants":{"regular":"regular"}},{"family":"Reggae One","variants":{"regular":"regular"}},{"family":"Revalia","variants":{"regular":"regular"}},{"family":"Rhodium Libre","variants":{"regular":"regular"}},{"family":"Ribeye","variants":{"regular":"regular"}},{"family":"Ribeye Marrow","variants":{"regular":"regular"}},{"family":"Righteous","variants":{"regular":"regular"}},{"family":"Risque","variants":{"regular":"regular"}},{"family":"Roboto","variants":{"100":"100","100italic":"100italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Roboto Condensed","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Roboto Mono","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Roboto Slab","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Rochester","variants":{"regular":"regular"}},{"family":"Rock Salt","variants":{"regular":"regular"}},{"family":"RocknRoll One","variants":{"regular":"regular"}},{"family":"Rokkitt","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Romanesco","variants":{"regular":"regular"}},{"family":"Ropa Sans","variants":{"regular":"regular","italic":"italic"}},{"family":"Rosario","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic"}},{"family":"Rosarivo","variants":{"regular":"regular","italic":"italic"}},{"family":"Rouge Script","variants":{"regular":"regular"}},{"family":"Rowdies","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Rozha One","variants":{"regular":"regular"}},{"family":"Rubik","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Rubik Mono One","variants":{"regular":"regular"}},{"family":"Ruda","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Rufina","variants":{"regular":"regular","700":"700"}},{"family":"Ruge Boogie","variants":{"regular":"regular"}},{"family":"Ruluko","variants":{"regular":"regular"}},{"family":"Rum Raisin","variants":{"regular":"regular"}},{"family":"Ruslan Display","variants":{"regular":"regular"}},{"family":"Russo One","variants":{"regular":"regular"}},{"family":"Ruthie","variants":{"regular":"regular"}},{"family":"Rye","variants":{"regular":"regular"}},{"family":"STIX Two Math","variants":{"regular":"regular"}},{"family":"Sacramento","variants":{"regular":"regular"}},{"family":"Sahitya","variants":{"regular":"regular","700":"700"}},{"family":"Sail","variants":{"regular":"regular"}},{"family":"Saira","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Saira Condensed","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Saira Extra Condensed","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Saira Semi Condensed","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Saira Stencil One","variants":{"regular":"regular"}},{"family":"Salsa","variants":{"regular":"regular"}},{"family":"Sanchez","variants":{"regular":"regular","italic":"italic"}},{"family":"Sancreek","variants":{"regular":"regular"}},{"family":"Sansita","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Sansita Swashed","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Sarabun","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Sarala","variants":{"regular":"regular","700":"700"}},{"family":"Sarina","variants":{"regular":"regular"}},{"family":"Sarpanch","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Satisfy","variants":{"regular":"regular"}},{"family":"Sawarabi Gothic","variants":{"regular":"regular"}},{"family":"Sawarabi Mincho","variants":{"regular":"regular"}},{"family":"Scada","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Scheherazade","variants":{"regular":"regular","700":"700"}},{"family":"Schoolbell","variants":{"regular":"regular"}},{"family":"Scope One","variants":{"regular":"regular"}},{"family":"Seaweed Script","variants":{"regular":"regular"}},{"family":"Secular One","variants":{"regular":"regular"}},{"family":"Sedgwick Ave","variants":{"regular":"regular"}},{"family":"Sedgwick Ave Display","variants":{"regular":"regular"}},{"family":"Sen","variants":{"regular":"regular","700":"700","800":"800"}},{"family":"Sevillana","variants":{"regular":"regular"}},{"family":"Seymour One","variants":{"regular":"regular"}},{"family":"Shadows Into Light","variants":{"regular":"regular"}},{"family":"Shadows Into Light Two","variants":{"regular":"regular"}},{"family":"Shanti","variants":{"regular":"regular"}},{"family":"Share","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Share Tech","variants":{"regular":"regular"}},{"family":"Share Tech Mono","variants":{"regular":"regular"}},{"family":"Shippori Mincho","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Shippori Mincho B1","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Shojumaru","variants":{"regular":"regular"}},{"family":"Short Stack","variants":{"regular":"regular"}},{"family":"Shrikhand","variants":{"regular":"regular"}},{"family":"Siemreap","variants":{"regular":"regular"}},{"family":"Sigmar One","variants":{"regular":"regular"}},{"family":"Signika","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Signika Negative","variants":{"300":"300","regular":"regular","600":"600","700":"700"}},{"family":"Simonetta","variants":{"regular":"regular","italic":"italic","900":"900","900italic":"900italic"}},{"family":"Single Day","variants":{"regular":"regular"}},{"family":"Sintony","variants":{"regular":"regular","700":"700"}},{"family":"Sirin Stencil","variants":{"regular":"regular"}},{"family":"Six Caps","variants":{"regular":"regular"}},{"family":"Skranji","variants":{"regular":"regular","700":"700"}},{"family":"Slabo 13px","variants":{"regular":"regular"}},{"family":"Slabo 27px","variants":{"regular":"regular"}},{"family":"Slackey","variants":{"regular":"regular"}},{"family":"Smokum","variants":{"regular":"regular"}},{"family":"Smythe","variants":{"regular":"regular"}},{"family":"Sniglet","variants":{"regular":"regular","800":"800"}},{"family":"Snippet","variants":{"regular":"regular"}},{"family":"Snowburst One","variants":{"regular":"regular"}},{"family":"Sofadi One","variants":{"regular":"regular"}},{"family":"Sofia","variants":{"regular":"regular"}},{"family":"Solway","variants":{"300":"300","regular":"regular","500":"500","700":"700","800":"800"}},{"family":"Song Myung","variants":{"regular":"regular"}},{"family":"Sonsie One","variants":{"regular":"regular"}},{"family":"Sora","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Sorts Mill Goudy","variants":{"regular":"regular","italic":"italic"}},{"family":"Source Code Pro","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Source Sans Pro","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Source Serif Pro","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","900":"900","900italic":"900italic"}},{"family":"Space Grotesk","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Space Mono","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Spartan","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Special Elite","variants":{"regular":"regular"}},{"family":"Spectral","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Spectral SC","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic"}},{"family":"Spicy Rice","variants":{"regular":"regular"}},{"family":"Spinnaker","variants":{"regular":"regular"}},{"family":"Spirax","variants":{"regular":"regular"}},{"family":"Squada One","variants":{"regular":"regular"}},{"family":"Sree Krushnadevaraya","variants":{"regular":"regular"}},{"family":"Sriracha","variants":{"regular":"regular"}},{"family":"Srisakdi","variants":{"regular":"regular","700":"700"}},{"family":"Staatliches","variants":{"regular":"regular"}},{"family":"Stalemate","variants":{"regular":"regular"}},{"family":"Stalinist One","variants":{"regular":"regular"}},{"family":"Stardos Stencil","variants":{"regular":"regular","700":"700"}},{"family":"Stick","variants":{"regular":"regular"}},{"family":"Stint Ultra Condensed","variants":{"regular":"regular"}},{"family":"Stint Ultra Expanded","variants":{"regular":"regular"}},{"family":"Stoke","variants":{"300":"300","regular":"regular"}},{"family":"Strait","variants":{"regular":"regular"}},{"family":"Stylish","variants":{"regular":"regular"}},{"family":"Sue Ellen Francisco","variants":{"regular":"regular"}},{"family":"Suez One","variants":{"regular":"regular"}},{"family":"Sulphur Point","variants":{"300":"300","regular":"regular","700":"700"}},{"family":"Sumana","variants":{"regular":"regular","700":"700"}},{"family":"Sunflower","variants":{"300":"300","500":"500","700":"700"}},{"family":"Sunshiney","variants":{"regular":"regular"}},{"family":"Supermercado One","variants":{"regular":"regular"}},{"family":"Sura","variants":{"regular":"regular","700":"700"}},{"family":"Suranna","variants":{"regular":"regular"}},{"family":"Suravaram","variants":{"regular":"regular"}},{"family":"Suwannaphum","variants":{"regular":"regular"}},{"family":"Swanky and Moo Moo","variants":{"regular":"regular"}},{"family":"Syncopate","variants":{"regular":"regular","700":"700"}},{"family":"Syne","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Syne Mono","variants":{"regular":"regular"}},{"family":"Syne Tactile","variants":{"regular":"regular"}},{"family":"Tajawal","variants":{"200":"200","300":"300","regular":"regular","500":"500","700":"700","800":"800","900":"900"}},{"family":"Tangerine","variants":{"regular":"regular","700":"700"}},{"family":"Taprom","variants":{"regular":"regular"}},{"family":"Tauri","variants":{"regular":"regular"}},{"family":"Taviraj","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Teko","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Telex","variants":{"regular":"regular"}},{"family":"Tenali Ramakrishna","variants":{"regular":"regular"}},{"family":"Tenor Sans","variants":{"regular":"regular"}},{"family":"Text Me One","variants":{"regular":"regular"}},{"family":"Texturina","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Thasadith","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"The Girl Next Door","variants":{"regular":"regular"}},{"family":"Tienne","variants":{"regular":"regular","700":"700","900":"900"}},{"family":"Tillana","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Timmana","variants":{"regular":"regular"}},{"family":"Tinos","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Titan One","variants":{"regular":"regular"}},{"family":"Titillium Web","variants":{"200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","900":"900"}},{"family":"Tomorrow","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Tourney","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Trade Winds","variants":{"regular":"regular"}},{"family":"Train One","variants":{"regular":"regular"}},{"family":"Trirong","variants":{"100":"100","100italic":"100italic","200":"200","200italic":"200italic","300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic","800":"800","800italic":"800italic","900":"900","900italic":"900italic"}},{"family":"Trispace","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800"}},{"family":"Trocchi","variants":{"regular":"regular"}},{"family":"Trochut","variants":{"regular":"regular","italic":"italic","700":"700"}},{"family":"Truculenta","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900"}},{"family":"Trykker","variants":{"regular":"regular"}},{"family":"Tulpen One","variants":{"regular":"regular"}},{"family":"Turret Road","variants":{"200":"200","300":"300","regular":"regular","500":"500","700":"700","800":"800"}},{"family":"Ubuntu","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","700":"700","700italic":"700italic"}},{"family":"Ubuntu Condensed","variants":{"regular":"regular"}},{"family":"Ubuntu Mono","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Uchen","variants":{"regular":"regular"}},{"family":"Ultra","variants":{"regular":"regular"}},{"family":"Uncial Antiqua","variants":{"regular":"regular"}},{"family":"Underdog","variants":{"regular":"regular"}},{"family":"Unica One","variants":{"regular":"regular"}},{"family":"UnifrakturCook","variants":{"700":"700"}},{"family":"UnifrakturMaguntia","variants":{"regular":"regular"}},{"family":"Unkempt","variants":{"regular":"regular","700":"700"}},{"family":"Unlock","variants":{"regular":"regular"}},{"family":"Unna","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"VT323","variants":{"regular":"regular"}},{"family":"Vampiro One","variants":{"regular":"regular"}},{"family":"Varela","variants":{"regular":"regular"}},{"family":"Varela Round","variants":{"regular":"regular"}},{"family":"Varta","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Vast Shadow","variants":{"regular":"regular"}},{"family":"Vesper Libre","variants":{"regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Viaoda Libre","variants":{"regular":"regular"}},{"family":"Vibes","variants":{"regular":"regular"}},{"family":"Vibur","variants":{"regular":"regular"}},{"family":"Vidaloka","variants":{"regular":"regular"}},{"family":"Viga","variants":{"regular":"regular"}},{"family":"Voces","variants":{"regular":"regular"}},{"family":"Volkhov","variants":{"regular":"regular","italic":"italic","700":"700","700italic":"700italic"}},{"family":"Vollkorn","variants":{"regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Vollkorn SC","variants":{"regular":"regular","600":"600","700":"700","900":"900"}},{"family":"Voltaire","variants":{"regular":"regular"}},{"family":"Waiting for the Sunrise","variants":{"regular":"regular"}},{"family":"Wallpoet","variants":{"regular":"regular"}},{"family":"Walter Turncoat","variants":{"regular":"regular"}},{"family":"Warnes","variants":{"regular":"regular"}},{"family":"Wellfleet","variants":{"regular":"regular"}},{"family":"Wendy One","variants":{"regular":"regular"}},{"family":"Wire One","variants":{"regular":"regular"}},{"family":"Work Sans","variants":{"100":"100","200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700","800":"800","900":"900","100italic":"100italic","200italic":"200italic","300italic":"300italic","italic":"italic","500italic":"500italic","600italic":"600italic","700italic":"700italic","800italic":"800italic","900italic":"900italic"}},{"family":"Xanh Mono","variants":{"regular":"regular","italic":"italic"}},{"family":"Yanone Kaffeesatz","variants":{"200":"200","300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Yantramanav","variants":{"100":"100","300":"300","regular":"regular","500":"500","700":"700","900":"900"}},{"family":"Yatra One","variants":{"regular":"regular"}},{"family":"Yellowtail","variants":{"regular":"regular"}},{"family":"Yeon Sung","variants":{"regular":"regular"}},{"family":"Yeseva One","variants":{"regular":"regular"}},{"family":"Yesteryear","variants":{"regular":"regular"}},{"family":"Yomogi","variants":{"regular":"regular"}},{"family":"Yrsa","variants":{"300":"300","regular":"regular","500":"500","600":"600","700":"700"}},{"family":"Yusei Magic","variants":{"regular":"regular"}},{"family":"ZCOOL KuaiLe","variants":{"regular":"regular"}},{"family":"ZCOOL QingKe HuangYou","variants":{"regular":"regular"}},{"family":"ZCOOL XiaoWei","variants":{"regular":"regular"}},{"family":"Zen Dots","variants":{"regular":"regular"}},{"family":"Zen Loop","variants":{"regular":"regular","italic":"italic"}},{"family":"Zen Tokyo Zoo","variants":{"regular":"regular"}},{"family":"Zeyada","variants":{"regular":"regular"}},{"family":"Zhi Mang Xing","variants":{"regular":"regular"}},{"family":"Zilla Slab","variants":{"300":"300","300italic":"300italic","regular":"regular","italic":"italic","500":"500","500italic":"500italic","600":"600","600italic":"600italic","700":"700","700italic":"700italic"}},{"family":"Zilla Slab Highlight","variants":{"regular":"regular","700":"700"}}]';
        
        $font_array = json_decode($font_decoded, true);
        return $font_array;
    }

endif;

if( !function_exists( 'blogflux_font_url' ) ) :

    function blogflux_font_url() {

        $blogflux_default = blogflux_get_default_theme_options();
        $wedev_tagline_font = get_theme_mod('wedev_tagline_font', $blogflux_default['wedev_tagline_font']);
        $wedev_general_font = get_theme_mod('wedev_general_font', $blogflux_default['wedev_general_font']);
        $wedev_heading_font = get_theme_mod('wedev_heading_font', $blogflux_default['wedev_heading_font']);

        // Fonts Array
        $fonts = array($wedev_tagline_font, $wedev_general_font, $wedev_heading_font);

        // Remove if font repeat
        $fonts = array_unique($fonts);

        // Remove Local Font
        $remove_font_1 = array_search('Georgia', $fonts);
        if (in_array('Georgia', $fonts)) {
            unset($fonts[$remove_font_1]);
        }

        $remove_font_2 = array_search('Helvetica', $fonts);
        if (in_array('Helvetica', $fonts)) {
            unset($fonts[$remove_font_2]);
        }

        $remove_font_3 = array_search('Arial', $fonts);
        if (in_array('Arial', $fonts)) {
            unset($fonts[$remove_font_3]);
        }

        $blogflux_fonts = array();

        $font_count = count($fonts);

        $j = 1;
        foreach ($fonts as $font) {

            // Get Font Property
            $fonts_property_list = blogflux_fonts_variants( $font );

            if ($fonts_property_list) {

                $fonts_property_list = rtrim($fonts_property_list, ',');
                if ($font_count == $j) {
                    $blogflux_fonts[] = $font . ':' . $fonts_property_list . '&display=swap';
                } else {
                    $blogflux_fonts[] = $font . ':' . $fonts_property_list;
                }
            } else {

                if ($font_count == $j) {
                    $blogflux_fonts[] = $font . '&display=swap';
                } else {
                    $blogflux_fonts[] = $font;
                }

            }

            $j++;
        }

        if ($blogflux_fonts) {

            $i = 0;
            for ($i = 0; $i < count($blogflux_fonts); $i++) {

                if ('off' !== sprintf(_x('on', '%s font: on or off', 'blogflux'), $blogflux_fonts[$i])) {
                    $fonts[] = $blogflux_fonts[$i];
                }

            }

            if ($fonts) {
                $fonts_url = add_query_arg(array(
                    'family' => urldecode(implode('|', $fonts)),
                ), 'https://fonts.googleapis.com/css');
            }

            return esc_url_raw($fonts_url);

        }

    }

endif;