<?php
/**
 * Featured Post Section.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_featured_video') ) :

    function blogflux_featured_video(){

        $blogflux_default = blogflux_get_default_theme_options();
        $enable_header_featured_video = get_theme_mod( 'enable_header_featured_video', $blogflux_default['enable_header_featured_video'] );
        $featured_video_section_title = get_theme_mod( 'featured_video_section_title' );
        $featured_video_section_sub_title = get_theme_mod( 'featured_video_section_sub_title');
        $blogflux_header_featured_video_cat = get_theme_mod( 'blogflux_header_featured_video_cat');

        if( $enable_header_featured_video ){
         ?>
           <section class="wedevs-video-block wedevs-block">
               <div class="site-wrapper">
                   <div class="site-row">
                       <div class="site-column site-column-12">
                           <?php if (!empty($featured_video_section_title) || !empty($featured_video_section_sub_title)) { ?>
                               <div class="wedevs-section-head text-center mb-48">
                                   <?php if (!empty($featured_video_section_title)) { ?>
                                       <h2 class="font-size-big mb-8">
                                           <?php echo esc_html($featured_video_section_title); ?>
                                       </h2>
                                   <?php } ?>
                                   <?php if (!empty($featured_video_section_sub_title)) { ?>
                                   <p class = "m-0">
                                       <?php echo esc_html($featured_video_section_sub_title); ?>
                                   </p>
                                   <?php } ?>
                               </div>
                           <?php } ?>
                           <div class="site-row">
                            <?php
                            $featured_video_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => 3, 'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html($blogflux_header_featured_video_cat)));
                                if( $featured_video_query->have_posts() ):
                                    while ($featured_video_query->have_posts()): $featured_video_query->the_post(); 
                                        $content = apply_filters( 'the_content', get_the_content() );
                                        $video = false;
                                        // Only get video from the content if a playlist isn't present.
                                        if ( false === strpos( $content, 'wp-playlist-script' ) ) {

                                            $video = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );

                                        } ?>
                                           <div class="site-column site-column-4 site-column-sm-6 site-column-xs-12 mb-24">
                                               <article class="wedevs-article-post">
                                                <?php if ( ! empty( $video ) ) { 
                                                    foreach ( $video as $video_html ) { ?>
                                                                <?php echo blogflux_iframe_escape( $video_html ); ?>

                                                        <?php
                                                        break;

                                                    } 
                                                } else { ?>
                                                   <img src="<?php the_post_thumbnail_url('medium_large'); ?>" alt="">
                                                <?php } ?>
                                                   <h2 class="entry-title font-size-small mb-8">
                                                       <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                                   </h2>

                                                   <a href="<?php the_permalink(); ?>" class = "wedevs-primary-link">
                                                       Learn more
                                                   </a>
                                               </article>
                                           </div>
                                       <?php
                                   endwhile; 
                               wp_reset_postdata();
                               endif; ?>
                           </div>
                           <?php $blogflux_category_id = get_cat_ID($blogflux_header_featured_video_cat); ?>
                           <a href="<?php echo esc_url(get_category_link( $blogflux_category_id )); ?>" class="wedevs-secondary-link"> <?php echo esc_html__('View all videos','blogflux');  ?> </a>
                       </div>
                   </div>
               </div>
           </section>
        <?php
        }

    }

endif;