<?php
/**
 * Featured Post Section.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_featured_post') ) :

    function blogflux_featured_post(){

        $blogflux_default = blogflux_get_default_theme_options();
        $enable_header_featured_post = get_theme_mod( 'enable_header_featured_post', $blogflux_default['enable_header_featured_post'] );
        $featured_post_section_title = get_theme_mod( 'featured_post_section_title' );
        $featured_post_section_sub_title = get_theme_mod( 'featured_post_section_sub_title');
        $blogflux_header_featured_post_cat = get_theme_mod( 'blogflux_header_featured_post_cat');

        if( $enable_header_featured_post ){
            ?>
            <section class="wedevs-featured-posts wedevs-block">
                <div class="site-wrapper">
                    <div class="site-row">
                        <?php if (!empty($featured_post_section_title) || !empty($featured_post_section_sub_title)) { ?>
                            <div class="site-column site-column-12">
                                <div class="wedevs-section-head text-center mb-48">
                                    <?php if (!empty($featured_post_section_title)) { ?>
                                        <h2 class="font-size-big mb-8">
                                            <?php echo esc_html($featured_post_section_title); ?>
                                        </h2>
                                    <?php } ?>
                                    <?php if (!empty($featured_post_section_sub_title)) { ?>
                                        <p class = "m-0">
                                            <?php echo esc_html($featured_post_section_sub_title); ?>
                                        </p>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php $featured_post_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => 3, 'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html($blogflux_header_featured_post_cat)));
                        if( $featured_post_query->have_posts() ):
                            while ($featured_post_query->have_posts()): $featured_post_query->the_post();
                                ?>
                                <div class="site-column site-column-4 site-column-md-6 site-column-xs-12 mb-24">
                                    <article id="featured-post-<?php the_ID(); ?>" <?php post_class('wedevs-post wedevs-article-post article-content-overlay'); ?>>
                                        <?php if (has_post_thumbnail()) : ?>
                                            <div class="image-size-big wedevs-optimize-image">
                                                <?php
                                                the_post_thumbnail('medium_large', array(
                                                    'alt' => the_title_attribute(array(
                                                        'echo' => false,
                                                    )),
                                                ));
                                                ?>
                                            </div>
                                        <?php endif; ?>

                                        <div class="wedevs-article-content text-center">
                                            <div class="entry-meta entry-meta-categories mb-4">
                                                <?php blogflux_entry_cat(); ?>
                                            </div>
                                            <h2 class="entry-title font-size-medium line-clamp line-clamp-3 m-0">
                                                <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                            </h2>
                                        </div>
                                    </article>
                                </div>
                            <?php
                            endwhile;
                            wp_reset_postdata();
                        endif; ?>
                    </div>
                </div>
            </section>

            <?php
        }

    }

endif;