<?php
/**
 * Featured Category Section.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_featured_category') ) :

    function blogflux_featured_category(){

        $blogflux_default = blogflux_get_default_theme_options();
        $enable_header_featured_category = get_theme_mod( 'enable_header_featured_category', $blogflux_default['enable_header_featured_category'] );
        $featured_category_section_title = get_theme_mod( 'featured_category_section_title' );
        $featured_category_section_sub_title = get_theme_mod( 'featured_category_section_sub_title');

        if( $enable_header_featured_category ){

            $enable_header_featured_category_column = get_theme_mod( 'enable_header_featured_category_column', $blogflux_default['enable_header_featured_category_column'] );
            if( $enable_header_featured_category_column == '2' ){
                $class_grid = 'site-column-6 mb-24';
                $image_size = 'medium_large';
                $grid_size = 'image-size-big';
            }elseif( $enable_header_featured_category_column == '3' ){
                $class_grid = 'site-column-4 mb-24';
                $image_size = 'medium_large';
                $grid_size = 'image-size-medium';
            }else{
                $class_grid = 'site-column-3 site-column-lg-4 mb-24';
                $image_size = 'medium';
                $grid_size = 'image-size-small';
            }
         ?>

            <section class="wedevs-block wedevs-categories-block">
                <div class="site-wrapper">
                    <div class="site-row">
                        <?php if (!empty($featured_category_section_title) || !empty($featured_category_section_sub_title)) { ?>
                        <div class="site-column site-column-12">
                            <div class="wedevs-section-head text-center mb-48">
                                <?php if (!empty($featured_category_section_title)) { ?>
                                    <h2 class="font-size-big mb-8">
                                        <?php echo esc_html($featured_category_section_title); ?>
                                    </h2>
                                <?php } ?>
                                <?php if (!empty($featured_category_section_sub_title)) { ?>
                                <p class = "m-0">
                                    <?php echo esc_html($featured_category_section_sub_title); ?>
                                </p>
                                <?php } ?>
                            </div>
                        </div>
                        <?php } ?>

                        <?php
                        for( $i = 1; $i <= 7; $i++  ){

                            $featured_category = get_theme_mod('blogflux_header_featured_category_cat_'.$i);

                            if( $featured_category ){

                                $cat_obj = get_category_by_slug($featured_category);
                                $cat_name = isset( $cat_obj->name ) ? $cat_obj->name : '';
                                $cat_id = isset( $cat_obj->term_id ) ? $cat_obj->term_id : '';
                                $count = isset( $cat_obj->count ) ? $cat_obj->count : '';
                                $cat_link = get_category_link($cat_id);
                                $wedev_term_image = get_term_meta($cat_id, 'wedevs-term-featured-image', true);
                                $wedev_term_image = wp_get_attachment_image_url( $wedev_term_image,$image_size ); ?>
                                <div class="site-column <?php echo $class_grid; ?> site-column-sm-12">
                                    <div class="categories-content-container">
                                        <?php if (!empty($wedev_term_image)) { ?>
                                            <div class="image-size-thumbnail wedevs-optimize-image">
                                                <img src="<?php echo esc_url($wedev_term_image); ?>" alt="">
                                            </div>
                                        <?php } ?>


                                        <a href="<?php echo esc_url($cat_link); ?>">
                                            <?php echo esc_html( $cat_name ); ?>
                                        </a>

                                        <?php if( $count ){ ?>
                                            <span class="post-count"><?php echo esc_html( $count ); ?></span>
                                        <?php } ?>
                                    </div>
                                </div>

                            <?php } ?>

                            <?php 
                            if( $enable_header_featured_category_column == $i ){ break; }

                        } ?>
                    </div>
                </div>
            </section>

        <?php
        }

    }

endif;