<?php
/**
 * Social Share Settings.
 *
 * @package Blogflux
**/

$blogflux_default = blogflux_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'social_share',
	array(
	'title'      => esc_html__( 'Social Share Settings', 'blogflux' ),
	'capability' => 'edit_theme_options',
	'panel'      => 'blogflux_options',
	)
);

$wp_customize->add_setting('enable_facebook',
    array(
        'default' => $blogflux_default['enable_facebook'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_facebook',
    array(
        'label' => esc_html__('Enable Facebook', 'blogflux'),
        'section' => 'social_share',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('enable_twitter',
    array(
        'default' => $blogflux_default['enable_twitter'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_twitter',
    array(
        'label' => esc_html__('Enable Twitter', 'blogflux'),
        'section' => 'social_share',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('enable_pinterest',
    array(
        'default' => $blogflux_default['enable_pinterest'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_pinterest',
    array(
        'label' => esc_html__('Enable Pinterest', 'blogflux'),
        'section' => 'social_share',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('enable_linkedin',
    array(
        'default' => $blogflux_default['enable_linkedin'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_linkedin',
    array(
        'label' => esc_html__('Enable LinkedIn', 'blogflux'),
        'section' => 'social_share',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('enable_email',
    array(
        'default' => $blogflux_default['enable_email'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_email',
    array(
        'label' => esc_html__('Enable Email', 'blogflux'),
        'section' => 'social_share',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting(
    'blogflux_more_options_social_share',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new Blogflux_Premium_Notice( 
        $wp_customize,
        'blogflux_more_options_social_share',
        array(
            'label'      => esc_html__( 'More Options Available On Premium Version.', 'blogflux' ),
            'settings' => 'blogflux_more_options_social_share',
            'section'       => 'social_share',
        )
    )
);
