<?php
/**
 * Social Icon Settings.
 *
 * @package Blogflux
**/

$blogflux_default = blogflux_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'social_icon',
    array(
    'title'      => esc_html__( 'Social Icon Settings', 'blogflux' ),
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_options',
    )
);

$wp_customize->add_setting('enable_social_link',
    array(
        'default' => $blogflux_default['enable_social_link'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_social_link',
    array(
        'label' => esc_html__('Enable Social Link', 'blogflux'),
        'section' => 'social_icon',
        'type' => 'checkbox',
    )
);

// Social Icons
$wp_customize->add_setting( 'blogflux_social_icon_4', array(
    'sanitize_callback' => 'blogflux_sanitize_social_icons',
    'default' => $blogflux_default['blogflux_social_icon_4'],
    'sanitize_callback' => 'blogflux_sanitize_social_icons',
));

$wp_customize->add_control(  new Blogflux_Social_Icon_Controler( $wp_customize, 'blogflux_social_icon_4',
    array(
        'section' => 'social_icon',
        'settings' => 'blogflux_social_icon_4',
        'blogflux_box_label' => esc_html__('Social Profile','blogflux'),
        'blogflux_box_add_control' => esc_html__('Add New Social Link','blogflux'),
    ),
    array(
        'social_svg_icon' => array(
            'type'        => 'icons',
            'label'       => esc_html__( 'SVG Icons', 'blogflux' ),
            'class'     => 'ta-fa-icons-rep'
        ),
        'social_link' => array(
            'type'        => 'link',
            'label'       => esc_html__( 'Social Links', 'blogflux' ),
        ),
        'label' => array(
            'type'        => 'text',
            'label'       => esc_html__( 'Social Icon Label', 'blogflux' ),
        ),
    )
));