<?php
/**
* Layouts Settings.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$sidebar_option = blogflux_sidebar_options();
$sidebar_option_1 = blogflux_sidebar_options( $global = false );

$wp_customize->add_section( 'sidebar_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'blogflux' ),
	'priority'   => 60,
	'capability' => 'edit_theme_options',
	'panel'      => 'blogflux_options',
	)
);

$wp_customize->add_setting( 'global_sidebar_layout',
	array(
	'default'           => $blogflux_default['global_sidebar_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'blogflux_sanitize_sidebar_option',
	)
);
$wp_customize->add_control( 'global_sidebar_layout',
	array(
	'label'       => esc_html__( 'Homepage Sidebar Layout', 'blogflux' ),
	'section'     => 'sidebar_setting',
	'type'        => 'select',
	'choices'     => $sidebar_option_1,
	)
);

$wp_customize->add_setting( 'archive_sidebar_layout',
	array(
	'default'           => $blogflux_default['archive_sidebar_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'blogflux_sanitize_sidebar_option',
	)
);
$wp_customize->add_control( 'archive_sidebar_layout',
	array(
	'label'       => esc_html__( 'Archive Sidebar Layout', 'blogflux' ),
	'section'     => 'sidebar_setting',
	'type'        => 'select',
	'choices'     => $sidebar_option,
	)
);


$wp_customize->add_setting( 'single_sidebar_layout',
	array(
	'default'           => $blogflux_default['single_sidebar_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'blogflux_sanitize_sidebar_option',
	)
);
$wp_customize->add_control( 'single_sidebar_layout',
	array(
	'label'       => esc_html__( 'Single Sidebar Layout', 'blogflux' ),
	'section'     => 'sidebar_setting',
	'type'        => 'select',
	'choices'     => $sidebar_option,
	)
);
