<?php
/**
 * Pagination Settings
 *
 * @package Blogflux
 */

$blogflux_default = blogflux_get_default_theme_options();

// Pagination Section.
$wp_customize->add_section( 'blogflux_pagination_section',
	array(
	'title'      => esc_html__( 'Pagination Settings', 'blogflux' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'		 => 'blogflux_options',
	)
);

// Pagination Layout Settings
$wp_customize->add_setting( 'blogflux_pagination_layout',
	array(
	'default'           => $blogflux_default['blogflux_pagination_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'blogflux_pagination_layout',
	array(
	'label'       => esc_html__( 'Pagination Method', 'blogflux' ),
	'section'     => 'blogflux_pagination_section',
	'type'        => 'select',
	'choices'     => array(
		'next-prev' => esc_html__('Next/Previous Method','blogflux'),
		'numeric' => esc_html__('Numeric Method','blogflux'),
		'load-more' => esc_html__('Ajax Load More Button','blogflux'),
		'auto-load' => esc_html__('Ajax Auto Load','blogflux'),
	),
	)
);