<?php
/**
* Category Section Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();

$wp_customize->add_section( 'gallery_slider_setting',
    array(
    'title'      => esc_html__( 'Image Gallery Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_gallery_slider',
    array(
        'default' => $blogflux_default['enable_gallery_slider'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_gallery_slider',
    array(
        'label' => esc_html__('Enable Gallery Section', 'blogflux'),
        'section' => 'gallery_slider_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('gallery_section_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('gallery_section_title',
    array(
        'label' => esc_html__('Gallery Section Title', 'blogflux'),
        'section' => 'gallery_slider_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('gallery_section_sub_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('gallery_section_sub_title',
    array(
        'label' => esc_html__('Gallery Section Sub-Title', 'blogflux'),
        'section' => 'gallery_slider_setting',
        'type' => 'text',
    )
);
for ($i=1; $i <= 8 ; $i++) { 
    $wp_customize->add_setting('gallery_image_section_'.$i,
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize,
        'gallery_image_section_'.$i,
            array(
                'label'      => esc_html__( 'Gallery Image Upload - ', 'blogflux' ).$i,
                'section'    => 'gallery_slider_setting',
            )
        )
    );

}

$wp_customize->add_setting('gallery_link_text',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('gallery_link_text',
    array(
        'label' => esc_html__('Gallery Link Text', 'blogflux'),
        'section' => 'gallery_slider_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('gallery_section_link',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control('gallery_section_link',
    array(
        'label' => esc_html__('Gallery Link URL', 'blogflux'),
        'section' => 'gallery_slider_setting',
        'type' => 'text',
    )
);