<?php
/**
 * Section Reorder
 *
 * @package Blogflux
**/

$blogflux_default = blogflux_get_default_theme_options();

// Section Reorder
$wp_customize->add_section( 'wedev_home_section_reorder',
	array(
	'title'      => esc_html__( 'Section Reorder', 'blogflux' ),
	'capability' => 'edit_theme_options',
	'panel'		 => 'blogflux_home',
	)
);


$wp_customize->add_setting(
	'home_section_order_4', 
	array(
		'default' => $blogflux_default['home_section_order_4'],
		'sanitize_callback' => 'blogflux_sanitize_reorder',
	)
);

$wp_customize->add_control(
	new Blogflux_Sortable_Control(
		$wp_customize,
		'home_section_order_4',
		array(
			'section'     => 'wedev_home_section_reorder',
			'label'       => __( 'Reorder Sections', 'blogflux' ),
			'choices'     => array(
                'banner'   => __( 'Slide Banner Section', 'blogflux' ),
        		'header_featured_post_setting'   => __( 'Featured Post', 'blogflux' ),
        		'featured-category'  => __( 'Featured Category', 'blogflux' ),
        		'header_featured_video_setting'   => __( 'Featured Video', 'blogflux' ),
        		'client_with_link_slider_setting'   => __( 'Clients Slider', 'blogflux' ),
        		'latest-posts'   => __( 'Latest Posts', 'blogflux' ),
        		'gallery_slider_setting'   => __( 'Image Gallery', 'blogflux' ),
        	),
		)
	)
);