<?php
/**
 * Single Post Settings.
 *
 * @package Blogflux
**/

$blogflux_default = blogflux_get_default_theme_options();
$google_fonts = blogflux_google_fonts();
$google_fonts_array = blogflux_font_array();
$wedev_tagline_font = get_theme_mod( 'wedev_tagline_font',$blogflux_default['wedev_tagline_font'] );
$wedev_tagline_font_key = array_search( $wedev_tagline_font, array_column( $google_fonts_array, 'family') );
$wedev_tagline_font_variants = $google_fonts_array[$wedev_tagline_font_key]['variants'];

// Layout Section.
$wp_customize->add_section( 'header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'blogflux' ),
	'capability' => 'edit_theme_options',
	'panel'      => 'blogflux_options',
	)
);

$wp_customize->add_setting('enable_header_menu_overlap',
    array(
        'default' => $blogflux_default['enable_header_menu_overlap'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_menu_overlap',
    array(
        'label' => esc_html__('Enable Header Menu Overlap', 'blogflux'),
        'section' => 'header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('enable_header_search',
    array(
        'default' => $blogflux_default['enable_header_search'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_search',
    array(
        'label' => esc_html__('Enable Search', 'blogflux'),
        'section' => 'header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('logo_width',
    array(
        'default' => $blogflux_default['logo_width'],
        'capability' => 'edit_theme_options',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control('logo_width',
    array(
        'label' => esc_html__('Logo Width', 'blogflux'),
        'section' => 'title_tagline',
        'type' => 'number',
        'priority' => 50,
    )
);

$wp_customize->add_setting( 'wedev_tagline_font',
    array(
    'default'           => $blogflux_default['wedev_tagline_font'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'wedev_tagline_font',
    array(
    'label'       => esc_html__( 'Tagline Font', 'blogflux' ),
    'section'     => 'title_tagline',
    'type'        => 'select',
    'choices'     => $google_fonts,
    )
);

$wp_customize->add_setting( 'wedev_tagline_font_weight',
    array(
    'default'           => $blogflux_default['wedev_tagline_font_weight'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'wedev_tagline_font_weight',
    array(
    'label'       => esc_html__( 'Tagline Font Weight', 'blogflux' ),
    'section'     => 'title_tagline',
    'type'        => 'select',
    'choices'     => $wedev_tagline_font_variants,
    )
);

$wp_customize->add_setting(
    'blogflux_tagline_font_size',
    array(
        'default'           => $blogflux_default['blogflux_tagline_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage',
    )
);
$wp_customize->add_control(
    new Blogflux_Range_Slider( 
        $wp_customize,
        'blogflux_tagline_font_size',
        array(
            'label'      => esc_html__( 'Tagline Font Size', 'blogflux' ),
            'settings' => 'blogflux_tagline_font_size',
            'section'       => 'title_tagline',
            'min'        => '1',
            'max'        => '100',
        )
    )
);

$wp_customize->add_setting( 'blogflux_tagline_font_case',
    array(
        'default'           => $blogflux_default['blogflux_tagline_font_case'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'blogflux_tagline_font_case',
    array(
    'label'       => esc_html__( 'Tagline Case', 'blogflux' ),
    'section'     => 'title_tagline',
    'type'        => 'select',
    'choices'               => array(
        'none'      => esc_html__( 'Normal', 'blogflux' ),
        'uppercase' => esc_html__( 'Uppercase', 'blogflux' ),
        'lowercase' => esc_html__( 'Lowercase', 'blogflux' ),
        ),
    )
);

$wp_customize->add_setting(
    'blogflux_premium_notice_header',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new Blogflux_Premium_Notice_Control(
        $wp_customize,
        'blogflux_premium_notice_header',
        array(
            'label'      => esc_html__( 'Header Settings', 'blogflux' ),
            'settings' => 'blogflux_premium_notice_header',
            'section'       => 'header_setting',
        )
    )
);