<?php
/**
* Footer Settings.
*
* @package Blogflux
*/


$wp_customize->add_section( 'footer_settings',
	array(
	'title'      => esc_html__( 'Footer Settings', 'blogflux' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'blogflux_options',
	)
);

$wp_customize->add_setting( 'footer_copyright_text',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'blogflux' ),
	'section'  => 'footer_settings',
	'type'     => 'text',
	)
);

$wp_customize->add_setting(
    'blogflux_premium_notice_footer',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new Blogflux_Premium_Notice_Control( 
        $wp_customize,
        'blogflux_premium_notice_footer',
        array(
            'label'      => esc_html__( 'Footer Settings', 'blogflux' ),
            'settings' => 'blogflux_premium_notice_footer',
            'section'       => 'footer_settings',
        )
    )
);