<?php
/**
* Featured Video Section Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();


$wp_customize->add_section( 'header_featured_video_setting',
    array(
    'title'      => esc_html__( 'Featured Video Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_header_featured_video',
    array(
        'default' => $blogflux_default['enable_header_featured_video'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_featured_video',
    array(
        'label' => esc_html__('Enable Featured Video', 'blogflux'),
        'section' => 'header_featured_video_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('featured_video_section_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_video_section_title',
    array(
        'label' => esc_html__('Featured Video Section Title', 'blogflux'),
        'section' => 'header_featured_video_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('featured_video_section_sub_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_video_section_sub_title',
    array(
        'label' => esc_html__('Featured Video Section Sub-Title', 'blogflux'),
        'section' => 'header_featured_video_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting( 'blogflux_header_featured_video_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'blogflux_header_featured_video_cat',
    array(
    'label'       => esc_html__( 'Featured Video - ', 'blogflux' ),
    'section'     => 'header_featured_video_setting',
    'type'        => 'select',
    'choices'     => $blogflux_post_category_list,
    )
);
