<?php
/**
* Featured Post Section Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();


$wp_customize->add_section( 'header_featured_post_setting',
    array(
    'title'      => esc_html__( 'Featured Post Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_header_featured_post',
    array(
        'default' => $blogflux_default['enable_header_featured_post'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_featured_post',
    array(
        'label' => esc_html__('Enable Featured Post', 'blogflux'),
        'section' => 'header_featured_post_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('featured_post_section_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_post_section_title',
    array(
        'label' => esc_html__('Featured Post Section Title', 'blogflux'),
        'section' => 'header_featured_post_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('featured_post_section_sub_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_post_section_sub_title',
    array(
        'label' => esc_html__('Featured Post Section Sub-Title', 'blogflux'),
        'section' => 'header_featured_post_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting( 'blogflux_header_featured_post_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'blogflux_header_featured_post_cat',
    array(
    'label'       => esc_html__( 'Featured Post Category ', 'blogflux' ),
    'section'     => 'header_featured_post_setting',
    'type'        => 'select',
    'choices'     => $blogflux_post_category_list,
    )
);
