<?php
/**
 * Default Values
 *
 * @package Blogflux
 */

if( !function_exists('blogflux_get_default_theme_options') ):

    /**
     * Get default theme options
     *
     * @return array Default theme options.
     * @since 1.0.0
     *
    */

    function blogflux_get_default_theme_options(){

        $blogflux_defaults = array();

        $blogflux_defaults['blogflux_social_icon_4'] = json_encode( array(
            array(
                'social_svg_icon'     => blogflux_get_theme_svg( 'facebook',true ),
                'social_link'     => '#',
                'label'     => esc_html__('Facebook','blogflux'),
            ),
            array(
                'social_svg_icon'     => blogflux_get_theme_svg( 'twitter',true ),
                'social_link'     => '#',
                'label'     => esc_html__('Twitter','blogflux'),
            ),
            array(
                'social_svg_icon'     => blogflux_get_theme_svg( 'instagram',true ),
                'social_link'     => '#',
                'label'     => esc_html__('Instagram','blogflux'),
            ),
        ) );

        $blogflux_defaults['header_text']                               = esc_html__('Hello World!','blogflux');
        $blogflux_defaults['header_button_label']                       = esc_html__('Learn more','blogflux');

        $blogflux_defaults['enable_header_menu_overlap']             = 1;

        $blogflux_defaults['blogflux_pagination_layout']                  = 'numeric';
        $blogflux_defaults['global_sidebar_layout']             = 'right-sidebar';
        $blogflux_defaults['single_sidebar_layout']             = 'right-sidebar';
        $blogflux_defaults['archive_sidebar_layout']             = 'right-sidebar';
        $blogflux_defaults['enable_recommended_posts']             = 1;
        $blogflux_defaults['enable_facebook']                  = 1;
        $blogflux_defaults['enable_twitter']                   = 1;
        $blogflux_defaults['enable_pinterest']                 = 1;
        $blogflux_defaults['enable_linkedin']                  = 1;
        $blogflux_defaults['enable_email']                     = 1;
        $blogflux_defaults['enable_author_box']                = 1;
        $blogflux_defaults['logo_width']                       = '60';
        $blogflux_defaults['enable_single_related_post']       = 1;

        $blogflux_defaults['enable_subscribe']                 = 0;
        $blogflux_defaults['enable_gallery_slider']                 = 0;
        $blogflux_defaults['enable_header_featured_post']                 = 0;
        $blogflux_defaults['enable_header_featured_video']                 = 0;
        $blogflux_defaults['enable_client_with_link_slider']                 = 0;


        $blogflux_defaults['related_post_title']               = esc_html__('Related Posts','blogflux');
        $blogflux_defaults['subscribe_section_title']          = esc_html__('Newsletter Subscription Us','blogflux');
        $blogflux_defaults['subscribe_section_desc']           = esc_html__("Newsletter Subscription Us and we'll keep you updated with news and information",'blogflux');

        $blogflux_defaults['enable_header_search']             = 1;
        $blogflux_defaults['enable_social_link']               = 1;
        $blogflux_defaults['enable_popup_newsletter']          = 1;
        $blogflux_defaults['popup_newsletter_description']     = esc_html__("Newsletter Subscription Us and we'll keep you updated with news and information",'blogflux');
        $blogflux_defaults['popup_newsletter_title']             = esc_html__('Newsletter Subscription Us','blogflux');
        $blogflux_defaults['404_page_image']             = get_template_directory_uri() . '/assets/images/404-image.jpg';
        $blogflux_defaults['enable_404_recommended_posts'] = 1;
        $blogflux_defaults['ed_floating_next_previous_nav'] = 1;
        $blogflux_defaults['ed_popup_model_box'] = 0;
        $blogflux_defaults['ed_popup_model_box_home_only'] = 0;
        $blogflux_defaults['ed_popup_model_box_first_loading_only'] = 0;
        $blogflux_defaults['wedev_popup_title'] = esc_html__('Sign Up to Our Newsletter', 'blogflux');
        $blogflux_defaults['wedev_popup_desc'] = esc_html__('Get notified about exclusive offers every week!', 'blogflux');
        $blogflux_defaults['enable_404_recommended_posts_title'] = esc_html__('Recommended Posts', 'blogflux');
        $blogflux_defaults['archive_recommended_posts_title'] = esc_html__('More like this', 'blogflux');
        $blogflux_defaults['enable_header_banner'] = 1;
        $blogflux_defaults['enable_header_featured_category'] = 0;

        // Typography.
        $blogflux_defaults['wedev_tagline_font'] = 'Lora';
        $blogflux_defaults['wedev_tagline_font_weight'] = '900';
        $blogflux_defaults['blogflux_tagline_font_size'] = '34';

        $blogflux_defaults['wedev_general_font'] = 'Karla';
        $blogflux_defaults['wedev_general_font_weight'] = 'regular';
        $blogflux_defaults['blogflux_general_font_size'] = '18';

        $blogflux_defaults['wedev_heading_font'] = 'Lora';
        $blogflux_defaults['wedev_heading_font_case'] = 'none';

        $blogflux_defaults['blogflux_h1_font_size'] = '54';
        $blogflux_defaults['blogflux_h2_font_size'] = '42';
        $blogflux_defaults['blogflux_h3_font_size'] = '34';
        $blogflux_defaults['blogflux_h4_font_size'] = '28';
        $blogflux_defaults['blogflux_h5_font_size'] = '24';
        $blogflux_defaults['blogflux_h6_font_size'] = '20';
        $blogflux_defaults['blogflux_h1_font_weight'] = '700';
        $blogflux_defaults['blogflux_h2_font_weight'] = '700';
        $blogflux_defaults['blogflux_h3_font_weight'] = '700';
        $blogflux_defaults['blogflux_h4_font_weight'] = '700';
        $blogflux_defaults['blogflux_h5_font_weight'] = '700';
        $blogflux_defaults['blogflux_h6_font_weight'] = '700';
        $blogflux_defaults['blogflux_tagline_font_case'] = 'none';

        $blogflux_defaults['home_section_order_4'] = array('banner','header_featured_post_setting','featured-category','header_featured_video_setting','client_with_link_slider_setting','latest-posts','gallery_slider_setting' );

        $blogflux_defaults['enable_header_featured_category_column'] = 4;

        // Pass through filter.
        $blogflux_defaults = apply_filters('blogflux_filter_default_theme_options', $blogflux_defaults);

        return $blogflux_defaults;

    }

endif;
