<?php
/**
* Category Section Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();

$wp_customize->add_section( 'client_with_link_slider_setting',
    array(
    'title'      => esc_html__( 'Clients Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_client_with_link_slider',
    array(
        'default' => $blogflux_default['enable_client_with_link_slider'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_client_with_link_slider',
    array(
        'label' => esc_html__('Enable Client With Link Section', 'blogflux'),
        'section' => 'client_with_link_slider_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('client_with_link_section_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('client_with_link_section_title',
    array(
        'label' => esc_html__('Client With Link Section Title', 'blogflux'),
        'section' => 'client_with_link_slider_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('client_with_link_section_sub_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('client_with_link_section_sub_title',
    array(
        'label' => esc_html__('Client With Link Section Sub-Title', 'blogflux'),
        'section' => 'client_with_link_slider_setting',
        'type' => 'text',
    )
);
for ($i=1; $i <= 7 ; $i++) { 
    $wp_customize->add_setting('client_with_link_image_section_'.$i,
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize,
        'client_with_link_image_section_'.$i,
            array(
                'label'      => esc_html__( 'Client With Link Image Upload - ', 'blogflux' ).$i,
                'section'    => 'client_with_link_slider_setting',
            )
        )
    );
    $wp_customize->add_setting('client_with_link_section_url_'.$i,
        array(
            'default' => '',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control('client_with_link_section_url_'.$i,
        array(
            'label' => esc_html__('Client Link URL - ', 'blogflux').$i,
            'section' => 'client_with_link_slider_setting',
            'type' => 'text',
        )
    );
}
