<?php
/**
* Category Section Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();

$wp_customize->add_section( 'header_featured_category_setting',
    array(
    'title'      => esc_html__( 'Featured Category Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_header_featured_category',
    array(
        'default' => $blogflux_default['enable_header_featured_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_featured_category',
    array(
        'label' => esc_html__('Enable Featured Category', 'blogflux'),
        'section' => 'header_featured_category_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('featured_category_section_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_category_section_title',
    array(
        'label' => esc_html__('Featured Category Section Title', 'blogflux'),
        'section' => 'header_featured_category_setting',
        'type' => 'text',
    )
);

$wp_customize->add_setting('featured_category_section_sub_title',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('featured_category_section_sub_title',
    array(
        'label' => esc_html__('Featured Category Section Sub-Title', 'blogflux'),
        'section' => 'header_featured_category_setting',
        'type' => 'text',
    )
);
$wp_customize->add_setting('enable_header_featured_category_column',
    array(
        'default' => $blogflux_default['enable_header_featured_category_column'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control('enable_header_featured_category_column',
    array(
        'label' => esc_html__('Grid Column Layout', 'blogflux'),
        'section' => 'header_featured_category_setting',
        'type' => 'select',
        'choices' => array(
            '2' => esc_html__('Two Column', 'blogflux'),
            '3' => esc_html__('Three Column', 'blogflux'),
            '4' => esc_html__('Four Column', 'blogflux'),
        ),
    )
);
for ($i=1; $i <= 7 ; $i++) { 
    $wp_customize->add_setting( 'blogflux_header_featured_category_cat_'.$i,
        array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_select',
        )
    );
    $wp_customize->add_control( 'blogflux_header_featured_category_cat_'.$i,
        array(
        'label'       => esc_html__( 'Featured Category - ', 'blogflux' ).$i,
        'section'     => 'header_featured_category_setting',
        'type'        => 'select',
        'choices'     => $blogflux_post_category_list,
        )
    );
}
