<?php
/**
* Header Banner Options.
*
* @package Blogflux
*/

$blogflux_default = blogflux_get_default_theme_options();
$blogflux_post_category_list = blogflux_post_category_list();

$wp_customize->add_section( 'header_banner_setting',
    array(
    'title'      => esc_html__( 'Slider Banner Settings', 'blogflux' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'blogflux_home',
    )
);

$wp_customize->add_setting('enable_header_banner',
    array(
        'default' => $blogflux_default['enable_header_banner'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_header_banner',
    array(
        'label' => esc_html__('Enable Slider Banner', 'blogflux'),
        'section' => 'header_banner_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'blogflux_header_banner_cat',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'blogflux_sanitize_select',
    )
);
$wp_customize->add_control( 'blogflux_header_banner_cat',
    array(
    'label'       => esc_html__( 'Slider Post Category', 'blogflux' ),
    'section'     => 'header_banner_setting',
    'type'        => 'select',
    'choices'     => $blogflux_post_category_list,
    )
);