<?php
/**
 * Archive Settings.
 *
 * @package Blogflux
**/

$blogflux_default = blogflux_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'archive_setting',
	array(
	'title'      => esc_html__( 'Archive Settings', 'blogflux' ),
	'capability' => 'edit_theme_options',
	'panel'      => 'blogflux_options',
	)
);

$wp_customize->add_setting('enable_recommended_posts',
    array(
        'default' => $blogflux_default['enable_recommended_posts'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'blogflux_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_recommended_posts',
    array(
        'label' => esc_html__('Enable Related Posts', 'blogflux'),
        'section' => 'archive_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('archive_recommended_posts_title',
    array(
        'default' => $blogflux_default['archive_recommended_posts_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('archive_recommended_posts_title',
    array(
        'label' => esc_html__('Recommended Posts Title', 'blogflux'),
        'section' => 'archive_setting',
        'type' => 'text',
    )
);