<?php
/**
 * Featured Category Section.
 *
 * @package Blogflux
 */

if ( !function_exists('blogflux_client_section') ) :

    function blogflux_client_section(){

        $blogflux_default = blogflux_get_default_theme_options();
        $enable_client_with_link_slider = get_theme_mod( 'enable_client_with_link_slider', $blogflux_default['enable_client_with_link_slider'] );
        $client_with_link_section_title = get_theme_mod( 'client_with_link_section_title' );
        $client_with_link_section_sub_title = get_theme_mod( 'client_with_link_section_sub_title');
        if( $enable_client_with_link_slider ){
         ?>
            <section class="wedevs-featured-on wedevs-block">
                <div class="site-wrapper">
                    <div class="site-row">
                        <div class="site-column site-column-12">
                            <?php if (!empty($client_with_link_section_title) || !empty($client_with_link_section_sub_title)) { ?>
                                <div class="wedevs-section-head text-center mb-48">
                                    <?php if (!empty($client_with_link_section_title)) { ?>
                                        <h2 class="font-size-big mb-8">
                                            <?php echo esc_html($client_with_link_section_title); ?>
                                        </h2>
                                    <?php } ?>
                                    <?php if (!empty($client_with_link_section_sub_title)) { ?>
                                    <p class = "m-0">
                                        <?php echo esc_html($client_with_link_section_sub_title); ?>
                                    </p>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            <div class="featured-carousel-container swiper">
                                <div class="swiper-wrapper">
                                    <?php
                                    for( $i = 1; $i <= 6; $i++  ){
                                    $logo_with_link_image_section = get_theme_mod('logo_with_link_image_section_'.$i);
                                    $logo_with_link_image_url = get_theme_mod('client_with_link_section_url_'.$i); ?>
                                        <?php if (!empty($logo_with_link_image_section)) { ?>
                                            <div class="swiper-slide">
                                                <div class="image-size-thumbnail wedevs-optimize-image">
                                                    <a href="<?php echo esc_url($logo_with_link_image_url); ?>"><img src="<?php echo esc_url($logo_with_link_image_section); ?>" alt=""></a>s
                                                </div>
                                            </div>
                                        <?php } ?>
                                    <?php } ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php
        }

    }

endif;