<?php
/**
 * Blogflux Dynamic Styles
 *
 * @package Blogflux
 */


function blogflux_dynamic_css_generate( $wedev_font_weight = false, $class = '' ){

    if( $wedev_font_weight ){

        $generated_css = '';
        if( $wedev_font_weight == 'regular' ){
            $wedev_font_weight = '400';
        }
        if( $wedev_font_weight != 'italic' && strpos($wedev_font_weight, 'italic') !== false) {

            $wedev_font_weight_exp = explode( 'italic',$wedev_font_weight);
            
            $font_weight = isset( $wedev_font_weight_exp[0] ) ? $wedev_font_weight_exp[0] : '';
            $font_style = isset( $wedev_font_weight_exp[1] ) ? $wedev_font_weight_exp[1] : '';
            if( $font_weight ){
                $generated_css .= "{$class}{font-weight: {$font_weight};}";
                $generated_css .= "{$class}{font-style: italic;}";
            }
        }else{

            if( $wedev_font_weight == 'italic'){
                $generated_css .= "{$class}{font-style: {$wedev_font_weight};}";    
            }else{
                $generated_css .= "{$class}{font-weight: {$wedev_font_weight};}";
            }
        }

        return $generated_css;

    }

    return false;

}

function blogflux_dynamic_css(){

    $dynamic_css = "";
    $blogflux_default = blogflux_get_default_theme_options();
    $logo_width = esc_attr(get_theme_mod('logo_width', $blogflux_default['logo_width']));
    $wedev_tagline_font = esc_attr(get_theme_mod('wedev_tagline_font', $blogflux_default['wedev_tagline_font']));
    $wedev_tagline_font_weight = esc_attr(get_theme_mod('wedev_tagline_font_weight', $blogflux_default['wedev_tagline_font_weight']));
    if( $wedev_tagline_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $wedev_tagline_font_weight, '.site-branding .site-title' );
    }

    $blogflux_tagline_font_size = esc_attr(get_theme_mod('blogflux_tagline_font_size', $blogflux_default['blogflux_tagline_font_size']));
    $blogflux_tagline_font_case = esc_attr(get_theme_mod('blogflux_tagline_font_case', $blogflux_default['blogflux_tagline_font_case']));

    $wedev_general_font = esc_attr(get_theme_mod('wedev_general_font', $blogflux_default['wedev_general_font']));
    $wedev_general_font_weight = esc_attr(get_theme_mod('wedev_general_font_weight', $blogflux_default['wedev_general_font_weight']));
    if( $wedev_general_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $wedev_general_font_weight, 'body, button, input, select, optgroup, textarea' );
    }

    $wedev_heading_font = esc_attr(get_theme_mod('wedev_heading_font', $blogflux_default['wedev_heading_font']));

    $wedev_heading_font_case = esc_attr(get_theme_mod('wedev_heading_font_case', $blogflux_default['wedev_heading_font_case']));

    $blogflux_general_font_size = absint(get_theme_mod('blogflux_general_font_size', $blogflux_default['blogflux_general_font_size']));
    $blogflux_h1_font_size = absint(get_theme_mod('blogflux_h1_font_size', $blogflux_default['blogflux_h1_font_size']));
    $blogflux_h2_font_size = absint(get_theme_mod('blogflux_h2_font_size', $blogflux_default['blogflux_h2_font_size']));
    $blogflux_h3_font_size = absint(get_theme_mod('blogflux_h3_font_size', $blogflux_default['blogflux_h3_font_size']));
    $blogflux_h4_font_size = absint(get_theme_mod('blogflux_h4_font_size', $blogflux_default['blogflux_h4_font_size']));
    $blogflux_h5_font_size = absint(get_theme_mod('blogflux_h5_font_size', $blogflux_default['blogflux_h5_font_size']));
    $blogflux_h6_font_size = absint(get_theme_mod('blogflux_h6_font_size', $blogflux_default['blogflux_h6_font_size']));

    $blogflux_h1_font_weight = esc_attr(get_theme_mod('blogflux_h1_font_weight', $blogflux_default['blogflux_h1_font_weight']));
    if( $blogflux_h1_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h1_font_weight, '.h1,.font-size-large' );
    }

    $blogflux_h2_font_weight = esc_attr(get_theme_mod('blogflux_h2_font_weight', $blogflux_default['blogflux_h2_font_weight']));
    if( $blogflux_h2_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h2_font_weight, '.h2,.font-size-big' );
    }

    $blogflux_h3_font_weight = esc_attr(get_theme_mod('blogflux_h3_font_weight', $blogflux_default['blogflux_h3_font_weight']));
    if( $blogflux_h3_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h3_font_weight, '.h3,.font-size-medium' );
    }

    $blogflux_h4_font_weight = esc_attr(get_theme_mod('blogflux_h4_font_weight', $blogflux_default['blogflux_h4_font_weight']));
    if( $blogflux_h4_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h4_font_weight, '.h4,h4' );
    }

    $blogflux_h5_font_weight = esc_attr(get_theme_mod('blogflux_h5_font_weight', $blogflux_default['blogflux_h5_font_weight']));
    if( $blogflux_h5_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h5_font_weight, '.h5,h5' );
    }

    $blogflux_h6_font_weight = esc_attr(get_theme_mod('blogflux_h6_font_weight', $blogflux_default['blogflux_h6_font_weight']));
    if( $blogflux_h6_font_weight ){
        $dynamic_css .= blogflux_dynamic_css_generate( $blogflux_h6_font_weight, '.h6,h6' );
    }


    $dynamic_css .= " 
.site-logo img{width: {$logo_width}px;}
.site-branding .site-title{font-family: {$wedev_tagline_font};}
.site-branding .site-title{font-size: {$blogflux_tagline_font_size}px;}
.site-branding .site-title{text-transform: {$blogflux_tagline_font_case};}
:root {
 --primary-font-family: {$wedev_general_font};
 --secondary-font-family: {$wedev_heading_font};
}

body, button, input, select, optgroup, textarea{font-size: {$blogflux_general_font_size}px;}
        
h1,h2,h3,h4,h5,h6{text-transform: {$wedev_heading_font_case};}
                              
@media (min-width: 992px) {                  
h1,.font-size-large{font-size:{$blogflux_h1_font_size}px;}
h2,.font-size-big{font-size:{$blogflux_h2_font_size}px;}
h3,.font-size-medium{font-size: {$blogflux_h3_font_size}px;}
h4{font-size:{$blogflux_h4_font_size}px;}
h5{font-size:{$blogflux_h5_font_size}px;}
h6,.font-size-small{font-size:{$blogflux_h6_font_size}px;}
}
        ";

    wp_add_inline_style('blogflux-style', $dynamic_css);
}

add_action('wp_enqueue_scripts', 'blogflux_dynamic_css'); ?>