<?php
/**
 * Describe child theme functions
 *
 * @package Blogbuster
 * @subpackage Blogarea
 * @since 1.0.0
 */

    add_action( 'wp_enqueue_scripts', 'blogarea_enqueue_styles' );
    
    function blogarea_enqueue_styles() {
    
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'parent-style' ) );
}

/*------------------------- Customizer Section --------------------------------*/

    if ( ! function_exists( 'blogarea_customize_register' ) ) :

        /**
         * Managed all the customizer field for theme.
         */
        function blogarea_customize_register( $wp_customize ) {

            global $wp_customize;

            /**
             * Blogarea Default Primary Color.
             *
             * @since 1.0.0
             */
            $wp_customize->get_setting( 'blogbuster_primary_theme_color' )->default = '#31545e';

        }

    endif;

    
   add_action( 'customize_register', 'blogarea_customize_register', 20 );

/*---------------------- General CSS ---------------------------*/

    if ( ! function_exists( 'blogarea_general_css' ) ) :

        /**
         * Handles the general CSS.
         * 
         * @since 1.0.0
         */
        function blogarea_general_css( $output_css ) {
            $blogarea_primary_theme_color = get_theme_mod( 'blogbuster_primary_theme_color', '#31545e' );

            //define variable for custom css
            $custom_css = '';

            // Background Color
            $custom_css .= "
            .trending-posts-wrapper .post-cat-item a, .latest-posts-wrapper .post-cat-item a, .bttn:hover,button,input[type='button']:hover,input[type='reset']:hover,input[type='submit']:hover,.reply .comment-reply-link,.widget_search .search-submit,.widget_search .search-submit:hover,.widget_tag_cloud .tagcloud a:hover,.widget.widget_tag_cloud a:hover,.read-more-button:hover a,.edit-link a,#site-navigation ul.sub-menu, #site-navigation ul.children,.wp-block-search__button,.responsive-menu-icon-wrapper #site-navigation .primary-menu-wrap,#site-navigation ul li a.mt-sub-menu-toggle:hover,  .single .post-cat-item a,
            #site-navigation ul li a.mt-sub-menu-toggle:focus,.header-search-wrapper .mt-search-icon a i ,.site-footer, .header-search-wrapper .search-form-wrap .search-submit, #mt-scrollup ,.mt-front-sticky-post-wrapper .post-cat-item a,.trending-posts .post-thumbnail-wrap .post-count,.entry-title a::after,.mt-wave .mt-rect,.mt-three-bounce .mt-child,.mt-folding-cube .mt-cube:before {background-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // Color
           $custom_css .= ".nav-content:hover,a:hover,a:focus,a:active,.entry-cat .cat-links a:hover,.entry-cat a:hover,.byline a:hover,.posted-on a:hover,.entry-footer a:hover,.comment-author .fn .url:hover,.commentmetadata .comment-edit-link,#cancel-comment-reply-link,#cancel-comment-reply-link:before,.logged-in-as a,.widget a:hover,.widget a:hover::before,.widget li:hover::before,.post-cat-item a:hover, .featured-info-wrap:hover a,.featured-info-wrap:hover span, .published.updated:hover,.published:hover, .author:hover,.entry-meta span:hover::before,.entry-meta span:hover::before,.site-info .sep,.author-website a ,#secondary .widget .widget-title, .wp-block-heading, .mt-related-post-title,.wp-block-search__label,#site-navigation ul li a.mt-sub-menu-toggle,span.tags-links:hover, .mt-front-sticky-post-wrapper .post-cat-item a:hover,.mt-front-sticky-post-wrapper .tags-links a:hover,.widget-title,.mt-menu-toggle:hover{color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // Border Color
            $custom_css .= ".navigation .nav-links a:hover{border-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // Border Left Color
            $custom_css .= ".page-header .page-title{border-left-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // RTL Border Right Color
            $custom_css .= ".rtl .page-header .page-title,{border-right-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // Border Top Color
            $custom_css .= "#site-navigation .menu-item-description::after,.search-form-wrap{border-top-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            // Woocommerce Dynamic color

            $custom_css .= ".woocommerce ul.products li.product .price,.woocommerce div.product p.price, .woocommerce div.product span.price,.woocommerce .product_meta a:hover,.woocommerce-error:before, .woocommerce-info:before, .woocommerce-message:before{color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            $custom_css .= ".woocommerce div.product .woocommerce-tabs ul.tabs{border-bottom-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";

            $custom_css .= ".woocommerce-error, .woocommerce-info, .woocommerce-message{border-top-color: ". esc_attr( $blogarea_primary_theme_color ) ."}\n";
            
            if ( ! empty( $custom_css ) ) {
                $output_css .= $custom_css;
            }

            return $output_css;
        }

    endif;

    add_filter( 'blogbuster_head_css', 'blogarea_general_css', 999 );