<?php
    /**
     * Template Name: Web Stories
     */
    use BlogPostx\CustomizerDefault as BPX;
    get_header();

        $image_hover = BPX\blog_postx_get_customizer_option( 'site_image_hover_effects' );
        $image_size = BPX\blog_postx_get_customizer_option( 'web_stories_image_sizes' );
        $show_preview_count = true;
        $show_preview_title = true;

        $sectionClass[] = 'blog-postx-web-stories';
        $sectionClass[] = 'hover--' . $image_hover;
        $categories = get_categories([
            'hide_empty'    =>  true
        ]);

        ?>
            <section class="<?php echo esc_attr( implode( ' ', $sectionClass ) ); ?>">
                <div class="blog-postx-container">
                    <div class="row">
                        <h2 class="section-title"><span class="divider"></span><span class="title"><?php esc_html_e( 'Today\'s Stories', 'blog-postx' ); ?></span></h2>
                        <div class="stories-wrap">
                            <?php
                                if( ! is_null( $categories ) && is_array( $categories ) ) :
                                    foreach( $categories as $cat_key => $cat_value ) :
                                        $category_query_args = [
                                            'cat'   =>  absint( $cat_value->term_id ),
                                            'meta_query'    =>  [
                                                [
                                                    'key'   =>  '_thumbnail_id',
                                                    'compare'   =>  'EXISTS'
                                                ]
                                            ],
                                            'ignore_stick_posts'    =>  true,
                                            'fields'    =>  'ids',
                                            'no_found_rows' =>  true
                                        ];
                                        $category_query = new WP_Query( apply_filters( 'blog_postx_query_args_filter', $category_query_args ) );
                                        $preview_title = '';
                                        if( $category_query->have_posts() ) :
                                            $first_post = $category_query->posts[0];
                                            $thumbnail_id = ( $first_post != null ) ? $first_post : '';
                                            $preview_title = get_the_title( $first_post );
                                        else:
                                            $thumbnail_id = '';
                                        endif;
                                        $category_count = $cat_value->count;

                                        ?>
                                            <div class="story" data-id="<?php echo esc_attr( $cat_value->term_id ); ?>" data-count="<?php echo esc_attr( $category_count ); ?>">
                                                <div class="preview">
                                                    <?php
                                                        echo '<figure class="preview-thumb">';
                                                            if( $thumbnail_id ) echo wp_kses_post( get_the_post_thumbnail( $thumbnail_id, $image_size, [ 'loading'   => 'lazy' ] ) );
                                                        echo '</figure>';

                                                        echo '<a href="', esc_url( get_category_link( $cat_value->term_id ) ) ,'" class="item"><span class="label">', esc_html( $cat_value->name ), '</span></a>';

                                                        if( $show_preview_count ) echo '<a href="', esc_url( get_category_link( $cat_value->term_id ) ) ,'" class="story-count"><span class="label">', esc_html( $category_count ), '</span><span class="text">', esc_html__( ' Stories', 'blog-postx' ), '</span></a>';

                                                        if( $preview_title && $show_preview_title ) echo '<div class="story-title-wrap"><h2 class="story-title"><span class="title-text">', esc_html( $preview_title ) ,'</span></h2></div>';

                                                        echo '<div class="indicators">';

                                                            if( $category_count ) :

                                                                for( $i = 0; $i < $category_count; $i++ ) :

                                                                    echo '<span class="indicator"></span>';

                                                                endfor;
                                                            endif;

                                                        echo '</div>';
                                                    ?>
                                                </div>
                                            </div>
                                        <?php
                                    endforeach;
                                endif;
                            ?>
                        </div>
                        <div class="inner-stories-wrap">
                            <div class="inner-stories"></div>
                            <div class="action-buttons">
                                <button class="action-btn close"><i class="fa-solid fa-xmark"></i></button>
                                <button class="action-btn pause"><i class="fa-solid fa-pause"></i></button>
                            </div>
                            <div class="story-arrows"></div>
                        </div>
                    </div>
                </div>
            </section>
        <?php

    get_footer();